/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.eaio.uuid.UUID;
import com.erudika.para.annotations.Email;
import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.Votable;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.i18n.CurrencyUtils;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotBlank;

public class User
implements ParaObject {
    private static final long serialVersionUID = 1L;
    @Stored
    @Locked
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    private Boolean stored;
    @Stored
    private Boolean indexed;
    @Stored
    private Boolean cached;
    @Stored
    @NotBlank
    private String identifier;
    @Stored
    @Locked
    @NotBlank
    private String groups;
    @Stored
    private Boolean active;
    @Stored
    @NotBlank
    @Email
    private String email;
    @Stored
    private String currency;
    @Stored
    private String picture;
    @Stored
    private String lastIp;
    @Stored
    @Locked
    private String tokenSecret;
    private transient String password;

    public User() {
        this(null);
    }

    public User(String id) {
        this.setId(id);
        this.setName(this.getName());
        this.groups = Groups.USERS.toString();
    }

    @JsonIgnore
    public String getTokenSecret() {
        if (this.tokenSecret == null) {
            this.resetTokenSecret();
        }
        return this.tokenSecret;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    @JsonIgnore
    public String getLastIp() {
        return this.lastIp;
    }

    public void setLastIp(String lastIp) {
        this.lastIp = lastIp;
    }

    public String getPicture() {
        return StringUtils.isBlank((CharSequence)this.picture) ? "https://www.gravatar.com/avatar?d=mm&size=400" : this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public Boolean getActive() {
        if (this.active == null) {
            this.active = false;
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        currency = StringUtils.upperCase((String)currency);
        if (!CurrencyUtils.getInstance().isValidCurrency(currency)) {
            currency = "EUR";
        }
        this.currency = currency;
    }

    public void resetTokenSecret() {
        this.tokenSecret = Utils.generateSecurityToken();
    }

    public boolean canModify(ParaObject obj) {
        if (obj == null || this.id == null) {
            return false;
        }
        boolean isCreatedByMe = obj.getCreatorid() != null && (obj.getCreatorid().startsWith(this.id + Config.SEPARATOR) || this.id.equals(obj.getCreatorid()));
        boolean mine = isCreatedByMe || this.id.equals(obj.getId()) || this.id.equals(obj.getParentid());
        return mine || this.isAdmin();
    }

    @Override
    public String create() {
        if (StringUtils.isBlank((CharSequence)this.getIdentifier())) {
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)this.getPassword()) && this.getPassword().length() < Config.MIN_PASS_LENGTH) {
            return null;
        }
        if (!Config.ADMIN_IDENT.isEmpty() && Config.ADMIN_IDENT.equals(this.getIdentifier())) {
            this.setGroups(Groups.ADMINS.toString());
        } else {
            this.setGroups(Groups.USERS.toString());
        }
        this.setGravatarPicture();
        if (StringUtils.isBlank((CharSequence)this.tokenSecret)) {
            this.resetTokenSecret();
        }
        if (CoreUtils.getInstance().getDao().create(this.getAppid(), this) != null) {
            this.createIdentifier(this.getId(), this.getIdentifier(), this.getPassword());
        }
        return this.getId();
    }

    @Override
    public void delete() {
        if (this.getId() != null) {
            CoreUtils.getInstance().getDao().deleteAll(this.getAppid(), this.getIdentifiers());
            CoreUtils.getInstance().getDao().delete(this.getAppid(), this);
        }
    }

    @JsonIgnore
    public List<Sysprop> getIdentifiers() {
        return CoreUtils.getInstance().getSearch().findTerms(this.getAppid(), Utils.type(Sysprop.class), Collections.singletonMap("creatorid", this.getId()), true, new Pager[0]);
    }

    public void attachIdentifier(String identifier) {
        if (this.exists()) {
            this.createIdentifier(this.getId(), identifier);
        }
    }

    public void detachIdentifier(String identifier) {
        Sysprop s;
        if (!StringUtils.equals((CharSequence)identifier, (CharSequence)this.getIdentifier()) && (s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), identifier)) != null && StringUtils.equals((CharSequence)this.getId(), (CharSequence)s.getCreatorid())) {
            this.deleteIdentifier(identifier);
        }
    }

    @JsonIgnore
    public boolean isFacebookUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)Config.FB_PREFIX);
    }

    @JsonIgnore
    public boolean isGooglePlusUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)Config.GPLUS_PREFIX);
    }

    @JsonIgnore
    public boolean isLinkedInUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)Config.LINKEDIN_PREFIX);
    }

    @JsonIgnore
    public boolean isTwitterUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)Config.TWITTER_PREFIX);
    }

    @JsonIgnore
    public boolean isGitHubUser() {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.identifier, (CharSequence)Config.GITHUB_PREFIX);
    }

    @JsonIgnore
    public boolean isAdmin() {
        return StringUtils.equalsIgnoreCase((CharSequence)this.groups, (CharSequence)Groups.ADMINS.toString());
    }

    @JsonIgnore
    public boolean isModerator() {
        return this.isAdmin() ? true : StringUtils.equalsIgnoreCase((CharSequence)this.groups, (CharSequence)Groups.MODS.toString());
    }

    public String getIdentityProvider() {
        if (this.isFacebookUser()) {
            return "facebook";
        }
        if (this.isGooglePlusUser()) {
            return "google";
        }
        if (this.isGitHubUser()) {
            return "github";
        }
        if (this.isTwitterUser()) {
            return "twitter";
        }
        if (this.isLinkedInUser()) {
            return "linkedin";
        }
        return "none";
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static final User readUserForIdentifier(User u) {
        User user;
        if (u == null || StringUtils.isBlank((CharSequence)u.getIdentifier())) {
            return null;
        }
        String identifier = u.getIdentifier();
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(u.getAppid(), identifier);
        if (s != null && s.getCreatorid() != null && (user = (User)CoreUtils.getInstance().getDao().read(u.getAppid(), s.getCreatorid())) != null) {
            if (!identifier.equals(user.getIdentifier())) {
                user.setIdentifier(identifier);
                CoreUtils.getInstance().getDao().update(user);
            }
            user.setPassword((String)s.getProperty("password"));
            return user;
        }
        return null;
    }

    public static final boolean passwordMatches(User u) {
        if (u == null) {
            return false;
        }
        String password = u.getPassword();
        String identifier = u.getIdentifier();
        if (StringUtils.isBlank((CharSequence)password) || StringUtils.isBlank((CharSequence)identifier)) {
            return false;
        }
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(u.getAppid(), identifier);
        if (s != null) {
            String storedHash = (String)s.getProperty("password");
            return Utils.bcryptMatches(password, storedHash);
        }
        return false;
    }

    public final String generatePasswordResetToken() {
        if (StringUtils.isBlank((CharSequence)this.identifier)) {
            return "";
        }
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        if (s != null) {
            String token = Utils.generateSecurityToken(42, true);
            s.addProperty("token", token);
            CoreUtils.getInstance().getDao().update(this.getAppid(), s);
            return token;
        }
        return "";
    }

    public final boolean resetPassword(String token, String newpass) {
        if (StringUtils.isBlank((CharSequence)newpass) || StringUtils.isBlank((CharSequence)token) || newpass.length() < Config.MIN_PASS_LENGTH) {
            return false;
        }
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        if (this.isValidToken(s, "token", token)) {
            s.removeProperty("token");
            String hashed = Utils.bcrypt(newpass);
            s.addProperty("password", hashed);
            this.setPassword(hashed);
            CoreUtils.getInstance().getDao().update(this.getAppid(), s);
            return true;
        }
        return false;
    }

    private boolean createIdentifier(String userid, String newIdent) {
        return this.createIdentifier(userid, newIdent, null);
    }

    private boolean createIdentifier(String userid, String newIdent, String password) {
        if (StringUtils.isBlank((CharSequence)userid) || StringUtils.isBlank((CharSequence)newIdent)) {
            return false;
        }
        Sysprop s = new Sysprop();
        s.setId(newIdent);
        s.setName("identifier");
        s.setCreatorid(userid);
        if (!StringUtils.isBlank((CharSequence)password)) {
            String hashed = Utils.bcrypt(password);
            s.addProperty("password", hashed);
            this.setPassword(hashed);
        }
        return CoreUtils.getInstance().getDao().create(this.getAppid(), s) != null;
    }

    private void deleteIdentifier(String ident) {
        if (!StringUtils.isBlank((CharSequence)ident)) {
            CoreUtils.getInstance().getDao().delete(this.getAppid(), new Sysprop(ident));
        }
    }

    public String generateEmailConfirmationToken() {
        if (StringUtils.isBlank((CharSequence)this.identifier)) {
            return "";
        }
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        if (s != null) {
            String token = Utils.base64encURL(new UUID().toString().getBytes());
            s.addProperty("etoken", token);
            CoreUtils.getInstance().getDao().update(this.getAppid(), s);
            return token;
        }
        return "";
    }

    public final boolean activateWithEmailToken(String token) {
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        if (this.isValidToken(s, "etoken", token)) {
            s.removeProperty("etoken");
            CoreUtils.getInstance().getDao().update(this.getAppid(), s);
            this.setActive(true);
            this.update();
            return true;
        }
        return false;
    }

    public final boolean isValidPasswordResetToken(String token) {
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        return this.isValidToken(s, "token", token);
    }

    public final boolean isValidEmailConfirmationToken(String token) {
        Sysprop s = (Sysprop)CoreUtils.getInstance().getDao().read(this.getAppid(), this.identifier);
        return this.isValidToken(s, "etoken", token);
    }

    private boolean isValidToken(Sysprop s, String key, String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        if (s != null && s.hasProperty(key)) {
            String storedToken = (String)s.getProperty(key);
            long timeout = Config.PASSRESET_TIMEOUT_SEC * 1000L;
            if (StringUtils.equals((CharSequence)storedToken, (CharSequence)token) && s.getUpdated() + timeout > Utils.timestamp()) {
                return true;
            }
        }
        return false;
    }

    private void setGravatarPicture() {
        if (StringUtils.isBlank((CharSequence)this.picture)) {
            if (this.email != null) {
                String emailHash = Utils.MD5(this.email);
                this.setPicture("https://www.gravatar.com/avatar/" + emailHash + "?size=400&d=mm&r=pg");
            } else {
                this.setPicture("https://www.gravatar.com/avatar?d=mm&size=400");
            }
        }
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public final String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Config.APP_NAME_NS : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getInstance().getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Boolean getStored() {
        if (this.stored == null) {
            this.stored = true;
        }
        return this.stored;
    }

    @Override
    public void setStored(Boolean stored) {
        this.stored = stored;
    }

    @Override
    public Boolean getIndexed() {
        if (this.indexed == null) {
            this.indexed = true;
        }
        return this.indexed;
    }

    @Override
    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public Boolean getCached() {
        if (this.cached == null) {
            this.cached = true;
        }
        return this.cached;
    }

    @Override
    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getInstance().getName(this.name, this.id);
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public void update() {
        CoreUtils.getInstance().getDao().update(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return CoreUtils.getInstance().getDao().read(this.getAppid(), this.getId()) != null;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.getInstance().countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getInstance().getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getInstance().getLinkedObjects(this, type, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.getInstance().isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.getInstance().isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.getInstance().link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.getInstance().unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.getInstance().unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.getInstance().countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.getInstance().deleteChildren(this, type);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id) + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParaObject other = (ParaObject)obj;
        return Objects.equals(this.id, other.getId());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }

    public static enum Roles {
        USER,
        MOD,
        ADMIN;


        public String toString() {
            return "ROLE_".concat(this.name());
        }
    }

    public static enum Groups {
        USERS,
        MODS,
        ADMINS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

