/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.utils;

import com.erudika.para.core.ParaObject;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.HumanTime;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jsoup.Jsoup;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final Pattern emailz = Pattern.compile("[A-Za-z0-9.%+_\\-]+@[A-Za-z0-9.\\-]+\\.[A-Za-z\\S]{2,4}$");
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    private static final MustacheFactory mustache;
    private static HumanTime humantime;
    private static Utils instance;
    private static final long TIMER_OFFSET = 1310084584692L;
    private static final long workerIdBits = 5L;
    private static final long dataCenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDataCenterId = 31L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long dataCenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private static long lastTimestamp;
    private static long dataCenterId;
    private static long workerId;
    private static long sequence;

    private Utils() {
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public static HumanTime getHumanTime() {
        if (humantime == null) {
            humantime = new HumanTime();
        }
        return humantime;
    }

    private static void initIdGenerator() {
        String workerID = Config.WORKER_ID;
        workerId = NumberUtils.toLong((String)workerID, (long)1L);
        if (workerId > 31L || workerId < 0L) {
            workerId = new Random().nextInt(32);
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            dataCenterId = new Random().nextInt(32);
        }
    }

    public static String MD5(String s) {
        if (s == null) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes());
            byte[] byteData = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return "";
        }
    }

    public static String bcrypt(String s) {
        return s == null ? s : BCrypt.hashpw((String)s, (String)BCrypt.gensalt((int)12));
    }

    public static boolean bcryptMatches(String plain, String storedHash) {
        if (StringUtils.isBlank((CharSequence)plain) || StringUtils.isBlank((CharSequence)storedHash)) {
            return false;
        }
        try {
            return BCrypt.checkpw((String)plain, (String)storedHash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String generateSecurityToken(int length, boolean urlSafe) {
        SecureRandom rand;
        byte[] bytes = new byte[length];
        try {
            rand = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(null, (Throwable)ex);
            rand = new SecureRandom();
        }
        rand.nextBytes(bytes);
        return urlSafe ? Utils.base64encURL(bytes) : Utils.base64enc(bytes);
    }

    public static String generateSecurityToken(int length) {
        return Utils.generateSecurityToken(length, false);
    }

    public static String generateSecurityToken() {
        return Utils.generateSecurityToken(32);
    }

    public static String escapeJavascript(String str) {
        return str == null ? "" : StringEscapeUtils.escapeEcmaScript((String)str);
    }

    public static String stripHtml(String html) {
        return html == null ? "" : Jsoup.parse((String)html).text();
    }

    public static String markdownToHtml(String markdownString) {
        return StringUtils.isBlank((CharSequence)markdownString) ? "" : Processor.process((String)markdownString, (Configuration)Configuration.DEFAULT_SAFE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compileMustache(Map<String, Object> scope, String template) {
        if (scope == null || StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        StringWriter writer = new StringWriter();
        try {
            mustache.compile((Reader)new StringReader(template), Utils.MD5(template)).execute((Writer)writer, scope);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                logger.error(null, (Throwable)e);
            }
        }
        return ((Object)writer).toString();
    }

    public static String abbreviate(String str, int max) {
        return StringUtils.isBlank((CharSequence)str) ? "" : StringUtils.abbreviate((String)str, (int)max);
    }

    public static String arrayJoin(List<String> arr, String separator) {
        return arr == null || separator == null ? "" : StringUtils.join(arr, (String)separator);
    }

    public static String stripAndTrim(String str) {
        return Utils.stripAndTrim(str, "");
    }

    public static String stripAndTrim(String str, String replaceWith) {
        return StringUtils.isBlank((CharSequence)str) ? "" : str.replaceAll("[\\p{S}\\p{P}\\p{C}]", replaceWith).replaceAll("\\p{Z}+", " ").trim();
    }

    public static String noSpaces(String str, String replaceWith) {
        return StringUtils.isBlank((CharSequence)str) ? "" : str.trim().replaceAll("[\\p{C}\\p{Z}]+", StringUtils.trimToEmpty((String)replaceWith)).toLowerCase();
    }

    public static String formatMessage(String msg, Object ... params) {
        try {
            msg = StringUtils.replace((String)msg, (String)"'", (String)"''");
            return StringUtils.isBlank((CharSequence)msg) ? "" : MessageFormat.format(msg, params);
        }
        catch (IllegalArgumentException e) {
            return msg;
        }
    }

    public static String base64enc(byte[] str) {
        if (str == null) {
            return "";
        }
        return new String(Base64.encodeBase64((byte[])str));
    }

    public static String base64encURL(byte[] str) {
        if (str == null) {
            return "";
        }
        return new String(Base64.encodeBase64URLSafe((byte[])str));
    }

    public static String base64dec(String str) {
        if (str == null) {
            return "";
        }
        try {
            return new String(Base64.decodeBase64((String)str), Config.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    public static String formatDate(Long timestamp, String format, Locale loc) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = DateFormatUtils.ISO_DATE_FORMAT.getPattern();
        }
        if (timestamp == null) {
            timestamp = Utils.timestamp();
        }
        if (loc == null) {
            loc = Locale.US;
        }
        return DateFormatUtils.format((long)timestamp, (String)format, (Locale)loc);
    }

    public static String formatDate(String format, Locale loc) {
        return Utils.formatDate(Utils.timestamp(), format, loc);
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static long timestamp() {
        return System.currentTimeMillis();
    }

    public static String[] getMonths(Locale locale) {
        if (locale == null) {
            locale = Locale.US;
        }
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        return dfs.getMonths();
    }

    public static int round(float d) {
        return Math.round(d);
    }

    public static String formatPrice(double price) {
        return numberFormat.format(price);
    }

    public static double roundHalfUp(double d) {
        return Utils.roundHalfUp(d, 2);
    }

    public static double roundHalfUp(double d, int scale) {
        return BigDecimal.valueOf(d).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static String abbreviateInt(Number number, int decPlaces) {
        if (number == null) {
            return "";
        }
        String abbrevn = number.toString();
        decPlaces = (int)Math.pow(10.0, decPlaces);
        String[] abbrev = new String[]{"K", "M", "B", "T"};
        boolean done = false;
        for (int i = abbrev.length - 1; i >= 0 && !done; --i) {
            int size = (int)Math.pow(10.0, (i + 1) * 3);
            if (size > number.intValue()) continue;
            number = Math.round(number.intValue() * decPlaces / size) / decPlaces;
            abbrevn = number + abbrev[i];
            done = true;
        }
        return abbrevn;
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return "";
        }
        String decoded = s;
        try {
            decoded = URLDecoder.decode(s, Config.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(null, (Throwable)ex);
        }
        return decoded;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return "";
        }
        String encoded = s;
        try {
            encoded = URLEncoder.encode(s, Config.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(null, (Throwable)ex);
        }
        return encoded;
    }

    public static boolean isValidURL(String url) {
        return Utils.toURL(url) != null;
    }

    public static boolean isValidEmail(String url) {
        return emailz.matcher(url).matches();
    }

    public static String getHostFromURL(String url) {
        URL u = Utils.toURL(url);
        String host = u == null ? "" : u.getHost();
        return host;
    }

    public static String getBaseURL(String url) {
        URL u = Utils.toURL(url);
        String base = null;
        if (u != null) {
            try {
                base = u.toURI().getScheme().concat("://").concat(u.getAuthority());
            }
            catch (URISyntaxException ex) {
                base = null;
            }
        }
        return base;
    }

    private static URL toURL(String url) {
        URL u;
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            u = null;
        }
        return u;
    }

    public static String getObjectURI(ParaObject obj, boolean includeName, boolean includeId) {
        if (obj == null) {
            return "/";
        }
        if (includeId && obj.getId() != null) {
            return includeName && !StringUtils.isBlank((CharSequence)obj.getName()) ? obj.getObjectURI().concat("-").concat(Utils.urlEncode(Utils.noSpaces(obj.getName(), "-"))) : obj.getObjectURI();
        }
        return obj.getObjectURI();
    }

    public static void setStateParam(String name, String value, HttpServletRequest req, HttpServletResponse res) {
        Utils.setStateParam(name, value, req, res, false);
    }

    public static void setStateParam(String name, String value, HttpServletRequest req, HttpServletResponse res, boolean httpOnly) {
        Utils.setRawCookie(name, value, req, res, httpOnly, -1);
    }

    public static String getStateParam(String name, HttpServletRequest req) {
        return Utils.getCookieValue(req, name);
    }

    public static void removeStateParam(String name, HttpServletRequest req, HttpServletResponse res) {
        Utils.setRawCookie(name, "", req, res, false, 0);
    }

    public static void setRawCookie(String name, String value, HttpServletRequest req, HttpServletResponse res, boolean httpOnly, int maxAge) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)value) || req == null || res == null) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setHttpOnly(httpOnly);
        cookie.setMaxAge(maxAge < 0 ? Config.SESSION_TIMEOUT_SEC.intValue() : maxAge);
        cookie.setPath("/");
        cookie.setSecure(req.isSecure());
        res.addCookie(cookie);
    }

    public static String getCookieValue(HttpServletRequest req, String name) {
        if (StringUtils.isBlank((CharSequence)name) || req == null) {
            return null;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies == null || name == null || name.length() == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getSystemProperty(String name) {
        return StringUtils.isBlank((CharSequence)name) ? "" : System.getProperty(name);
    }

    public static int[] getMaxImgSize(int h, int w) {
        int[] size = new int[]{h, w};
        int max = Config.MAX_IMG_SIZE_PX;
        if (w == h) {
            size[0] = Math.min(h, max);
            size[1] = Math.min(w, max);
        } else if (Math.max(h, w) > max) {
            int ratio = 100 * max / Math.max(h, w);
            if (h > w) {
                size[0] = max;
                size[1] = w * ratio / 100;
            } else {
                size[0] = h * ratio / 100;
                size[1] = max;
            }
        }
        return size;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With")) || "XMLHttpRequest".equalsIgnoreCase(request.getParameter("X-Requested-With"));
    }

    public static boolean isJsonType(String contentType) {
        return StringUtils.startsWith((CharSequence)contentType, (CharSequence)"application/json") || StringUtils.startsWith((CharSequence)contentType, (CharSequence)"application/javascript") || StringUtils.startsWith((CharSequence)contentType, (CharSequence)"text/javascript");
    }

    public static String singularToPlural(String singul) {
        return StringUtils.isBlank((CharSequence)singul) ? singul : (singul.endsWith("s") ? singul + "es" : (singul.endsWith("y") ? StringUtils.removeEndIgnoreCase((String)singul, (String)"y") + "ies" : singul + "s"));
    }

    public static boolean isBasicType(Class<?> clazz) {
        return clazz == null ? false : clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Long.class) || clazz.equals(Integer.class) || clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Float.class) || clazz.equals(Double.class) || clazz.equals(Character.class);
    }

    public static String type(Class<? extends ParaObject> clazz) {
        return clazz == null ? "" : clazz.getSimpleName().toLowerCase();
    }

    public static List<Field> getAllDeclaredFields(Class<? extends ParaObject> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        if (clazz == null) {
            return fields;
        }
        Class<? extends ParaObject> parent = clazz;
        do {
            for (Field field : parent.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || field.getName().equals("serialVersionUID")) continue;
                fields.add(field);
            }
        } while (!(parent = parent.getSuperclass()).equals(Object.class));
        return fields;
    }

    public static String getNewId() {
        long timestamp = Utils.timestamp();
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = Utils.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        if (timestamp < lastTimestamp) {
            throw new IllegalStateException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        lastTimestamp = timestamp;
        return Long.toString(timestamp - 1310084584692L << 22 | dataCenterId << 17 | workerId << 12 | sequence);
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = Utils.timestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = Utils.timestamp();
        }
        return timestamp;
    }

    static {
        lastTimestamp = -1L;
        dataCenterId = 0L;
        sequence = 0L;
        Utils.initIdGenerator();
        mustache = new DefaultMustacheFactory();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
    }
}

