/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Votable;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import com.erudika.para.validation.Constraint;
import com.erudika.para.validation.ValidationUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
implements ParaObject {
    public static final String APP_ROLE = "ROLE_APP";
    public static final String ALLOW_ALL = "*";
    private static final long serialVersionUID = 1L;
    private static final String prefix = Utils.type(App.class).concat(Config.SEPARATOR);
    private static final Logger logger = LoggerFactory.getLogger(App.class);
    @Stored
    @Locked
    @NotBlank
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    private Boolean stored;
    @Stored
    private Boolean indexed;
    @Stored
    private Boolean cached;
    @Stored
    @Locked
    private boolean shared = true;
    @Stored
    @Locked
    private String secret;
    @Stored
    @Locked
    private Boolean readOnly = false;
    @Stored
    private Map<String, String> datatypes;
    @Stored
    private Map<String, Map<String, Map<String, Map<String, ?>>>> validationConstraints;
    @Stored
    private Map<String, Map<String, List<String>>> resourcePermissions;
    @Stored
    private Boolean active = true;
    @Stored
    private Long deleteOn;
    @Stored
    private Long tokenValiditySec;

    public App() {
        this(null);
    }

    public App(String id) {
        this.setId(id);
        this.setName(this.getName());
    }

    public static final String id(String id) {
        if (StringUtils.startsWith((CharSequence)id, (CharSequence)prefix)) {
            return prefix.concat(Utils.noSpaces(Utils.stripAndTrim(id.replaceAll(prefix, ""), " "), "-"));
        }
        if (id != null) {
            return prefix.concat(Utils.noSpaces(Utils.stripAndTrim(id, " "), "-"));
        }
        return null;
    }

    @Override
    public final void setId(String id) {
        this.id = App.id(id);
    }

    public Map<String, Map<String, Map<String, Map<String, ?>>>> getValidationConstraints() {
        if (this.validationConstraints == null) {
            this.validationConstraints = new HashMap();
        }
        return this.validationConstraints;
    }

    public void setValidationConstraints(Map<String, Map<String, Map<String, Map<String, ?>>>> validationConstraints) {
        this.validationConstraints = validationConstraints;
    }

    public Map<String, Map<String, List<String>>> getResourcePermissions() {
        if (this.resourcePermissions == null) {
            this.resourcePermissions = new HashMap<String, Map<String, List<String>>>();
        }
        return this.resourcePermissions;
    }

    public void setResourcePermissions(Map<String, Map<String, List<String>>> resourcePermissions) {
        this.resourcePermissions = resourcePermissions;
    }

    public String getAppIdentifier() {
        return this.getId() != null ? this.getId().replaceFirst(prefix, "") : "";
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Long getDeleteOn() {
        return this.deleteOn;
    }

    public void setDeleteOn(Long deleteOn) {
        this.deleteOn = deleteOn;
    }

    public Long getTokenValiditySec() {
        if (this.tokenValiditySec == null || this.tokenValiditySec <= 0L) {
            this.tokenValiditySec = Config.JWT_EXPIRES_AFTER_SEC;
        }
        return this.tokenValiditySec;
    }

    public void setTokenValiditySec(Long tokenValiditySec) {
        if (tokenValiditySec == null || tokenValiditySec <= 0L) {
            this.tokenValiditySec = 0L;
        }
        this.tokenValiditySec = tokenValiditySec;
    }

    @JsonIgnore
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Map<String, String> getDatatypes() {
        if (this.datatypes == null) {
            this.datatypes = new DualHashBidiMap();
        }
        return this.datatypes;
    }

    public void setDatatypes(Map<String, String> datatypes) {
        this.datatypes = datatypes;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public Map<String, Map<String, Map<String, Map<String, ?>>>> getAllValidationConstraints(String ... types) {
        HashMap allConstr = new HashMap();
        if (types == null || types.length == 0) {
            types = ParaObjectUtils.getAllTypes(this).values().toArray(new String[0]);
        }
        try {
            for (String aType : types) {
                Map<String, Map<String, Map<String, ?>>> appConstraints;
                HashMap vc = new HashMap();
                if (ValidationUtils.getCoreValidationConstraints().containsKey(aType)) {
                    vc.putAll(ValidationUtils.getCoreValidationConstraints().get(aType));
                }
                if ((appConstraints = this.getValidationConstraints().get(aType)) != null && !appConstraints.isEmpty()) {
                    vc.putAll(appConstraints);
                }
                if (vc.isEmpty()) continue;
                allConstr.put(aType, vc);
            }
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
        return allConstr;
    }

    public boolean addValidationConstraint(String type, String field, Constraint c) {
        if (!StringUtils.isBlank((CharSequence)type) && !StringUtils.isBlank((CharSequence)field) && c != null && !c.getPayload().isEmpty() && Constraint.isValidConstraintName(c.getName())) {
            Map<String, Map<String, ?>> consMap;
            Map<String, Map<String, Map<String, ?>>> fieldMap = this.getValidationConstraints().get(type);
            if (fieldMap != null) {
                consMap = fieldMap.get(field);
                if (consMap == null) {
                    consMap = new HashMap();
                }
            } else {
                fieldMap = new HashMap();
                consMap = new HashMap();
            }
            consMap.put(c.getName(), c.getPayload());
            fieldMap.put(field, consMap);
            this.getValidationConstraints().put(type, fieldMap);
            return true;
        }
        return false;
    }

    public boolean removeValidationConstraint(String type, String field, String constraintName) {
        Map<String, Map<String, Map<String, ?>>> fieldsMap;
        if (!StringUtils.isBlank((CharSequence)type) && !StringUtils.isBlank((CharSequence)field) && constraintName != null && (fieldsMap = this.getValidationConstraints().get(type)) != null && fieldsMap.containsKey(field)) {
            if (fieldsMap.get(field).containsKey(constraintName)) {
                fieldsMap.get(field).remove(constraintName);
            }
            if (fieldsMap.get(field).isEmpty()) {
                this.getValidationConstraints().get(type).remove(field);
            }
            if (this.getValidationConstraints().get(type).isEmpty()) {
                this.getValidationConstraints().remove(type);
            }
            return true;
        }
        return false;
    }

    public Map<String, Map<String, List<String>>> getAllResourcePermissions(String ... subjectids) {
        HashMap<String, Map<String, List<String>>> allPermits = new HashMap<String, Map<String, List<String>>>();
        if (subjectids == null || subjectids.length == 0) {
            return this.getResourcePermissions();
        }
        try {
            for (String subjectid : subjectids) {
                if (subjectid == null) continue;
                if (this.getResourcePermissions().containsKey(subjectid)) {
                    allPermits.put(subjectid, this.getResourcePermissions().get(subjectid));
                } else {
                    allPermits.put(subjectid, new HashMap(0));
                }
                if (!this.getResourcePermissions().containsKey(ALLOW_ALL)) continue;
                allPermits.put(ALLOW_ALL, this.getResourcePermissions().get(ALLOW_ALL));
            }
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
        return allPermits;
    }

    public boolean grantResourcePermission(String subjectid, String resourcePath, EnumSet<AllowedMethods> permission) {
        return this.grantResourcePermission(subjectid, resourcePath, permission, false);
    }

    public boolean grantResourcePermission(String subjectid, String resourcePath, EnumSet<AllowedMethods> permission, boolean allowGuestAccess) {
        resourcePath = Utils.urlDecode(resourcePath);
        if (!(StringUtils.isBlank((CharSequence)subjectid) || StringUtils.isBlank((CharSequence)resourcePath) || permission == null || permission.isEmpty())) {
            if (allowGuestAccess && ALLOW_ALL.equals(subjectid)) {
                permission.add(AllowedMethods.GUEST);
            }
            if (!this.getResourcePermissions().containsKey(subjectid)) {
                HashMap perm = new HashMap();
                perm.put(resourcePath, new ArrayList(permission.size()));
                for (AllowedMethods allowedMethod : permission) {
                    ((List)perm.get(resourcePath)).add(allowedMethod.toString());
                }
                this.getResourcePermissions().put(subjectid, perm);
            } else {
                if (permission.containsAll(AllowedMethods.ALL) || permission.contains((Object)AllowedMethods.READ_WRITE) || permission.contains((Object)AllowedMethods.READ_ONLY) && permission.contains((Object)AllowedMethods.WRITE_ONLY) || permission.contains((Object)AllowedMethods.GET) && permission.contains((Object)AllowedMethods.WRITE_ONLY)) {
                    permission = AllowedMethods.READ_AND_WRITE;
                } else if (permission.contains((Object)AllowedMethods.WRITE_ONLY)) {
                    permission = AllowedMethods.WRITE;
                } else if (permission.contains((Object)AllowedMethods.READ_ONLY)) {
                    permission = AllowedMethods.READ;
                }
                ArrayList<String> perm = new ArrayList<String>(permission.size());
                for (AllowedMethods allowedMethod : permission) {
                    perm.add(allowedMethod.toString());
                }
                this.getResourcePermissions().get(subjectid).put(resourcePath, perm);
            }
            return true;
        }
        return false;
    }

    public boolean revokeResourcePermission(String subjectid, String resourcePath) {
        if (!StringUtils.isBlank((CharSequence)subjectid) && this.getResourcePermissions().containsKey(subjectid) && !StringUtils.isBlank((CharSequence)resourcePath)) {
            resourcePath = Utils.urlDecode(resourcePath);
            this.getResourcePermissions().get(subjectid).remove(resourcePath);
            if (this.getResourcePermissions().get(subjectid).isEmpty()) {
                this.getResourcePermissions().remove(subjectid);
            }
            return true;
        }
        return false;
    }

    public boolean revokeAllResourcePermissions(String subjectid) {
        if (!StringUtils.isBlank((CharSequence)subjectid) && this.getResourcePermissions().containsKey(subjectid)) {
            this.getResourcePermissions().remove(subjectid);
            return true;
        }
        return false;
    }

    public boolean isAllowedTo(String subjectid, String resourcePath, String httpMethod) {
        boolean allow = false;
        if (subjectid != null && !StringUtils.isBlank((CharSequence)resourcePath) && !StringUtils.isBlank((CharSequence)httpMethod)) {
            resourcePath = Utils.urlDecode(resourcePath);
            if (this.getResourcePermissions().isEmpty()) {
                return false;
            }
            if (this.getResourcePermissions().containsKey(subjectid) && this.getResourcePermissions().get(subjectid).containsKey(resourcePath)) {
                allow = this.isAllowed(subjectid, resourcePath, httpMethod);
            } else {
                boolean bl = allow = this.isAllowed(subjectid, resourcePath, httpMethod) || this.isAllowed(subjectid, ALLOW_ALL, httpMethod) || this.isAllowed(ALLOW_ALL, resourcePath, httpMethod) || this.isAllowed(ALLOW_ALL, ALLOW_ALL, httpMethod);
            }
        }
        if (allow) {
            boolean isRootApp = StringUtils.equals((CharSequence)App.id(Config.APP_NAME_NS), (CharSequence)this.getId());
            if (isRootApp && !Config.getConfigBoolean("clients_can_access_root_app", false)) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)subjectid)) {
                return this.isAllowed(ALLOW_ALL, resourcePath, AllowedMethods.GUEST.toString());
            }
            return true;
        }
        return false;
    }

    protected final boolean isAllowed(String subjectid, String resourcePath, String httpMethod) {
        boolean allowed = false;
        if (subjectid != null && httpMethod != null && this.getResourcePermissions().containsKey(subjectid)) {
            httpMethod = httpMethod.toUpperCase();
            if (StringUtils.contains((CharSequence)resourcePath, (CharSequence)"/")) {
                String fragment = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
                for (String resource : this.getResourcePermissions().get(subjectid).keySet()) {
                    if (!StringUtils.startsWith((CharSequence)fragment, (CharSequence)resource) || !this.getResourcePermissions().get(subjectid).get(resource).contains(httpMethod) && !this.getResourcePermissions().get(subjectid).get(resource).contains(ALLOW_ALL)) continue;
                    allowed = true;
                    break;
                }
            }
            if (!allowed && this.getResourcePermissions().get(subjectid).containsKey(resourcePath)) {
                allowed = this.getResourcePermissions().get(subjectid).get(resourcePath).contains(httpMethod) || this.getResourcePermissions().get(subjectid).get(resourcePath).contains(ALLOW_ALL);
            }
        }
        return allowed;
    }

    public boolean isDeniedExplicitly(String subjectid, String resourcePath, String httpMethod) {
        String path;
        String sid;
        if (StringUtils.isBlank((CharSequence)subjectid) || StringUtils.isBlank((CharSequence)resourcePath) || StringUtils.isBlank((CharSequence)httpMethod) || this.getResourcePermissions().isEmpty()) {
            return false;
        }
        resourcePath = Utils.urlDecode(resourcePath);
        if (this.getResourcePermissions().containsKey(subjectid)) {
            sid = subjectid;
        } else if (this.getResourcePermissions().containsKey(ALLOW_ALL)) {
            sid = ALLOW_ALL;
        } else {
            return false;
        }
        if (this.getResourcePermissions().get(sid).containsKey(resourcePath)) {
            path = resourcePath;
        } else if (this.getResourcePermissions().get(sid).containsKey(ALLOW_ALL)) {
            path = ALLOW_ALL;
        } else {
            return false;
        }
        return !this.isAllowed(sid, path, httpMethod);
    }

    public void addDatatype(String pluralDatatype, String datatype) {
        pluralDatatype = Utils.noSpaces(Utils.stripAndTrim(pluralDatatype, " "), "-");
        datatype = Utils.noSpaces(Utils.stripAndTrim(datatype, " "), "-");
        if (this.getDatatypes().size() < Config.MAX_DATATYPES_PER_APP) {
            if (!(StringUtils.isBlank((CharSequence)pluralDatatype) || StringUtils.isBlank((CharSequence)datatype) || this.getDatatypes().containsValue(datatype) || ParaObjectUtils.getCoreTypes().containsKey(pluralDatatype))) {
                this.getDatatypes().putIfAbsent(pluralDatatype, datatype);
            }
        } else {
            LoggerFactory.getLogger(App.class).warn("Maximum number of types per app reached - {}.", (Object)Config.MAX_DATATYPES_PER_APP);
        }
    }

    public void addDatatypes(ParaObject ... objects) {
        if (objects != null && objects.length > 0) {
            for (ParaObject obj : objects) {
                if (obj == null || obj.getType() == null) continue;
                this.addDatatype(obj.getPlural(), obj.getType());
            }
        }
    }

    public void removeDatatype(String pluralDatatype) {
        if (!StringUtils.isBlank((CharSequence)pluralDatatype)) {
            this.getDatatypes().remove(pluralDatatype);
        }
    }

    public void resetSecret() {
        this.secret = Utils.generateSecurityToken(40);
    }

    @JsonIgnore
    public Map<String, String> getCredentials() {
        if (this.getId() == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("accessKey", App.this.getId());
                this.put("secretKey", App.this.getSecret());
            }
        };
    }

    @Override
    public String create() {
        if (this.getId() != null && this.exists()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.secret)) {
            this.resetSecret();
        }
        return CoreUtils.getInstance().getDao().create(this);
    }

    @Override
    public void delete() {
        if (!StringUtils.equals((CharSequence)this.getId(), (CharSequence)prefix.concat(Config.APP_NAME_NS))) {
            CoreUtils.getInstance().getDao().delete(this);
        }
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Config.APP_NAME_NS : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getInstance().getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Boolean getStored() {
        if (this.stored == null) {
            this.stored = true;
        }
        return this.stored;
    }

    @Override
    public void setStored(Boolean stored) {
        this.stored = stored;
    }

    @Override
    public Boolean getIndexed() {
        if (this.indexed == null) {
            this.indexed = true;
        }
        return this.indexed;
    }

    @Override
    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public Boolean getCached() {
        if (this.cached == null) {
            this.cached = true;
        }
        return this.cached;
    }

    @Override
    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getInstance().getName(this.name, this.id);
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public void update() {
        CoreUtils.getInstance().getDao().update(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return CoreUtils.getInstance().getDao().read(this.getAppid(), this.getId()) != null;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.getInstance().countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getInstance().getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getInstance().getLinkedObjects(this, type, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.getInstance().isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.getInstance().isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.getInstance().link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.getInstance().unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.getInstance().unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.getInstance().countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.getInstance().deleteChildren(this, type);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id) + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParaObject other = (ParaObject)obj;
        return Objects.equals(this.id, other.getId());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }

    public static enum AllowedMethods {
        GUEST,
        EMPTY,
        READ_WRITE,
        GET,
        POST,
        PUT,
        PATCH,
        DELETE,
        READ_ONLY,
        WRITE_ONLY;

        public static final EnumSet<AllowedMethods> ALL;
        public static final EnumSet<AllowedMethods> READ_AND_WRITE;
        public static final EnumSet<AllowedMethods> READ;
        public static final EnumSet<AllowedMethods> WRITE;
        public static final EnumSet<AllowedMethods> ALL_EXCEPT_DELETE;
        public static final EnumSet<AllowedMethods> NONE;

        @JsonCreator
        public static AllowedMethods fromString(String value) {
            if (App.ALLOW_ALL.equals(value)) {
                return READ_WRITE;
            }
            if ("w".equals(value)) {
                return WRITE_ONLY;
            }
            if ("?".equals(value)) {
                return GUEST;
            }
            try {
                return AllowedMethods.valueOf(value.toUpperCase());
            }
            catch (Exception e) {
                return EMPTY;
            }
        }

        @JsonValue
        public String toString() {
            switch (this) {
                case READ_WRITE: {
                    return App.ALLOW_ALL;
                }
                case READ_ONLY: {
                    return GET.name();
                }
                case GUEST: {
                    return "?";
                }
                case EMPTY: {
                    return "-";
                }
                case WRITE_ONLY: {
                    return "w";
                }
            }
            return this.name();
        }

        static {
            ALL = EnumSet.of(GET, POST, PUT, PATCH, DELETE);
            READ_AND_WRITE = EnumSet.of(READ_WRITE);
            READ = EnumSet.of(GET);
            WRITE = EnumSet.of(POST, PUT, PATCH, DELETE);
            ALL_EXCEPT_DELETE = EnumSet.of(GET, POST, PUT, PATCH);
            NONE = EnumSet.of(EMPTY);
        }
    }
}

