/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.utils;

import com.erudika.para.utils.Utils;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static com.typesafe.config.Config config;
    private static Map<String, String> configMap;
    public static final String PARA = "para";
    public static final String _TYPE = "type";
    public static final String _APPID = "appid";
    public static final String _CREATORID = "creatorid";
    public static final String _ID = "id";
    public static final String _IDENTIFIER = "identifier";
    public static final String _KEY = "key";
    public static final String _NAME = "name";
    public static final String _PARENTID = "parentid";
    public static final String _PASSWORD = "password";
    public static final String _RESET_TOKEN = "token";
    public static final String _EMAIL_TOKEN = "etoken";
    public static final String _TIMESTAMP = "timestamp";
    public static final String _UPDATED = "updated";
    public static final String _TAGS = "tags";
    public static final String _EMAIL = "email";
    public static final String _GROUPS = "groups";
    public static final int DEFAULT_LIMIT = 10000;
    public static final String SEPARATOR;
    public static final String FB_PREFIX;
    public static final String GPLUS_PREFIX;
    public static final String LINKEDIN_PREFIX;
    public static final String TWITTER_PREFIX;
    public static final String GITHUB_PREFIX;
    public static final int MAX_ITEMS_PER_PAGE;
    public static final int MAX_PAGES;
    public static final int MAX_IMG_SIZE_PX;
    public static final int MIN_PASS_LENGTH;
    public static final int MAX_DATATYPES_PER_APP;
    public static final int MAX_ENTITY_SIZE_BYTES;
    public static final String DEFAULT_ENCODING;
    public static final String ENVIRONMENT;
    public static final String AWS_ACCESSKEY;
    public static final String AWS_SECRETKEY;
    public static final String AWS_REGION;
    public static final String FB_APP_ID;
    public static final String FB_SECRET;
    public static final String GPLUS_APP_ID;
    public static final String GPLUS_SECRET;
    public static final String LINKEDIN_APP_ID;
    public static final String LINKEDIN_SECRET;
    public static final String TWITTER_APP_ID;
    public static final String TWITTER_SECRET;
    public static final String GITHUB_APP_ID;
    public static final String GITHUB_SECRET;
    public static final String OPENX_API_KEY;
    public static final String GMAPS_API_KEY;
    public static final String ADMIN_IDENT;
    public static final String WORKER_ID;
    public static final int EXECUTOR_THREADS;
    public static final String APP_NAME;
    public static final String APP_NAME_NS;
    public static final String AUTH_COOKIE;
    public static final String RETURNTO_COOKIE;
    public static final String SUPPORT_EMAIL;
    public static final String APP_SECRET_KEY;
    public static final String CORE_PACKAGE_NAME;
    public static final Long REQUEST_EXPIRES_AFTER_SEC;
    public static final Long JWT_EXPIRES_AFTER_SEC;
    public static final Long JWT_REFRESH_INTERVAL_SEC;
    public static final Long SESSION_TIMEOUT_SEC;
    public static final Long VOTE_EXPIRES_AFTER_SEC;
    public static final Long VOTE_LOCKED_AFTER_SEC;
    public static final Long PASSRESET_TIMEOUT_SEC;
    public static final boolean API_ENABLED;
    public static final boolean CORS_ENABLED;
    public static final boolean GZIP_ENABLED;
    public static final boolean IN_PRODUCTION;
    public static final boolean IN_DEVELOPMENT;
    public static final String CLUSTER_NAME;

    public static void init(com.typesafe.config.Config conf) {
        try {
            config = ConfigFactory.load().getConfig(PARA);
            if (conf != null) {
                config = conf.withFallback((ConfigMergeable)config);
            }
            configMap = new HashMap<String, String>();
            for (Map.Entry con : config.entrySet()) {
                if (((ConfigValue)con.getValue()).valueType() == ConfigValueType.LIST) continue;
                configMap.put((String)con.getKey(), config.getString((String)con.getKey()));
            }
        }
        catch (Exception ex) {
            logger.warn("Para configuration file 'application.(conf|json|properties)' is missing from classpath.");
            config = ConfigFactory.empty();
        }
    }

    public static boolean getConfigBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(Config.getConfigParam(key, Boolean.toString(defaultValue)));
    }

    public static int getConfigInt(String key, int defaultValue) {
        return NumberUtils.toInt((String)Config.getConfigParam(key, Integer.toString(defaultValue)));
    }

    public static double getConfigDouble(String key, double defaultValue) {
        return NumberUtils.toDouble((String)Config.getConfigParam(key, Double.toString(defaultValue)));
    }

    public static String getConfigParam(String key, String defaultValue) {
        if (config == null) {
            Config.init(null);
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return defaultValue;
        }
        String sys = System.getProperty(key, System.getProperty("para." + key));
        if (!StringUtils.isBlank((CharSequence)sys)) {
            return sys;
        }
        return !StringUtils.isBlank((CharSequence)key) && config.hasPath(key) ? config.getString(key) : defaultValue;
    }

    public static Map<String, String> getConfigMap() {
        if (configMap == null) {
            Config.init(null);
        }
        return configMap;
    }

    public static com.typesafe.config.Config getConfig() {
        if (config == null) {
            Config.init(null);
        }
        return config;
    }

    public static boolean isCacheEnabled() {
        return Config.getConfigBoolean("cache_enabled", ENVIRONMENT.equals("production"));
    }

    public static boolean isSearchEnabled() {
        return Config.getConfigBoolean("search_enabled", true);
    }

    private static String[] getAwsCredentials() {
        String accessK = Config.getConfigParam("aws_access_key", "");
        String secretK = Config.getConfigParam("aws_secret_key", "");
        return new String[]{accessK, secretK};
    }

    static {
        Config.init(null);
        SEPARATOR = Config.getConfigParam("default_separator", ":");
        FB_PREFIX = "fb" + SEPARATOR;
        GPLUS_PREFIX = "gp" + SEPARATOR;
        LINKEDIN_PREFIX = "in" + SEPARATOR;
        TWITTER_PREFIX = "tw" + SEPARATOR;
        GITHUB_PREFIX = "gh" + SEPARATOR;
        MAX_ITEMS_PER_PAGE = Config.getConfigInt("max_items_per_page", 30);
        MAX_PAGES = Config.getConfigInt("max_pages", 10000);
        MAX_IMG_SIZE_PX = Config.getConfigInt("max_img_px", 1024);
        MIN_PASS_LENGTH = Config.getConfigInt("min_password_length", 6);
        MAX_DATATYPES_PER_APP = Config.getConfigInt("max_datatypes_per_app", 256);
        MAX_ENTITY_SIZE_BYTES = Config.getConfigInt("max_entity_size_bytes", 0x100000);
        DEFAULT_ENCODING = Config.getConfigParam("default_encoding", "UTF-8");
        ENVIRONMENT = Config.getConfigParam("env", "embedded");
        AWS_ACCESSKEY = Config.getAwsCredentials()[0];
        AWS_SECRETKEY = Config.getAwsCredentials()[1];
        AWS_REGION = Config.getConfigParam("aws_region", "eu-west-1");
        FB_APP_ID = Config.getConfigParam("fb_app_id", "");
        FB_SECRET = Config.getConfigParam("fb_secret", "");
        GPLUS_APP_ID = Config.getConfigParam("gp_app_id", "");
        GPLUS_SECRET = Config.getConfigParam("gp_secret", "");
        LINKEDIN_APP_ID = Config.getConfigParam("in_app_id", "");
        LINKEDIN_SECRET = Config.getConfigParam("in_secret", "");
        TWITTER_APP_ID = Config.getConfigParam("tw_app_id", "");
        TWITTER_SECRET = Config.getConfigParam("tw_secret", "");
        GITHUB_APP_ID = Config.getConfigParam("gh_app_id", "");
        GITHUB_SECRET = Config.getConfigParam("gh_secret", "");
        OPENX_API_KEY = Config.getConfigParam("openx_api_key", "");
        GMAPS_API_KEY = Config.getConfigParam("gmaps_api_key", "");
        ADMIN_IDENT = Config.getConfigParam("admin_ident", "");
        WORKER_ID = Config.getConfigParam("worker_id", "1");
        EXECUTOR_THREADS = Config.getConfigInt("executor_threads", 2);
        APP_NAME = Config.getConfigParam("app_name", PARA);
        APP_NAME_NS = Utils.noSpaces(APP_NAME, "-");
        AUTH_COOKIE = Config.getConfigParam("auth_cookie", APP_NAME_NS.concat("-auth"));
        RETURNTO_COOKIE = Config.getConfigParam("returnto_cookie", APP_NAME_NS.concat("-returnto"));
        SUPPORT_EMAIL = Config.getConfigParam("support_email", "support@myapp.co");
        APP_SECRET_KEY = Config.getConfigParam("app_secret_key", Utils.MD5("paraseckey"));
        CORE_PACKAGE_NAME = Config.getConfigParam("core_package_name", "");
        REQUEST_EXPIRES_AFTER_SEC = NumberUtils.toLong((String)Config.getConfigParam("request_expires_after", ""), (long)900L);
        JWT_EXPIRES_AFTER_SEC = NumberUtils.toLong((String)Config.getConfigParam("jwt_expires_after", ""), (long)604800L);
        JWT_REFRESH_INTERVAL_SEC = NumberUtils.toLong((String)Config.getConfigParam("jwt_refresh_interval", ""), (long)3600L);
        SESSION_TIMEOUT_SEC = NumberUtils.toLong((String)Config.getConfigParam("session_timeout", ""), (long)86400L);
        VOTE_EXPIRES_AFTER_SEC = NumberUtils.toLong((String)Config.getConfigParam("vote_expires_after", ""), (long)2592000L);
        VOTE_LOCKED_AFTER_SEC = NumberUtils.toLong((String)Config.getConfigParam("vote_locked_after", ""), (long)30L);
        PASSRESET_TIMEOUT_SEC = NumberUtils.toLong((String)Config.getConfigParam("pass_reset_timeout", ""), (long)1800L);
        API_ENABLED = Boolean.parseBoolean(Config.getConfigParam("api_enabled", "true"));
        CORS_ENABLED = Boolean.parseBoolean(Config.getConfigParam("cors_enabled", "true"));
        GZIP_ENABLED = Boolean.parseBoolean(Config.getConfigParam("gzip_enabled", "false"));
        IN_PRODUCTION = ENVIRONMENT.equals("production");
        IN_DEVELOPMENT = ENVIRONMENT.equals("development");
        CLUSTER_NAME = Config.getConfigParam("cluster_name", IN_PRODUCTION ? "para-prod" : "para-dev");
    }
}

