/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Votable;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;

public class Vote
implements ParaObject {
    private static final long serialVersionUID = 1L;
    @Stored
    @Locked
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    private Boolean stored;
    @Stored
    private Boolean indexed;
    @Stored
    private Boolean cached;
    @Stored
    @NotBlank
    private String value;
    @Stored
    @NotNull
    private Long expiresAfter;

    public Vote() {
        this(null, null, null);
    }

    public Vote(String voterid, String voteeid, String value) {
        this.creatorid = voterid;
        this.parentid = voteeid;
        this.timestamp = Utils.timestamp();
        this.setName(this.getType());
        this.value = value;
        this.expiresAfter = Config.VOTE_EXPIRES_AFTER_SEC;
    }

    @Override
    public final String getId() {
        if (this.getCreatorid() != null && this.getParentid() != null && this.id == null) {
            this.id = this.getType().concat(Config.SEPARATOR).concat(this.getCreatorid()).concat(Config.SEPARATOR).concat(this.getParentid());
        }
        return this.id;
    }

    public Vote up() {
        this.value = Votable.VoteValue.UP.toString();
        return this;
    }

    public Vote down() {
        this.value = Votable.VoteValue.DOWN.toString();
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Long getExpiresAfter() {
        if (this.expiresAfter == null) {
            this.expiresAfter = Config.VOTE_EXPIRES_AFTER_SEC;
        }
        return this.expiresAfter;
    }

    public void setExpiresAfter(Long expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public boolean isExpired() {
        long now;
        long expires;
        if (this.getTimestamp() == null || this.getExpiresAfter() == 0L) {
            return false;
        }
        long timestamp = this.getTimestamp();
        return timestamp + (expires = this.getExpiresAfter() * 1000L) <= (now = Utils.timestamp());
    }

    public boolean isAmendable() {
        if (this.getTimestamp() == null) {
            return false;
        }
        long timestamp = this.getTimestamp();
        long now = Utils.timestamp();
        return timestamp + Config.VOTE_LOCKED_AFTER_SEC * 1000L > now;
    }

    @Override
    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public final String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Config.APP_NAME_NS : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getInstance().getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Boolean getStored() {
        if (this.stored == null) {
            this.stored = true;
        }
        return this.stored;
    }

    @Override
    public void setStored(Boolean stored) {
        this.stored = stored;
    }

    @Override
    public Boolean getIndexed() {
        if (this.indexed == null) {
            this.indexed = true;
        }
        return this.indexed;
    }

    @Override
    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public Boolean getCached() {
        if (this.cached == null) {
            this.cached = true;
        }
        return this.cached;
    }

    @Override
    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getInstance().getName(this.name, this.id);
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public String create() {
        return CoreUtils.getInstance().getDao().create(this.getAppid(), this);
    }

    @Override
    public void update() {
        CoreUtils.getInstance().getDao().update(this.getAppid(), this);
    }

    @Override
    public void delete() {
        CoreUtils.getInstance().getDao().delete(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return CoreUtils.getInstance().getDao().read(this.getAppid(), this.getId()) != null;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.getInstance().countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getInstance().getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getInstance().getLinkedObjects(this, type, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.getInstance().isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.getInstance().isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.getInstance().link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.getInstance().unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.getInstance().unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.getInstance().countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.getInstance().deleteChildren(this, type);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id) + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParaObject other = (ParaObject)obj;
        return Objects.equals(this.id, other.getId());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }
}

