/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Votable;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.validator.constraints.NotBlank;

public final class Linker
implements ParaObject,
Serializable {
    private static final long serialVersionUID = 1L;
    @Stored
    @Locked
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    private Boolean stored;
    @Stored
    private Boolean indexed;
    @Stored
    private Boolean cached;
    @Stored
    @Locked
    @NotBlank
    private String id1;
    @Stored
    @Locked
    @NotBlank
    private String id2;
    @Stored
    @Locked
    @NotBlank
    private String type1;
    @Stored
    @Locked
    @NotBlank
    private String type2;
    @Stored
    private String metadata;
    @Stored
    private List<Map<String, Object>> nstd;

    public Linker() {
    }

    public Linker(String type1, String type2, String id1, String id2) {
        if (this.isReversed(type1, type2)) {
            this.type1 = type2;
            this.type2 = type1;
            this.id1 = id2;
            this.id2 = id1;
        } else {
            this.type1 = type1;
            this.type2 = type2;
            this.id1 = id1;
            this.id2 = id2;
        }
        this.setName(this.type1 + Config.SEPARATOR + this.type2);
        this.setId(this.type1 + Config.SEPARATOR + this.id1 + Config.SEPARATOR + this.type2 + Config.SEPARATOR + this.id2);
    }

    public String getId2() {
        return this.id2;
    }

    public void setId2(String id2) {
        this.id2 = id2;
    }

    public String getId1() {
        return this.id1;
    }

    public void setId1(String id1) {
        this.id1 = id1;
    }

    public String getType1() {
        return this.type1;
    }

    public void setType1(String type1) {
        this.type1 = type1;
    }

    public String getType2() {
        return this.type2;
    }

    public void setType2(String type2) {
        this.type2 = type2;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    private boolean isReversed(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.compareToIgnoreCase(s2) > 0;
    }

    public boolean isFirst(String type2) {
        if (type2 == null) {
            return false;
        }
        return type2.equals(this.type1);
    }

    public String getIdFieldNameFor(String type) {
        return this.isFirst(type) ? "id1" : "id2";
    }

    public List<Map<String, Object>> getNstd() {
        if (this.nstd == null) {
            this.nstd = new ArrayList<Map<String, Object>>();
        }
        return this.nstd;
    }

    public void setNstd(List<Map<String, Object>> nstd) {
        this.nstd = nstd;
    }

    public void addNestedObject(ParaObject obj) {
        if (obj != null) {
            this.getNstd().add(ParaObjectUtils.getAnnotatedFields(obj, false));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Config.APP_NAME_NS : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getInstance().getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Boolean getStored() {
        if (this.stored == null) {
            this.stored = true;
        }
        return this.stored;
    }

    @Override
    public void setStored(Boolean stored) {
        this.stored = stored;
    }

    @Override
    public Boolean getIndexed() {
        if (this.indexed == null) {
            this.indexed = true;
        }
        return this.indexed;
    }

    @Override
    public void setIndexed(Boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public Boolean getCached() {
        if (this.cached == null) {
            this.cached = true;
        }
        return this.cached;
    }

    @Override
    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public String getName() {
        return CoreUtils.getInstance().getName(this.name, this.id);
    }

    @Override
    public void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public String create() {
        return CoreUtils.getInstance().getDao().create(this.getAppid(), this);
    }

    @Override
    public void update() {
        CoreUtils.getInstance().getDao().update(this.getAppid(), this);
    }

    @Override
    public void delete() {
        CoreUtils.getInstance().getDao().delete(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return CoreUtils.getInstance().getDao().read(this.getAppid(), this.getId()) != null;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.getInstance().vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.getInstance().countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getInstance().getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getInstance().getLinkedObjects(this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> findLinkedObjects(String type, String field, String query, Pager ... pager) {
        return CoreUtils.getInstance().findLinkedObjects(this, type, field, query, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.getInstance().isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.getInstance().isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.getInstance().link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.getInstance().unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.getInstance().unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.getInstance().countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getInstance().getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public <P extends ParaObject> List<P> findChildren(String type, String query, Pager ... pager) {
        return CoreUtils.getInstance().findChildren(this, type, query, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.getInstance().deleteChildren(this, type);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id) + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParaObject other = (ParaObject)obj;
        return Objects.equals(this.id, other.getId());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }
}

