/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.Sysprop;
import com.erudika.para.core.utils.CoreUtils;
import com.erudika.para.iot.IoTService;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotBlank;

public class Thing
extends Sysprop {
    private static final long serialVersionUID = 1L;
    @Stored
    @Locked
    @NotBlank
    private String serviceBroker;
    @Stored
    private Map<String, Object> deviceState;
    @Stored
    @Locked
    private Map<String, Object> deviceMetadata;
    private transient Map<String, Object> deviceDetails;

    public Thing() {
        this(null);
    }

    public Thing(String id) {
        super(id);
    }

    public String getServiceBroker() {
        return this.serviceBroker;
    }

    public void setServiceBroker(String serviceBroker) {
        this.serviceBroker = serviceBroker;
    }

    @JsonIgnore
    public Map<String, Object> getDeviceMetadata() {
        if (this.deviceMetadata == null) {
            this.deviceMetadata = new LinkedHashMap<String, Object>(20);
        }
        return this.deviceMetadata;
    }

    public void setDeviceMetadata(Map<String, Object> deviceMetadata) {
        this.deviceMetadata = deviceMetadata;
    }

    public Map<String, Object> getDeviceState() {
        if (this.deviceState == null) {
            this.deviceState = new HashMap<String, Object>();
        }
        return this.deviceState;
    }

    public void setDeviceState(Map<String, Object> state) {
        this.deviceState = state;
    }

    public Thing addStateProperty(String key, Object value) {
        if (!StringUtils.isBlank((CharSequence)key) && value != null) {
            this.getDeviceState().put(key, value);
        }
        return this;
    }

    public Object getStateProperty(String key) {
        if (!StringUtils.isBlank((CharSequence)key)) {
            return this.getDeviceState().get(key);
        }
        return null;
    }

    public Thing removeStateProperty(String key) {
        if (!StringUtils.isBlank((CharSequence)key)) {
            this.getDeviceState().remove(key);
        }
        return this;
    }

    public boolean hasStateProperty(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return this.getDeviceState().containsKey(key);
    }

    public Map<String, Object> getDeviceDetails() {
        return this.deviceDetails;
    }

    @Override
    public void delete() {
        IoTService iot;
        Thing t = this;
        if (StringUtils.isBlank((CharSequence)this.serviceBroker)) {
            t = (Thing)CoreUtils.getInstance().getDao().read(this.getAppid(), this.getId());
        }
        if (t != null && (iot = CoreUtils.getInstance().getIotFactory().getIoTService(t.getServiceBroker())) != null && !StringUtils.isBlank((CharSequence)t.getName())) {
            iot.deleteThing(t);
        }
        super.delete();
    }

    @Override
    public void update() {
        IoTService iot = CoreUtils.getInstance().getIotFactory().getIoTService(this.serviceBroker);
        if (iot != null && !StringUtils.isBlank((CharSequence)this.getName())) {
            iot.updateThing(this);
        }
        super.update();
    }

    @Override
    public String create() {
        IoTService iot = CoreUtils.getInstance().getIotFactory().getIoTService(this.serviceBroker);
        if (iot != null && !StringUtils.isBlank((CharSequence)this.getName())) {
            iot.createThing(this);
            if (!this.getDeviceMetadata().isEmpty()) {
                this.deviceDetails = this.getDeviceMetadata();
                return super.create();
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.serviceBroker, ((Thing)obj).getServiceBroker());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 89 * hash + Objects.hashCode(this.serviceBroker);
        return hash;
    }
}

