/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.InitializeListener;
import com.erudika.para.cache.Cache;
import com.erudika.para.cache.MockCache;
import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Votable;
import com.erudika.para.core.Vote;
import com.erudika.para.iot.IoTServiceFactory;
import com.erudika.para.persistence.DAO;
import com.erudika.para.persistence.MockDAO;
import com.erudika.para.search.MockSearch;
import com.erudika.para.search.Search;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CoreUtils implements InitializeListener
{
    INSTANCE{
        private final transient Logger logger = LoggerFactory.getLogger(CoreUtils.class);
        private transient DAO dao = new MockDAO();
        private transient Search search = new MockSearch();
        private transient Cache cache = new MockCache();
        private transient IoTServiceFactory iotFactory;
        {
            this.logger.debug("Using default impementations - {}, {} and {}.", new Object[]{this.dao.getClass().getSimpleName(), this.search.getClass().getSimpleName(), this.cache.getClass().getSimpleName()});
        }

        @Override
        public void onInitialize() {
            if (this.dao != null && this.search != null && this.cache != null) {
                this.logger.info("Loaded new DAO, Search and Cache implementations - {}, {} and {}.", new Object[]{this.dao.getClass().getSimpleName(), this.search.getClass().getSimpleName(), this.cache.getClass().getSimpleName()});
                this.setIotFactory(this.iotFactory);
            }
        }

        @Override
        public DAO getDao() {
            return this.dao;
        }

        @Override
        @Inject
        public void setDao(DAO dao) {
            this.dao = dao;
        }

        @Override
        public Search getSearch() {
            return this.search;
        }

        @Override
        @Inject
        public void setSearch(Search search) {
            this.search = search;
        }

        @Override
        public Cache getCache() {
            return this.cache;
        }

        @Override
        @Inject
        public void setCache(Cache cache) {
            this.cache = cache;
        }

        @Override
        public IoTServiceFactory getIotFactory() {
            return this.iotFactory;
        }

        @Override
        @Inject
        public void setIotFactory(IoTServiceFactory iotFactory) {
            this.iotFactory = iotFactory;
        }

        @Override
        public String getObjectURI(ParaObject obj) {
            String defurl = "/".concat(obj.getPlural());
            return obj.getId() != null ? defurl.concat("/").concat(obj.getId()) : defurl;
        }

        @Override
        public String getName(String name, String id) {
            return name == null ? "ParaObject ".concat(id == null ? Long.toString(System.currentTimeMillis()) : id) : name;
        }

        @Override
        public String overwrite(ParaObject obj) {
            return this.overwrite(Config.getRootAppIdentifier(), obj);
        }

        @Override
        public String overwrite(String appid, ParaObject obj) {
            if (obj != null && obj.getId() != null) {
                if (obj.getUpdated() == null) {
                    obj.setUpdated(System.currentTimeMillis());
                }
                return this.getDao().create(appid, obj);
            }
            return null;
        }

        @Override
        public List<String> addTags(List<String> objectTags, String ... tag) {
            if (tag != null && tag.length > 0) {
                HashSet<Object> tagz = objectTags == null || objectTags.isEmpty() ? new HashSet() : new HashSet<String>(objectTags);
                for (String t : tag) {
                    if (StringUtils.isBlank((CharSequence)t)) continue;
                    tagz.add(Utils.noSpaces(Utils.stripAndTrim(t), "-"));
                }
                tagz.remove(null);
                tagz.remove("");
                return new ArrayList<Object>(tagz);
            }
            return objectTags;
        }

        @Override
        public List<String> removeTags(List<String> objectTags, String ... tag) {
            if (objectTags != null && tag != null && tag.length > 0) {
                HashSet<String> tagz = new HashSet<String>(objectTags);
                tagz.removeAll(Arrays.asList(tag));
                return new ArrayList<String>(tagz);
            }
            return objectTags;
        }

        @Override
        public String link(ParaObject obj, String id2) {
            Object second = this.getDao().read(obj.getAppid(), id2);
            if (second == null || obj.getId() == null) {
                return null;
            }
            Linker link = new Linker(obj.getType(), second.getType(), obj.getId(), id2);
            link.addNestedObject(obj);
            link.addNestedObject((ParaObject)second);
            return this.getDao().create(obj.getAppid(), link);
        }

        @Override
        public void unlink(ParaObject obj, String type2, String id2) {
            this.getDao().delete(obj.getAppid(), new Linker(obj.getType(), type2, obj.getId(), id2));
        }

        @Override
        public void unlinkAll(ParaObject obj) {
            HashMap<String, String> terms = new HashMap<String, String>();
            terms.put("id1", obj.getId());
            terms.put("id2", obj.getId());
            this.getDao().deleteAll(obj.getAppid(), this.getSearch().findTerms(obj.getAppid(), Utils.type(Linker.class), terms, false, new Pager[0]));
        }

        @Override
        public List<Linker> getLinks(ParaObject obj, String type2, Pager ... pager) {
            if (type2 == null) {
                return Collections.emptyList();
            }
            Linker link = new Linker(obj.getType(), type2, null, null);
            String idField = link.getIdFieldNameFor(obj.getType());
            HashMap<String, String> terms = new HashMap<String, String>();
            terms.put("name", link.getName());
            terms.put(idField, obj.getId());
            return this.getSearch().findTerms(obj.getAppid(), link.getType(), terms, true, pager);
        }

        @Override
        public boolean isLinked(ParaObject obj, String type2, String id2) {
            if (type2 == null) {
                return false;
            }
            return this.getDao().read(obj.getAppid(), new Linker(obj.getType(), type2, obj.getId(), id2).getId()) != null;
        }

        @Override
        public boolean isLinked(ParaObject obj, ParaObject toObj) {
            if (toObj == null) {
                return false;
            }
            return this.isLinked(obj, toObj.getType(), toObj.getId());
        }

        @Override
        public Long countLinks(ParaObject obj, String type2) {
            if (obj.getId() == null) {
                return 0L;
            }
            Linker link = new Linker(obj.getType(), type2, null, null);
            String idField = link.getIdFieldNameFor(obj.getType());
            HashMap<String, String> terms = new HashMap<String, String>();
            terms.put("name", link.getName());
            terms.put(idField, obj.getId());
            return this.getSearch().getCount(obj.getAppid(), link.getType(), terms);
        }

        @Override
        public Long countChildren(ParaObject obj, String type2) {
            return this.getSearch().getCount(obj.getAppid(), type2);
        }

        @Override
        public <P extends ParaObject> List<P> getChildren(ParaObject obj, String type2, Pager ... pager) {
            return this.getChildren(obj, type2, (String)null, (String)null, pager);
        }

        @Override
        public <P extends ParaObject> List<P> getChildren(ParaObject obj, String type2, String field, String term, Pager ... pager) {
            HashMap<String, String> terms = new HashMap<String, String>();
            if (!StringUtils.isBlank((CharSequence)field) && !StringUtils.isBlank((CharSequence)term)) {
                terms.put(field, term);
            }
            terms.put("parentid", obj.getId());
            return this.getSearch().findTerms(obj.getAppid(), type2, terms, true, pager);
        }

        @Override
        public <P extends ParaObject> List<P> findChildren(ParaObject obj, String type2, String query, Pager ... pager) {
            if (StringUtils.isBlank((CharSequence)query)) {
                query = "*";
            }
            String suffix = "*".equals(query.trim()) ? "" : " AND " + query;
            query = "parentid:" + obj.getId() + suffix;
            return this.getSearch().findQuery(obj.getAppid(), type2, query, pager);
        }

        @Override
        public void deleteChildren(ParaObject obj, String type2) {
            if (!StringUtils.isBlank((CharSequence)obj.getId())) {
                this.getDao().deleteAll(obj.getAppid(), this.getSearch().findTerms(obj.getAppid(), type2, Collections.singletonMap("parentid", obj.getId()), true, new Pager[0]));
            }
        }

        @Override
        public <P extends ParaObject> List<P> getLinkedObjects(ParaObject obj, String type2, Pager ... pager) {
            List<Linker> links = this.getLinks(obj, type2, pager);
            LinkedList<String> keys = new LinkedList<String>();
            for (Linker link : links) {
                keys.add(link.isFirst(type2) ? link.getId1() : link.getId2());
            }
            return new ArrayList(this.getDao().readAll(obj.getAppid(), keys, true).values());
        }

        @Override
        public <P extends ParaObject> List<P> findLinkedObjects(ParaObject obj, String type2, String field, String query, Pager ... pager) {
            if (StringUtils.isBlank((CharSequence)query)) {
                query = "*";
            }
            List links = this.getSearch().findNestedQuery(obj.getAppid(), Utils.type(Linker.class), field, query, pager);
            LinkedList<String> keys = new LinkedList<String>();
            for (Linker link : links) {
                if (link.getId1().equals(obj.getId())) {
                    keys.add(link.getId2());
                    continue;
                }
                keys.add(link.getId1());
            }
            return new ArrayList(this.getDao().readAll(obj.getAppid(), keys, true).values());
        }

        @Override
        public <P extends ParaObject> P getParent(ParaObject obj) {
            return this.getDao().read(obj.getAppid(), obj.getParentid());
        }

        @Override
        public <P extends ParaObject> P getCreator(ParaObject obj) {
            return this.getDao().read(obj.getAppid(), obj.getCreatorid());
        }

        @Override
        public boolean vote(ParaObject votable, String userid, Votable.VoteValue upDown) {
            if (StringUtils.isBlank((CharSequence)userid) || votable == null || votable.getId() == null || upDown == null) {
                return false;
            }
            if (userid.equals(votable.getCreatorid()) || userid.equals(votable.getId())) {
                return false;
            }
            Vote v = new Vote(userid, votable.getId(), upDown);
            Vote saved = (Vote)this.getDao().read(votable.getAppid(), v.getId());
            boolean done = false;
            if (saved != null) {
                boolean isUpvote = upDown.equals((Object)Votable.VoteValue.UP);
                boolean wasUpvote = saved.isUpvote();
                boolean voteHasChanged = isUpvote ^ wasUpvote;
                if (saved.isExpired()) {
                    done = this.getDao().create(votable.getAppid(), v) != null;
                } else if (saved.isAmendable() && voteHasChanged) {
                    this.getDao().delete(votable.getAppid(), saved);
                    done = true;
                }
            } else {
                boolean bl = done = this.getDao().create(votable.getAppid(), v) != null;
            }
            if (done) {
                votable.setVotes(votable.getVotes() + upDown.getValue());
            }
            return done;
        }
    };


    public static synchronized CoreUtils getInstance() {
        return INSTANCE;
    }

    public abstract DAO getDao();

    public abstract void setDao(DAO var1);

    public abstract Search getSearch();

    public abstract void setSearch(Search var1);

    public abstract Cache getCache();

    public abstract void setCache(Cache var1);

    public abstract IoTServiceFactory getIotFactory();

    public abstract void setIotFactory(IoTServiceFactory var1);

    public abstract List<String> addTags(List<String> var1, String ... var2);

    public abstract List<String> removeTags(List<String> var1, String ... var2);

    public abstract Long countChildren(ParaObject var1, String var2);

    public abstract Long countLinks(ParaObject var1, String var2);

    public abstract void deleteChildren(ParaObject var1, String var2);

    public abstract <P extends ParaObject> List<P> findChildren(ParaObject var1, String var2, String var3, Pager ... var4);

    public abstract <P extends ParaObject> List<P> findLinkedObjects(ParaObject var1, String var2, String var3, String var4, Pager ... var5);

    public abstract <P extends ParaObject> List<P> getChildren(ParaObject var1, String var2, Pager ... var3);

    public abstract <P extends ParaObject> List<P> getChildren(ParaObject var1, String var2, String var3, String var4, Pager ... var5);

    public abstract <P extends ParaObject> P getCreator(ParaObject var1);

    public abstract <P extends ParaObject> List<P> getLinkedObjects(ParaObject var1, String var2, Pager ... var3);

    public abstract List<Linker> getLinks(ParaObject var1, String var2, Pager ... var3);

    public abstract String getName(String var1, String var2);

    public abstract String getObjectURI(ParaObject var1);

    public abstract <P extends ParaObject> P getParent(ParaObject var1);

    public abstract boolean isLinked(ParaObject var1, String var2, String var3);

    public abstract boolean isLinked(ParaObject var1, ParaObject var2);

    public abstract String link(ParaObject var1, String var2);

    public abstract String overwrite(ParaObject var1);

    public abstract String overwrite(String var1, ParaObject var2);

    public abstract void unlink(ParaObject var1, String var2, String var3);

    public abstract void unlinkAll(ParaObject var1);

    public abstract boolean vote(ParaObject var1, String var2, Votable.VoteValue var3);
}

