/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.persistence;

import com.erudika.para.annotations.Locked;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.persistence.DAO;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MockDAO
implements DAO {
    private static final Logger logger = LoggerFactory.getLogger(MockDAO.class);
    private static final Map<String, Map<String, ParaObject>> MAPS = new ConcurrentHashMap<String, Map<String, ParaObject>>();

    @Override
    public <P extends ParaObject> String create(String appid, P so) {
        if (so == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)so.getId())) {
            so.setId(Utils.getNewId());
        }
        if (so.getTimestamp() == null) {
            so.setTimestamp(Utils.timestamp());
        }
        so.setAppid(appid);
        this.getMap(appid).put(so.getId(), (ParaObject)ParaObjectUtils.setAnnotatedFields(ParaObjectUtils.toObject(so.getType()), ParaObjectUtils.getAnnotatedFields(so), null));
        logger.debug("DAO.create() {}", (Object)so.getId());
        return so.getId();
    }

    @Override
    public <P extends ParaObject> P read(String appid, String key) {
        if (key == null || StringUtils.isBlank((CharSequence)appid)) {
            return null;
        }
        ParaObject so = this.getMap(appid).get(key);
        logger.debug("DAO.read() {} -> {}", (Object)key, (Object)so);
        return (P)so;
    }

    @Override
    public <P extends ParaObject> void update(String appid, P so) {
        if (so != null && !StringUtils.isBlank((CharSequence)appid)) {
            so.setUpdated(Utils.timestamp());
            ParaObject soUpdated = this.getMap(appid).get(so.getId());
            this.getMap(appid).put(so.getId(), ParaObjectUtils.setAnnotatedFields(soUpdated, ParaObjectUtils.getAnnotatedFields(so), Locked.class));
            logger.debug("DAO.update() {}", (Object)so.getId());
        }
    }

    @Override
    public <P extends ParaObject> void delete(String appid, P so) {
        if (so != null && !StringUtils.isBlank((CharSequence)appid)) {
            this.getMap(appid).remove(so.getId());
            logger.debug("DAO.delete() {}", (Object)so.getId());
        }
    }

    @Override
    public <P extends ParaObject> void createAll(String appid, List<P> objects) {
        if (StringUtils.isBlank((CharSequence)appid) || objects == null) {
            return;
        }
        for (ParaObject p : objects) {
            this.create(appid, p);
        }
        logger.debug("DAO.createAll() {}", (Object)objects.size());
    }

    @Override
    public <P extends ParaObject> Map<String, P> readAll(String appid, List<String> keys, boolean getAllColumns) {
        if (keys == null || StringUtils.isBlank((CharSequence)appid)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, P> results = new LinkedHashMap<String, P>(keys.size());
        for (String key : keys) {
            if (!this.getMap(appid).containsKey(key)) continue;
            results.put(key, this.read(appid, key));
        }
        logger.debug("DAO.readAll() {}", (Object)results.size());
        return results;
    }

    @Override
    public <P extends ParaObject> List<P> readPage(String appid, Pager pager) {
        LinkedList<ParaObject> results = new LinkedList<ParaObject>();
        if (StringUtils.isBlank((CharSequence)appid)) {
            return results;
        }
        if (pager == null) {
            pager = new Pager();
        }
        if (pager.getCount() >= (long)this.getMap(appid).size()) {
            return results;
        }
        String lastKey = pager.getLastKey();
        boolean found = false;
        int i = 0;
        for (String key : this.getMap(appid).keySet()) {
            if (lastKey != null && !found) {
                found = key.equals(lastKey);
            } else {
                results.add(this.getMap(appid).get(key));
                ++i;
            }
            if (i < pager.getLimit()) continue;
            pager.setLastKey(key);
            break;
        }
        pager.setCount(pager.getCount() + (long)i);
        return results;
    }

    @Override
    public <P extends ParaObject> void updateAll(String appid, List<P> objects) {
        if (!StringUtils.isBlank((CharSequence)appid) && objects != null) {
            for (ParaObject obj : objects) {
                if (obj == null) continue;
                this.update(appid, obj);
            }
            logger.debug("DAO.updateAll() {}", (Object)objects.size());
        }
    }

    @Override
    public <P extends ParaObject> void deleteAll(String appid, List<P> objects) {
        if (!StringUtils.isBlank((CharSequence)appid) && objects != null) {
            for (ParaObject obj : objects) {
                if (obj == null || !this.getMap(appid).containsKey(obj.getId())) continue;
                this.delete(appid, obj);
            }
            logger.debug("DAO.deleteAll() {}", (Object)objects.size());
        }
    }

    private Map<String, ParaObject> getMap(String appid) {
        if (!MAPS.containsKey(appid)) {
            MAPS.put(appid, new ConcurrentHashMap());
        }
        return MAPS.get(appid);
    }

    @Override
    public <P extends ParaObject> String create(P so) {
        return this.create(Config.getRootAppIdentifier(), so);
    }

    @Override
    public <P extends ParaObject> P read(String key) {
        return this.read(Config.getRootAppIdentifier(), key);
    }

    @Override
    public <P extends ParaObject> void update(P so) {
        this.update(Config.getRootAppIdentifier(), so);
    }

    @Override
    public <P extends ParaObject> void delete(P so) {
        this.delete(Config.getRootAppIdentifier(), so);
    }

    @Override
    public <P extends ParaObject> void createAll(List<P> objects) {
        this.createAll(Config.getRootAppIdentifier(), objects);
    }

    @Override
    public <P extends ParaObject> Map<String, P> readAll(List<String> keys, boolean getAllColumns) {
        return this.readAll(Config.getRootAppIdentifier(), keys, getAllColumns);
    }

    @Override
    public <P extends ParaObject> List<P> readPage(Pager pager) {
        return this.readPage(Config.getRootAppIdentifier(), pager);
    }

    @Override
    public <P extends ParaObject> void updateAll(List<P> objects) {
        this.updateAll(Config.getRootAppIdentifier(), objects);
    }

    @Override
    public <P extends ParaObject> void deleteAll(List<P> objects) {
        this.deleteAll(Config.getRootAppIdentifier(), objects);
    }
}

