/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.annotations.Stored;
import com.erudika.para.core.Sysprop;
import com.erudika.para.utils.Utils;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.URL;

public class Webhook
extends Sysprop {
    private static final long serialVersionUID = 1L;
    @Stored
    @NotBlank
    @URL
    private String targetUrl;
    @Stored
    @NotBlank
    private String secret;
    @Stored
    private String typeFilter;
    @Stored
    private Boolean urlEncoded;
    @Stored
    private Boolean active;
    @Stored
    private Boolean tooManyFailures;
    @Stored
    private Boolean create;
    @Stored
    private Boolean update;
    @Stored
    private Boolean delete;
    @Stored
    private Boolean createAll;
    @Stored
    private Boolean updateAll;
    @Stored
    private Boolean deleteAll;

    public Webhook() {
        this(null);
    }

    public Webhook(String targetUrl) {
        this.targetUrl = targetUrl;
        this.urlEncoded = true;
        this.create = false;
        this.update = false;
        this.delete = false;
        this.createAll = false;
        this.updateAll = false;
        this.deleteAll = false;
        this.active = false;
        this.tooManyFailures = false;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(String typeFilter) {
        this.typeFilter = typeFilter;
    }

    public Boolean getUrlEncoded() {
        return this.urlEncoded;
    }

    public void setUrlEncoded(Boolean urlEncoded) {
        this.urlEncoded = urlEncoded;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean getTooManyFailures() {
        return this.tooManyFailures;
    }

    public void setTooManyFailures(Boolean tooManyFailures) {
        this.tooManyFailures = tooManyFailures;
    }

    public Boolean getCreate() {
        return this.create;
    }

    public void setCreate(Boolean create) {
        this.create = create;
    }

    public Boolean getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean update) {
        this.update = update;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public Boolean getCreateAll() {
        return this.createAll;
    }

    public void setCreateAll(Boolean createAll) {
        this.createAll = createAll;
    }

    public Boolean getUpdateAll() {
        return this.updateAll;
    }

    public void setUpdateAll(Boolean updateAll) {
        this.updateAll = updateAll;
    }

    public Boolean getDeleteAll() {
        return this.deleteAll;
    }

    public void setDeleteAll(Boolean deleteAll) {
        this.deleteAll = deleteAll;
    }

    public void resetSecret() {
        this.secret = Utils.generateSecurityToken();
    }

    @Override
    public void update() {
        if (this.active.booleanValue()) {
            this.tooManyFailures = false;
        }
        super.update();
    }

    @Override
    public String create() {
        if (StringUtils.isBlank((CharSequence)this.secret)) {
            this.resetSecret();
        }
        if (this.create.booleanValue() || this.update.booleanValue() || this.delete.booleanValue() || this.createAll.booleanValue() || this.updateAll.booleanValue() || this.deleteAll.booleanValue()) {
            this.active = true;
        }
        return super.create();
    }
}

