/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.rest;

import com.erudika.para.Para;
import com.erudika.para.core.utils.ParaObjectUtils;
import com.erudika.para.utils.Config;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.signer.internal.BaseAws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public final class Signer
extends BaseAws4Signer {
    private static final Logger logger = LoggerFactory.getLogger(Signer.class);
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneId.of("Z"));

    public Map<String, String> sign(String httpeMethod, String endpoint, String resourcePath, Map<String, String> headers, Map<String, String> params, InputStream entity, String accessKey, String secretKey) {
        String date = (String)Optional.ofNullable(headers).orElse(Collections.emptyMap()).get("x-amz-date");
        Clock override = date != null ? Clock.fixed(Signer.parseAWSInstant(date), ZoneOffset.UTC) : null;
        SdkHttpFullRequest req = this.buildAWSRequest(httpeMethod, endpoint, resourcePath, headers, params, entity);
        req = this.sign(req, accessKey, secretKey, override);
        HashMap<String, String> headerz = new HashMap<String, String>(req.headers().size());
        for (String header : req.headers().keySet()) {
            headerz.put(header, req.firstMatchingHeader(header).orElse(""));
        }
        return headerz;
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, String accessKey, String secretKey, Clock override) {
        Aws4SignerParams.Builder signerParams = Aws4SignerParams.builder().awsCredentials((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey)).doubleUrlEncode(Boolean.valueOf(true)).signingName("para").signingRegion(Region.US_EAST_1);
        if (override != null) {
            signerParams.signingClockOverride(override);
        }
        return super.sign(request, signerParams.build());
    }

    private SdkHttpFullRequest buildAWSRequest(String httpMethod, String endpoint, String resourcePath, Map<String, String> headers, Map<String, String> params, InputStream entity) {
        SdkHttpFullRequest.Builder r = SdkHttpFullRequest.builder();
        if (!StringUtils.isBlank((CharSequence)httpMethod)) {
            r.method(SdkHttpMethod.valueOf((String)httpMethod));
        }
        if (!StringUtils.isBlank((CharSequence)endpoint)) {
            if (endpoint.startsWith("https://")) {
                r.protocol("HTTPS");
                r.host(StringUtils.removeStart((String)endpoint, (String)"https://"));
            } else if (endpoint.startsWith("http://")) {
                r.protocol("HTTP");
                r.host(StringUtils.removeStart((String)endpoint, (String)"http://"));
            }
        }
        if (!StringUtils.isBlank((CharSequence)resourcePath)) {
            r.encodedPath(resourcePath);
        }
        if (headers != null) {
            headers.remove("host");
            headers.remove("x-amz-date");
            headers.entrySet().forEach(e -> r.putHeader((String)e.getKey(), (String)e.getValue()));
        }
        if (params != null) {
            params.entrySet().forEach(e -> r.appendRawQueryParameter((String)e.getKey(), (String)e.getValue()));
        }
        if (entity != null) {
            r.contentStreamProvider(() -> entity);
        }
        return r.build();
    }

    public static Date parseAWSDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        return Date.from(Signer.parseAWSInstant(date));
    }

    public static Instant parseAWSInstant(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        return LocalDateTime.from(TIME_FORMATTER.parse(date)).toInstant(ZoneOffset.UTC);
    }

    public Response invokeSignedRequest(Client apiClient, String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, Entity<?> entity) {
        byte[] jsonEntity = null;
        if (entity != null) {
            try {
                jsonEntity = ParaObjectUtils.getJsonWriterNoIdent().writeValueAsBytes(entity.getEntity());
            }
            catch (JsonProcessingException ex) {
                jsonEntity = null;
                logger.error(null, (Throwable)ex);
            }
        }
        return this.invokeSignedRequest(apiClient, accessKey, secretKey, httpMethod, endpointURL, reqPath, headers, params, jsonEntity);
    }

    public Response invokeSignedRequest(Client apiClient, String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, byte[] jsonEntity) {
        boolean isJWT = StringUtils.startsWithIgnoreCase((CharSequence)secretKey, (CharSequence)"Bearer");
        WebTarget target = apiClient.target(endpointURL).path(reqPath);
        Map<Object, Object> signedHeaders = new HashMap();
        if (!isJWT) {
            signedHeaders = this.signRequest(accessKey, secretKey, httpMethod, endpointURL, reqPath, headers, params, jsonEntity);
        }
        if (params != null) {
            for (Object param : params.entrySet()) {
                String string = (String)param.getKey();
                List value = (List)param.getValue();
                if (value == null || value.isEmpty() || value.get(0) == null) continue;
                target = target.queryParam(string, value.toArray());
            }
        }
        Invocation.Builder builder = target.request(new String[]{"application/json"});
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                builder.header((String)entry.getKey(), entry.getValue());
            }
        }
        Entity jsonPayload = null;
        if (jsonEntity != null && jsonEntity.length > 0) {
            try {
                jsonPayload = Entity.json((Object)new String(jsonEntity, Config.DEFAULT_ENCODING));
            }
            catch (IOException iOException) {
                logger.error(null, (Throwable)iOException);
            }
        }
        if (isJWT) {
            builder.header("Authorization", (Object)secretKey);
        } else {
            builder.header("Authorization", signedHeaders.get("Authorization")).header("X-Amz-Date", signedHeaders.get("X-Amz-Date"));
        }
        if (Config.getConfigBoolean("user_agent_id_enabled", true)) {
            String string = "Para client " + Para.getVersion() + " " + accessKey + " (Java " + System.getProperty("java.runtime.version") + ")";
            builder.header("User-Agent", (Object)string);
        }
        if (jsonPayload != null) {
            return builder.method(httpMethod, jsonPayload);
        }
        return builder.method(httpMethod);
    }

    public Map<String, String> signRequest(String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, byte[] jsonEntity) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            logger.error("Blank access key: {} {}", (Object)httpMethod, (Object)reqPath);
            return headers;
        }
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            logger.debug("Anonymous request: {} {}", (Object)httpMethod, (Object)reqPath);
            headers.put("Authorization", "Anonymous " + accessKey);
            return headers;
        }
        if (httpMethod == null) {
            httpMethod = "GET";
        }
        ByteArrayInputStream in = null;
        HashMap<String, String> sigParams = new HashMap<String, String>();
        if (params != null) {
            for (Map.Entry param : params.entrySet()) {
                String key = (String)param.getKey();
                List value = (List)param.getValue();
                if (value == null || value.isEmpty() || value.get(0) == null) continue;
                sigParams.put(key, (String)value.get(0));
            }
        }
        if (jsonEntity != null && jsonEntity.length > 0) {
            in = new ByteArrayInputStream(jsonEntity);
        }
        return this.sign(httpMethod, endpointURL, reqPath, headers, sigParams, in, accessKey, secretKey);
    }
}

