/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.annotations.Stored;
import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Utils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParaObjectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParaObjectUtils.class);
    private static final Map<String, String> CORE_TYPES = new DualHashBidiMap();
    private static final Map<String, String> CORE_PARA_TYPES = new DualHashBidiMap();
    private static final Map<String, Class<? extends ParaObject>> CORE_CLASSES = new DualHashBidiMap();
    private static final Map<String, Class<? extends ParaObject>> CORE_PARA_CLASSES = new DualHashBidiMap();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    private ParaObjectUtils() {
    }

    public static ObjectMapper getJsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectReader getJsonReader(Class<?> type) {
        return JSON_MAPPER.reader().forType(type);
    }

    public static ObjectWriter getJsonWriter() {
        return JSON_MAPPER.writer();
    }

    public static ObjectWriter getJsonWriterNoIdent() {
        return JSON_MAPPER.writer().without(SerializationFeature.INDENT_OUTPUT);
    }

    public static Map<String, String> getCoreTypes() {
        if (CORE_TYPES.isEmpty()) {
            try {
                for (Class<? extends ParaObject> clazz : ParaObjectUtils.getCoreClassesMap().values()) {
                    ParaObject p = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    CORE_TYPES.put(p.getPlural(), p.getType());
                }
            }
            catch (Exception ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return Collections.unmodifiableMap(CORE_TYPES);
    }

    public static Map<String, String> getCoreParaTypes() {
        if (CORE_PARA_TYPES.isEmpty()) {
            try {
                ParaObjectUtils.getCoreClassesMap();
                for (Class<? extends ParaObject> clazz : CORE_PARA_CLASSES.values()) {
                    ParaObject p = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    CORE_PARA_TYPES.put(p.getPlural(), p.getType());
                }
            }
            catch (Exception ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return Collections.unmodifiableMap(CORE_PARA_TYPES);
    }

    public static Map<String, String> getAllTypes(App app) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(ParaObjectUtils.getCoreTypes());
        if (app != null) {
            map.putAll(app.getDatatypes());
        }
        return map;
    }

    public static String getAppidFromAuthHeader(String authorization) {
        if (StringUtils.isBlank((CharSequence)authorization)) {
            return "";
        }
        String appid = "";
        if (StringUtils.startsWith((CharSequence)authorization, (CharSequence)"Bearer")) {
            try {
                Map jwt;
                String[] parts = StringUtils.split((String)authorization, (char)'.');
                if (parts.length > 1 && (jwt = (Map)ParaObjectUtils.getJsonReader(Map.class).readValue(Utils.base64dec(parts[1]))) != null && jwt.containsKey("appid")) {
                    appid = (String)jwt.get("appid");
                }
            }
            catch (Exception exception) {}
        } else {
            appid = StringUtils.startsWith((CharSequence)authorization, (CharSequence)"Anonymous") ? StringUtils.substringAfter((String)authorization, (String)"Anonymous").trim() : StringUtils.substringBetween((String)authorization, (String)"=", (String)"/");
        }
        if (StringUtils.isBlank((CharSequence)appid)) {
            return "";
        }
        return App.id(appid).substring(4);
    }

    public static boolean typesMatch(ParaObject so) {
        return so == null ? false : so.getClass().equals(ParaObjectUtils.toClass(so.getType()));
    }

    public static <P extends ParaObject> Map<String, Object> getAnnotatedFields(P pojo) {
        return ParaObjectUtils.getAnnotatedFields(pojo, null);
    }

    public static <P extends ParaObject> Map<String, Object> getAnnotatedFields(P pojo, Class<? extends Annotation> filter) {
        return ParaObjectUtils.getAnnotatedFields(pojo, filter, true);
    }

    public static <P extends ParaObject> Map<String, Object> getAnnotatedFields(P pojo, boolean flattenNestedObjectsToString) {
        return ParaObjectUtils.getAnnotatedFields(pojo, null, flattenNestedObjectsToString);
    }

    public static <P extends ParaObject> Map<String, Object> getAnnotatedFields(P pojo, Class<? extends Annotation> filter, boolean flattenNestedObjectsToString) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (pojo == null) {
            return map;
        }
        try {
            List<Field> fields = Utils.getAllDeclaredFields(pojo.getClass());
            HashSet<String> annotatedFields = new HashSet<String>(fields.size());
            boolean hasJsonAnnotations = false;
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Stored.class) || ParaObjectUtils.isIgnoredField(field, filter)) continue;
                String name = field.getName();
                Object value = PropertyUtils.getProperty(pojo, (String)name);
                if (!Utils.isBasicType(field.getType()) && flattenNestedObjectsToString) {
                    value = ParaObjectUtils.getJsonWriterNoIdent().writeValueAsString(value);
                }
                if (Arrays.stream(field.getAnnotations()).map(a -> a.annotationType().getSimpleName()).anyMatch(a -> StringUtils.startsWithIgnoreCase((CharSequence)a, (CharSequence)"Json"))) {
                    annotatedFields.add(name);
                    hasJsonAnnotations = true;
                }
                map.put(name, value);
            }
            if (hasJsonAnnotations) {
                JsonNode dataNode = ParaObjectUtils.getJsonMapper().valueToTree(pojo);
                Map props = (Map)ParaObjectUtils.getJsonMapper().convertValue((Object)dataNode, Map.class);
                for (Map.Entry entry : props.entrySet()) {
                    if (!annotatedFields.contains(entry.getKey())) continue;
                    map.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
        return Collections.unmodifiableMap(map);
    }

    public static <P extends ParaObject> P setAnnotatedFields(Map<String, Object> data) {
        return ParaObjectUtils.setAnnotatedFields(null, data, null);
    }

    public static <P extends ParaObject> P setAnnotatedFields(P pojo, Map<String, Object> data, Class<? extends Annotation> filter) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            if (pojo == null) {
                pojo = ParaObjectUtils.toClass((String)data.get("type")).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            List<Field> fields = Utils.getAllDeclaredFields(pojo.getClass());
            LinkedHashMap<String, Object> unknownProps = new LinkedHashMap<String, Object>(data);
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(data.size());
            for (Field field : fields) {
                String name = field.getName();
                Object value = data.get(name);
                if (field.isAnnotationPresent(Stored.class) && !ParaObjectUtils.isIgnoredField(field, filter)) {
                    if (value == null && PropertyUtils.isReadable(pojo, (String)name)) {
                        value = PropertyUtils.getProperty(pojo, (String)name);
                    }
                    if (!Utils.isBasicType(field.getType()) && value instanceof String) {
                        value = ParaObjectUtils.parseFlattenedObject(field, value.toString(), props);
                    }
                    ParaObjectUtils.setAnnotatedField(pojo, props, name, value);
                }
                unknownProps.remove(name);
                if (!ParaObjectUtils.isPropertiesFieldOfDifferentType(name, value)) continue;
                unknownProps.put("properties", value);
            }
            if (!props.isEmpty()) {
                JsonNode dataNode = (JsonNode)ParaObjectUtils.getJsonMapper().convertValue(props, JsonNode.class);
                ParaObjectUtils.getJsonMapper().readerForUpdating(pojo).readValue(dataNode);
            }
            ParaObjectUtils.setUserDefinedProperties(pojo, unknownProps);
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
            pojo = null;
        }
        return pojo;
    }

    private static Object parseFlattenedObject(Field field, String stringValue, Map<String, Object> props) {
        try {
            return ParaObjectUtils.getJsonMapper().readValue(stringValue, ParaObjectUtils.getJsonMapper().constructType(field.getGenericType()));
        }
        catch (Exception e) {
            if (!ParaObjectUtils.isPropertiesField(field.getName())) {
                props.put(field.getName(), stringValue);
            }
            return stringValue;
        }
    }

    private static <P> void setAnnotatedField(P pojo, Map<String, Object> props, String name, Object value) {
        block3: {
            if (value != null && !props.containsKey(name)) {
                try {
                    BeanUtils.setProperty(pojo, (String)name, (Object)value);
                }
                catch (Exception e) {
                    if (ParaObjectUtils.isPropertiesField(name)) break block3;
                    props.put(name, value);
                }
            }
        }
    }

    private static boolean isPropertiesField(String name) {
        return "properties".equals(name);
    }

    private static boolean isPropertiesFieldOfDifferentType(String name, Object value) {
        return ParaObjectUtils.isPropertiesField(name) && !(value instanceof Map);
    }

    private static boolean isIgnoredField(Field field, Class<? extends Annotation> filter) {
        return filter == null ? false : field.isAnnotationPresent(filter);
    }

    private static <P> void setUserDefinedProperties(P pojo, Map<String, Object> props) {
        if (props != null && pojo instanceof Sysprop) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (PropertyUtils.isReadable(pojo, (String)name) && !ParaObjectUtils.isPropertiesFieldOfDifferentType(name, value)) continue;
                if (value == null) {
                    ((Sysprop)pojo).removeProperty(name);
                    continue;
                }
                ((Sysprop)pojo).addProperty(name, value);
            }
        }
    }

    public static <P extends ParaObject> P toObject(App app, String type) {
        try {
            if (app == null) {
                return (P)ParaObjectUtils.toClass(type).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Map<String, String> alltypes = ParaObjectUtils.getAllTypes(app);
            String typ = alltypes.containsKey(type) ? alltypes.get(type) : type;
            ParaObject p = ParaObjectUtils.toClass(type).getConstructor(new Class[0]).newInstance(new Object[0]);
            p.setType(typ);
            return (P)p;
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
            return null;
        }
    }

    public static Class<? extends ParaObject> toClass(String type) {
        return ParaObjectUtils.toClass(type, Sysprop.class);
    }

    public static Class<? extends ParaObject> toClass(String type, Class<? extends ParaObject> defaultClass) {
        Class<? extends ParaObject> returnClass = defaultClass;
        if (StringUtils.isBlank((CharSequence)type) || !ParaObjectUtils.getCoreClassesMap().containsKey(type)) {
            return returnClass;
        }
        return ParaObjectUtils.getCoreClassesMap().get(type);
    }

    public static Map<String, Class<? extends ParaObject>> getCoreClassesMap() {
        if (CORE_CLASSES.isEmpty()) {
            try {
                String corePackage = ParaObject.class.getPackage().getName();
                ClassGraph cg1 = new ClassGraph().enableClassInfo().acceptPackages(new String[]{corePackage});
                try (ScanResult scanResult = cg1.scan();){
                    ClassInfoList classes = scanResult.getClassesImplementing(ParaObject.class.getName()).filter(ci -> !ci.isInterface() && !ci.isAbstract());
                    for (ClassInfo clazz : classes) {
                        CORE_PARA_CLASSES.put(clazz.getSimpleName().toLowerCase(), clazz.loadClass(true));
                    }
                }
                CORE_CLASSES.putAll(CORE_PARA_CLASSES);
                if (!Config.CORE_PACKAGE_NAME.isEmpty()) {
                    ClassGraph cg2 = new ClassGraph().enableClassInfo().acceptPackages(new String[]{Config.CORE_PACKAGE_NAME});
                    try (ScanResult scanResult = cg2.scan();){
                        ClassInfoList classes = scanResult.getClassesImplementing(ParaObject.class.getName()).filter(ci -> !ci.isInterface() && !ci.isAbstract());
                        for (ClassInfo clazz : classes) {
                            CORE_CLASSES.putIfAbsent(clazz.getSimpleName().toLowerCase(), clazz.loadClass(true));
                        }
                    }
                }
                logger.debug("Found {} ParaObject classes: {}", (Object)CORE_CLASSES.size(), CORE_CLASSES);
            }
            catch (Exception ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return Collections.unmodifiableMap(CORE_CLASSES);
    }

    public static <P extends ParaObject> P fromJSON(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            Map map = (Map)ParaObjectUtils.getJsonReader(Map.class).readValue(json);
            return ParaObjectUtils.setAnnotatedFields(map);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return null;
        }
    }

    public static <P extends ParaObject> String toJSON(P obj) {
        if (obj == null) {
            return "{}";
        }
        try {
            return ParaObjectUtils.getJsonWriter().writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return "{}";
        }
    }

    static {
        JSON_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        JSON_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JSON_MAPPER.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        JSON_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        JSON_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JSON_MAPPER.registerModule((Module)new JavaTimeModule());
        JSON_MAPPER.findAndRegisterModules();
    }
}

