/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.rest;

import java.util.LinkedHashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class GenericExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger logger = LoggerFactory.getLogger(GenericExceptionMapper.class);

    public Response toResponse(Exception ex) {
        if (ex instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)ex;
            if (e.getResponse().getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                logger.error("API request error: {}", (Object)e.getMessage());
            }
            return GenericExceptionMapper.getExceptionResponse(e.getResponse().getStatus(), ex.getMessage());
        }
        logger.error("API request error: {}", (Object)ex.getMessage());
        return GenericExceptionMapper.getExceptionResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ex.getMessage());
    }

    public static Response getExceptionResponse(final int status, final String msg) {
        return Response.status((int)status).entity((Object)new LinkedHashMap<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("code", status);
                this.put("message", msg);
            }
        }).type("application/json").build();
    }
}

