/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.queue;

import com.erudika.para.core.queue.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

@Singleton
public class MockQueue
implements Queue {
    private ConcurrentLinkedQueue<String> q = new ConcurrentLinkedQueue();
    private String name;

    public MockQueue() {
        this("queue");
    }

    public MockQueue(String name) {
        this.name = name;
    }

    @Override
    public String pull() {
        String s = this.q.poll();
        return StringUtils.isBlank((CharSequence)s) ? "" : s;
    }

    @Override
    public void push(String task) {
        if (!StringUtils.isBlank((CharSequence)task)) {
            this.q.add(task);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void startPolling() {
        LoggerFactory.getLogger(MockQueue.class).info("Started polling (not really!)...");
    }

    @Override
    public void stopPolling() {
        LoggerFactory.getLogger(MockQueue.class).info("Stopped polling (not really!)...");
    }
}

