/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static com.typesafe.config.Config config;
    private static Map<String, String> configMap;
    public static final String PARA = "para";
    public static final String _TYPE = "type";
    public static final String _APPID = "appid";
    public static final String _CREATORID = "creatorid";
    public static final String _ID = "id";
    public static final String _IDENTIFIER = "identifier";
    public static final String _KEY = "key";
    public static final String _NAME = "name";
    public static final String _PARENTID = "parentid";
    public static final String _PASSWORD = "password";
    public static final String _RESET_TOKEN = "token";
    public static final String _EMAIL_TOKEN = "etoken";
    public static final String _TIMESTAMP = "timestamp";
    public static final String _UPDATED = "updated";
    public static final String _TAGS = "tags";
    public static final String _EMAIL = "email";
    public static final String _GROUPS = "groups";
    public static final String _VERSION = "version";
    public static final String _PROPERTIES = "properties";
    public static final int DEFAULT_LIMIT = 10000;
    public static final String FB_PREFIX = "fb:";
    public static final String GPLUS_PREFIX = "gp:";
    public static final String LINKEDIN_PREFIX = "in:";
    public static final String TWITTER_PREFIX = "tw:";
    public static final String GITHUB_PREFIX = "gh:";
    public static final String MICROSOFT_PREFIX = "ms:";
    public static final String SLACK_PREFIX = "sl:";
    public static final String MATTERMOST_PREFIX = "mm:";
    public static final String AMAZON_PREFIX = "az:";
    public static final String OAUTH2_PREFIX = "oa2:";
    public static final String OAUTH2_SECOND_PREFIX = "oa2second:";
    public static final String OAUTH2_THIRD_PREFIX = "oa2third:";
    public static final String LDAP_PREFIX = "ldap:";
    public static final String SAML_PREFIX = "saml:";

    public Config() {
        this.init(null);
    }

    public abstract String getConfigRootPrefix();

    final void init(com.typesafe.config.Config conf) {
        try {
            config = ConfigFactory.load().getConfig(this.getConfigRootPrefix());
            if (conf != null) {
                config = conf.withFallback((ConfigMergeable)config);
            }
            configMap = new HashMap<String, String>();
            for (Map.Entry con : config.entrySet()) {
                if (((ConfigValue)con.getValue()).valueType() == ConfigValueType.LIST) continue;
                configMap.put((String)con.getKey(), config.getString((String)con.getKey()));
            }
        }
        catch (Exception ex) {
            logger.warn("Para configuration file 'application.(conf|json|properties)' is invalid or missing from classpath.");
            config = ConfigFactory.empty();
        }
    }

    public boolean getConfigBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getConfigParam(key, Boolean.toString(defaultValue)));
    }

    public int getConfigInt(String key, int defaultValue) {
        return NumberUtils.toInt((String)this.getConfigParam(key, Integer.toString(defaultValue)));
    }

    public double getConfigDouble(String key, double defaultValue) {
        return NumberUtils.toDouble((String)this.getConfigParam(key, Double.toString(defaultValue)));
    }

    public String getConfigParam(String key, String defaultValue) {
        if (config == null) {
            this.init(null);
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return defaultValue;
        }
        String keyVar = key.replaceAll("\\.", "_");
        String env = System.getenv(keyVar) == null ? System.getenv(this.getConfigRootPrefix() + "_" + keyVar) : System.getenv(keyVar);
        String sys = System.getProperty(key, System.getProperty(this.getConfigRootPrefix() + "." + key));
        if (!StringUtils.isBlank((CharSequence)sys)) {
            return sys;
        }
        if (!StringUtils.isBlank((CharSequence)env)) {
            return env;
        }
        return !StringUtils.isBlank((CharSequence)key) && config.hasPath(key) ? config.getString(key) : defaultValue;
    }

    public com.typesafe.config.Config getConfig() {
        if (config == null) {
            this.init(null);
        }
        return config;
    }
}

