/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.core.App;
import com.erudika.para.core.utils.Config;
import com.erudika.para.core.utils.Utils;
import org.apache.commons.lang3.math.NumberUtils;

public class ParaConfig
extends Config {
    @Override
    public String getConfigRootPrefix() {
        return "para";
    }

    public String separator() {
        return this.getConfigParam("default_separator", ":");
    }

    public int maxItemsPerPage() {
        return this.getConfigInt("max_items_per_page", 30);
    }

    public int maxPages() {
        return this.getConfigInt("max_pages", 1000);
    }

    public int maxPageLimit() {
        return this.getConfigInt("max_page_limit", 256);
    }

    public int minPasswordLength() {
        return this.getConfigInt("min_password_length", 8);
    }

    public int maxDatatypesPerApp() {
        return this.getConfigInt("max_datatypes_per_app", 256);
    }

    public int maxEntitySizeBytes() {
        return this.getConfigInt("max_entity_size_bytes", 0x100000);
    }

    public String defaultEncoding() {
        return this.getConfigParam("default_encoding", "UTF-8");
    }

    public String environment() {
        return this.getConfigParam("env", "embedded");
    }

    public String facebookAppId() {
        return this.getConfigParam("fb_app_id", "");
    }

    public String facebookSecret() {
        return this.getConfigParam("fb_secret", "");
    }

    public String googleAppId() {
        return this.getConfigParam("gp_app_id", "");
    }

    public String googleSecret() {
        return this.getConfigParam("gp_secret", "");
    }

    public String linkedinAppId() {
        return this.getConfigParam("in_app_id", "");
    }

    public String linkedinSecret() {
        return this.getConfigParam("in_secret", "");
    }

    public String twitetAppId() {
        return this.getConfigParam("tw_app_id", "");
    }

    public String twitterSecret() {
        return this.getConfigParam("tw_secret", "");
    }

    public String githubAppId() {
        return this.getConfigParam("gh_app_id", "");
    }

    public String githubSecret() {
        return this.getConfigParam("gh_secret", "");
    }

    public String microsoftAppId() {
        return this.getConfigParam("ms_app_id", "");
    }

    public String microsoftSecret() {
        return this.getConfigParam("ms_secret", "");
    }

    public String slackAppId() {
        return this.getConfigParam("sl_app_id", "");
    }

    public String slackSecret() {
        return this.getConfigParam("sl_secret", "");
    }

    public String mattermostAppId() {
        return this.getConfigParam("mm_app_id", "");
    }

    public String mattermostSecret() {
        return this.getConfigParam("mm_secret", "");
    }

    public String amazonAppId() {
        return this.getConfigParam("az_app_id", "");
    }

    public String amazonSecret() {
        return this.getConfigParam("az_secret", "");
    }

    public String adminIdentifier() {
        return this.getConfigParam("admin_ident", "");
    }

    public String workerId() {
        return this.getConfigParam("worker_id", "1");
    }

    public int executorThreads() {
        return this.getConfigInt("executor_threads", 2);
    }

    public String appName() {
        return this.getConfigParam("app_name", "para");
    }

    public String returnToCookieName() {
        return this.getConfigParam("returnto_cookie", "para".concat("-returnto"));
    }

    public String supportEmail() {
        return this.getConfigParam("support_email", "support@myapp.co");
    }

    public String appSecretKey() {
        return this.getConfigParam("app_secret_key", Utils.md5("paraseckey"));
    }

    public String defaultQueueName() {
        return this.getConfigParam("default_queue_name", "para-default");
    }

    public String corePackageName() {
        return this.getConfigParam("core_package_name", "");
    }

    public int requestExpiresAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("request_expires_after", ""), (int)900);
    }

    public int jwtExpiresAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("jwt_expires_after", ""), (int)86400);
    }

    public int jwtRefreshIntervalSec() {
        return NumberUtils.toInt((String)this.getConfigParam("jwt_refresh_interval", ""), (int)3600);
    }

    public int idTokenExpiresAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("id_token_expires_after", ""), (int)60);
    }

    public int sessionTimeoutSec() {
        return NumberUtils.toInt((String)this.getConfigParam("session_timeout", ""), (int)86400);
    }

    public int voteExpiresAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("vote_expires_after", ""), (int)2592000);
    }

    public int voteLockedAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("vote_locked_after", ""), (int)30);
    }

    public int passwordResetTimeoutSec() {
        return NumberUtils.toInt((String)this.getConfigParam("pass_reset_timeout", ""), (int)1800);
    }

    public boolean apiEnabled() {
        return Boolean.parseBoolean(this.getConfigParam("api_enabled", "true"));
    }

    public boolean corsEnabled() {
        return Boolean.parseBoolean(this.getConfigParam("cors_enabled", "true"));
    }

    public boolean gzipEnabled() {
        return Boolean.parseBoolean(this.getConfigParam("gzip_enabled", "false"));
    }

    public boolean webhooksEnabled() {
        return Boolean.parseBoolean(this.getConfigParam("webhooks_enabled", "false"));
    }

    public boolean inProduction() {
        return this.environment().equals("production");
    }

    public boolean inDevelopment() {
        return this.environment().equals("development");
    }

    public String clusterName() {
        return this.getConfigParam("cluster_name", this.inProduction() ? "para-prod" : "para-dev");
    }

    public boolean isCacheEnabled() {
        return this.getConfigBoolean("cache_enabled", this.environment().equals("production"));
    }

    public boolean isSearchEnabled() {
        return this.getConfigBoolean("search_enabled", true);
    }

    public String getRootAppIdentifier() {
        return App.identifier(App.id(this.appName()));
    }
}

