/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.core.App;
import com.erudika.para.core.annotations.Documented;
import com.erudika.para.core.utils.Config;
import com.erudika.para.core.utils.Utils;
import com.typesafe.config.ConfigObject;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ParaConfig
extends Config {
    @Override
    public String getConfigRootPrefix() {
        return "para";
    }

    public String separator() {
        return this.getConfigParam("default_separator", ":");
    }

    public int maxItemsPerPage() {
        return this.getConfigInt("max_items_per_page", 30);
    }

    public int maxPages() {
        return this.getConfigInt("max_pages", 1000);
    }

    public int maxPageLimit() {
        return this.getConfigInt("max_page_limit", 256);
    }

    public int minPasswordLength() {
        return this.getConfigInt("min_password_length", 8);
    }

    public int maxDatatypesPerApp() {
        return this.getConfigInt("max_datatypes_per_app", 256);
    }

    public int maxEntitySizeBytes() {
        return this.getConfigInt("max_entity_size_bytes", 0x100000);
    }

    public String defaultEncoding() {
        return this.getConfigParam("default_encoding", "UTF-8");
    }

    public String environment() {
        return this.getConfigParam("env", "embedded");
    }

    public String facebookAppId() {
        return this.getConfigParam("fb_app_id", "");
    }

    public String facebookSecret() {
        return this.getConfigParam("fb_secret", "");
    }

    public String googleAppId() {
        return this.getConfigParam("gp_app_id", "");
    }

    public String googleSecret() {
        return this.getConfigParam("gp_secret", "");
    }

    public String linkedinAppId() {
        return this.getConfigParam("in_app_id", "");
    }

    public String linkedinSecret() {
        return this.getConfigParam("in_secret", "");
    }

    public String twitetAppId() {
        return this.getConfigParam("tw_app_id", "");
    }

    public String twitterSecret() {
        return this.getConfigParam("tw_secret", "");
    }

    public String githubAppId() {
        return this.getConfigParam("gh_app_id", "");
    }

    public String githubSecret() {
        return this.getConfigParam("gh_secret", "");
    }

    public String microsoftAppId() {
        return this.getConfigParam("ms_app_id", "");
    }

    public String microsoftSecret() {
        return this.getConfigParam("ms_secret", "");
    }

    public String slackAppId() {
        return this.getConfigParam("sl_app_id", "");
    }

    public String slackSecret() {
        return this.getConfigParam("sl_secret", "");
    }

    public String mattermostAppId() {
        return this.getConfigParam("mm_app_id", "");
    }

    public String mattermostSecret() {
        return this.getConfigParam("mm_secret", "");
    }

    public String amazonAppId() {
        return this.getConfigParam("az_app_id", "");
    }

    public String amazonSecret() {
        return this.getConfigParam("az_secret", "");
    }

    public String adminIdentifier() {
        return this.getConfigParam("admin_ident", "");
    }

    public String workerId() {
        return this.getConfigParam("worker_id", "1");
    }

    public int executorThreads() {
        return this.getConfigInt("executor_threads", 2);
    }

    public String appName() {
        return this.getConfigParam("app_name", "para");
    }

    public String returnToCookieName() {
        return this.getConfigParam("returnto_cookie", "para".concat("-returnto"));
    }

    public String supportEmail() {
        return this.getConfigParam("support_email", "support@myapp.co");
    }

    public String appSecretKey() {
        return this.getConfigParam("app_secret_key", Utils.md5("paraseckey"));
    }

    public String defaultQueueName() {
        return this.getConfigParam("default_queue_name", "para-default");
    }

    public String corePackageName() {
        return this.getConfigParam("core_package_name", "");
    }

    public int requestExpiresAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("request_expires_after", ""), (int)900);
    }

    public int jwtExpiresAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("jwt_expires_after", ""), (int)86400);
    }

    public int jwtRefreshIntervalSec() {
        return NumberUtils.toInt((String)this.getConfigParam("jwt_refresh_interval", ""), (int)3600);
    }

    public int idTokenExpiresAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("id_token_expires_after", ""), (int)60);
    }

    public int sessionTimeoutSec() {
        return NumberUtils.toInt((String)this.getConfigParam("session_timeout", ""), (int)86400);
    }

    public int voteExpiresAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("vote_expires_after", ""), (int)2592000);
    }

    public int voteLockedAfterSec() {
        return NumberUtils.toInt((String)this.getConfigParam("vote_locked_after", ""), (int)30);
    }

    public int passwordResetTimeoutSec() {
        return NumberUtils.toInt((String)this.getConfigParam("pass_reset_timeout", ""), (int)1800);
    }

    public boolean apiEnabled() {
        return Boolean.parseBoolean(this.getConfigParam("api_enabled", "true"));
    }

    public boolean corsEnabled() {
        return Boolean.parseBoolean(this.getConfigParam("cors_enabled", "true"));
    }

    public boolean gzipEnabled() {
        return Boolean.parseBoolean(this.getConfigParam("gzip_enabled", "false"));
    }

    public boolean webhooksEnabled() {
        return Boolean.parseBoolean(this.getConfigParam("webhooks_enabled", "false"));
    }

    public boolean inProduction() {
        return this.environment().equals("production");
    }

    public boolean inDevelopment() {
        return this.environment().equals("development");
    }

    public String clusterName() {
        return this.getConfigParam("cluster_name", this.inProduction() ? "para-prod" : "para-dev");
    }

    public boolean isCacheEnabled() {
        return this.getConfigBoolean("cache_enabled", this.environment().equals("production"));
    }

    public boolean isSearchEnabled() {
        return this.getConfigBoolean("search_enabled", true);
    }

    public String getRootAppIdentifier() {
        return App.identifier(App.id(this.appName()));
    }

    public boolean appIdSpacePrefixEnabled() {
        return this.getConfigBoolean("prepend_shared_appids_with_space", false);
    }

    public boolean versionBannerEnabled() {
        return this.getConfigBoolean("print_version", true);
    }

    public String pluginFolder() {
        return this.getConfigParam("plugin_folder", "lib/");
    }

    public boolean logoBannerEnabled() {
        return this.getConfigBoolean("print_logo", true);
    }

    public String markdownSoftBreak() {
        return this.getConfigParam("markdown_soft_break", "<br>");
    }

    public boolean queuePollingEnabled() {
        return this.getConfigBoolean("queue_link_enabled", false);
    }

    public boolean accessLogEnabled() {
        return this.getConfigBoolean("access_log_enabled", true);
    }

    @Documented(position=110, identifier="context_path", category="Core", tags={"requires restart"}, description="The context path (subpath) of the web application, defaults to the root path `/`.")
    public String serverContextPath() {
        String context = this.getConfigParam("context_path", "");
        return StringUtils.stripEnd((String)(StringUtils.isBlank((CharSequence)context) ? System.getProperty("server.servlet.context-path", "") : context), (String)"/");
    }

    @Documented(position=60, identifier="port", value="8080", type=Integer.class, category="Core", tags={"requires restart"}, description="The network port of this Para server. Port number should be a number above `1024`.")
    public int serverPort() {
        return NumberUtils.toInt((String)System.getProperty("server.port"), (int)this.getConfigInt("port", 8080));
    }

    public boolean pidFileEnabled() {
        return this.getConfigBoolean("pidfile_enabled", true);
    }

    public String cachePlugin() {
        return this.getConfigParam("cache", "");
    }

    public int caffeineEvictAfterMin() {
        return this.getConfigInt("caffeine.evict_after_minutes", 10);
    }

    public long caffeineCacheSize() {
        return this.getConfigInt("caffeine.cache_size", 10000);
    }

    public String awsSesRegion() {
        return this.getConfigParam("aws_ses_region", "eu-west-1");
    }

    public String emailerPlugin() {
        return this.getConfigParam("emailer", "");
    }

    public boolean metricsEnabled() {
        return this.getConfigBoolean("metrics_enabled", true);
    }

    public int metricsLoggingIntervalSec() {
        return this.getConfigInt("metrics.logging_rate", 60);
    }

    public String metricsGraphiteHost() {
        return this.getConfigParam("metrics.graphite.host", null);
    }

    public int metricsGraphitePort() {
        return this.getConfigInt("metrics.graphite.port", 2003);
    }

    public String metricsGraphitePrefixSystem() {
        return this.getConfigParam("metrics.graphite.prefix_system", null);
    }

    public String metricsGraphitePrefixApps() {
        return this.getConfigParam("metrics.graphite.prefix_apps", null);
    }

    public int metricsGraphitePeriodSec() {
        return this.getConfigInt("metrics.graphite.period", 0);
    }

    public boolean metricsJmxEnabled() {
        return this.getConfigBoolean("metrics.jmx_enabled", false);
    }

    public String sharedTableName() {
        return this.getConfigParam("shared_table_name", "0");
    }

    public boolean awsDynamoEncryptionEnabled() {
        return this.getConfigBoolean("dynamodb.sse_enabled", false);
    }

    public String awsDynamoReplicaRegions() {
        return this.getConfigParam("dynamodb.replica_regions", "");
    }

    public boolean awsDynamoBackupsEnabled() {
        return this.getConfigBoolean("dynamodb.backups_enabled", this.inProduction());
    }

    public boolean awsDynamoProvisionedBillingEnabled() {
        return this.getConfigBoolean("dynamodb.provisioned_mode_enabled", true);
    }

    public int awsDynamoMaxInitialReadCapacity() {
        return this.getConfigInt("dynamodb.max_read_capacity", 10);
    }

    public int awsDynamoMaxInitialWriteCapacity() {
        return this.getConfigInt("dynamodb.max_write_capacity", 5);
    }

    public boolean exceptionOnWriteErrorsEnabled() {
        return this.getConfigBoolean("fail_on_write_errors", true);
    }

    public String daoPlugin() {
        return this.getConfigParam("dao", "");
    }

    public boolean awsSqsLocalQueueEnabled() {
        return this.getConfigBoolean("aws_sqs_local", false);
    }

    public int queuePollingWaitSec() {
        return this.getConfigInt("queue.polling_sleep_seconds", 60);
    }

    public int queuePollingIntervalSec() {
        return this.getConfigInt("queue.polling_interval_seconds", this.inProduction() ? 20 : 5);
    }

    public String queuePlugin() {
        return this.getConfigParam("q", "");
    }

    public int maxFailedWebhookAttempts() {
        return this.getConfigInt("max_failed_webhook_attempts", 10);
    }

    public int riverMaxIndexingRetries() {
        return this.getConfigInt("river.max_indexing_retries", 5);
    }

    public int importBatchSize() {
        return this.getConfigInt("import_batch_size", 100);
    }

    public String searchPlugin() {
        return this.getConfigParam("search", "");
    }

    public boolean csrfProtectionEnabled() {
        return this.getConfigBoolean("security.csrf_protection", true);
    }

    public String csrfCookieName() {
        return this.getConfigParam("security.csrf_cookie", "para-csrf-token");
    }

    public String authCookieName() {
        return this.getConfigParam("auth_cookie", "para".concat("-auth"));
    }

    public String anonymousCsrfCookieName() {
        return this.csrfCookieName() + "-anonid";
    }

    public ConfigObject protectedPaths() {
        return this.getConfig().getObject("security.protected");
    }

    public String signinPath() {
        return this.getConfigParam("security.signin", "/signin");
    }

    public String signinSuccessPath() {
        return this.getConfigParam("security.signin_success", "/");
    }

    public String signinFailurePath() {
        return this.getConfigParam("security.signin_failure", "/signin?error");
    }

    public String signoutPath() {
        return this.getConfigParam("security.signout", "/signout");
    }

    public String signoutSuccessPath() {
        return this.getConfigParam("security.signout_success", this.signinPath());
    }

    public String accessDeniedPath() {
        return this.getConfigParam("security.access_denied", "/403");
    }

    public String returnToPath() {
        return this.getConfigParam("security.returnto", "returnto");
    }

    public boolean rememberMeEnabled() {
        return this.getConfigBoolean("security.remember_me", true);
    }

    public boolean debugRequestSignaturesEnabled() {
        return this.getConfigBoolean("debug_request_signatures", false);
    }

    @Documented(position=1000, identifier="security.ldap.password_param", value="password", category="LDAP Authentication", description="LDAP password parameter name.")
    public String ldapPasswordParameter() {
        return this.getConfigParam("security.ldap.password_param", "password");
    }

    @Documented(position=1010, identifier="security.ldap.username_param", value="username", category="LDAP Authentication", description="LDAP username parameter name.")
    public String ldapUsernameParameter() {
        return this.getConfigParam("security.ldap.username_param", "username");
    }

    @Documented(position=410, identifier="security.allow_unverified_emails", value="false", type=Boolean.class, category="Security", description="Enable/disable email verification after the initial user registration. Users with unverified emails won't be able to sign in, unless they use a social login provider.")
    public boolean allowUnverifiedEmails() {
        return this.getConfigBoolean("security.allow_unverified_emails", false);
    }

    public String awsS3Bucket(String region) {
        return this.getConfigParam("para.s3.bucket", "org.paraio." + region);
    }

    public int awsS3MaxFileSizeMb() {
        return this.getConfigInt("para.s3.max_filesize_mb", 10);
    }

    public String localFileStoreFolder() {
        return this.getConfigParam("para.localstorage.folder", "");
    }

    public int localFileStoreMaxFileSizeMb() {
        return this.getConfigInt("para.localstorage.max_filesize_mb", 10);
    }

    public String fileStoragePlugin() {
        return this.getConfigParam("fs", "");
    }

    public int healthCheckInvervalSec() {
        return this.getConfigInt("health.check_interval", 60);
    }

    public boolean healthCheckEnabled() {
        return this.getConfigBoolean("health_check_enabled", true);
    }

    public String clientSslProtocols() {
        return this.getConfigParam("client.ssl_protocols", "TLSv1.3");
    }

    public String clientSslKeystore() {
        return this.getConfigParam("client.ssl_keystore", "");
    }

    public String clientSslKeystorePassword() {
        return this.getConfigParam("client.ssl_keystore_password", "");
    }

    public String clientSslTruststore() {
        return this.getConfigParam("client.ssl_truststore", "");
    }

    public String clientSslTruststorePassword() {
        return this.getConfigParam("client.ssl_truststore_password", "");
    }

    public boolean clientUserAgentEnabled() {
        return this.getConfigBoolean("user_agent_id_enabled", true);
    }

    public int globalSyncIntervalSec() {
        return this.getConfigInt("indexing_sync_interval_sec", 10);
    }

    public String cassandraHosts() {
        return this.getConfigParam("cassandra.hosts", "localhost");
    }

    public String cassandraKeyspace() {
        return this.getConfigParam("cassandra.keyspace", "para");
    }

    public String cassandraUser() {
        return this.getConfigParam("cassandra.user", "");
    }

    public int cassandraPort() {
        return this.getConfigInt("cassandra.port", 9042);
    }

    public String cassandraPassword() {
        return this.getConfigParam("cassandra.password", "");
    }

    public int cassandraReplicationFactor() {
        return this.getConfigInt("cassandra.replication_factor", 1);
    }

    public boolean cassandraSslEnabled() {
        return this.getConfigBoolean("cassandra.ssl_enabled", false);
    }

    public String cassandraSslProtocols() {
        return this.getConfigParam("cassandra.ssl_protocols", "TLSv1.3");
    }

    public String cassandraSslKeystore() {
        return this.getConfigParam("cassandra.ssl_keystore", "");
    }

    public String cassandraSslKeystorePassword() {
        return this.getConfigParam("cassandra.ssl_keystore_password", "");
    }

    public String cassandraTruststore() {
        return this.getConfigParam("cassandra.ssl_truststore", "");
    }

    public String cassandraTruststorePassword() {
        return this.getConfigParam("cassandra.ssl_truststore_password", "");
    }

    public String h2Host() {
        return this.getConfigParam("db.hostname", "");
    }

    public String h2DataFolder() {
        return this.getConfigParam("db.dir", "./data");
    }

    public String h2User() {
        return this.getConfigParam("db.user", this.getRootAppIdentifier());
    }

    public String h2Password() {
        return this.getConfigParam("db.password", "secret");
    }

    public String h2ServerParameters() {
        String tcpPrefix = StringUtils.isBlank((CharSequence)this.h2Host()) ? "" : "tcp://" + this.h2Host() + "/";
        return this.getConfigParam("db.tcpServer", (String)(tcpPrefix.isEmpty() ? "-baseDir " + this.h2DataFolder() : ""));
    }

    public String getSettingForApp(App app, String key, String defaultValue) {
        if (app != null) {
            Map<String, Object> settings = app.getSettings();
            if (settings.containsKey(key)) {
                return String.valueOf(settings.getOrDefault(key, defaultValue));
            }
            if (app.isRootApp()) {
                return this.getConfigParam(key, defaultValue);
            }
        }
        return defaultValue;
    }

    public String[] getOAuthKeysForApp(App app, String prefix) {
        prefix = StringUtils.removeEnd((String)prefix, (String)this.separator());
        String appIdKey = prefix + "_app_id";
        String secretKey = prefix + "_secret";
        String[] keys = new String[]{"", ""};
        if (app != null) {
            Map<String, Object> settings = app.getSettings();
            if (settings.containsKey(appIdKey) && settings.containsKey(secretKey)) {
                keys[0] = "" + settings.get(appIdKey);
                keys[1] = "" + settings.get(secretKey);
            } else if (app.isRootApp()) {
                keys[0] = this.getConfigParam(appIdKey, "");
                keys[1] = this.getConfigParam(secretKey, "");
            }
        }
        return keys;
    }

    public Map<String, String> getLdapSettingsForApp(App app) {
        HashMap<String, String> ldapSettings = new HashMap<String, String>();
        if (app != null) {
            ldapSettings.put("security.ldap.server_url", "ldap://localhost:8389/");
            ldapSettings.put("security.ldap.active_directory_domain", "");
            ldapSettings.put("security.ldap.base_dn", "dc=springframework,dc=org");
            ldapSettings.put("security.ldap.bind_dn", "");
            ldapSettings.put("security.ldap.bind_pass", "");
            ldapSettings.put("security.ldap.user_search_base", "");
            ldapSettings.put("security.ldap.user_search_filter", "(cn={0})");
            ldapSettings.put("security.ldap.user_dn_pattern", "uid={0}");
            ldapSettings.put("security.ldap.password_attribute", "userPassword");
            Map<String, Object> settings = app.getSettings();
            for (Map.Entry entry : ldapSettings.entrySet()) {
                if (settings.containsKey(entry.getKey())) {
                    entry.setValue("" + settings.get(entry.getKey()));
                    continue;
                }
                if (!app.isRootApp()) continue;
                entry.setValue(this.getConfigParam((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return ldapSettings;
    }

    public String sqlHostUrl() {
        return this.getConfigParam("sql.url", null);
    }

    public String sqlDriver() {
        return this.getConfigParam("sql.driver", null);
    }

    public String sqlUser() {
        return this.getConfigParam("sql.user", "user");
    }

    public String sqlPassword() {
        return this.getConfigParam("sql.password", "secret");
    }

    public int reindexBatchSize(int max) {
        return this.getConfigInt("reindex_batch_size", max);
    }

    public boolean syncIndexWithDatabaseEnabled() {
        return this.getConfigBoolean("sync_index_with_db", true);
    }

    public boolean readFromIndexEnabled() {
        return this.getConfigBoolean("read_from_index", false);
    }

    public String luceneDataFolder() {
        return this.getConfigParam("lucene.dir", Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
    }

    public String elasticsearchFlavor() {
        return this.getConfigParam("es.flavor", "elasticsearch");
    }

    public int elasticsearchRootIndexShards() {
        return this.getConfigInt("es.shards", 2);
    }

    public int elasticsearchChildIndexShards() {
        return this.getConfigInt("es.shards_for_child_apps", 1);
    }

    public int elasticsearchRootIndexReplicas() {
        return this.getConfigInt("es.replicas", 0);
    }

    public int elasticsearchChildIndexReplicas() {
        return this.getConfigInt("es.replicas_for_child_apps", 0);
    }

    public boolean elasticsearchNestedModeEnabled() {
        return this.getConfigBoolean("es.use_nested_custom_fields", false);
    }

    public boolean elasticsearchAsyncModeEnabled() {
        return this.getConfigBoolean("es.async_enabled", false);
    }

    public boolean elasticsearchBulkFlushEnabled() {
        return this.getConfigBoolean("es.bulk.flush_immediately", true);
    }

    public String elasticsearchRestClientScheme() {
        return this.getConfigParam("es.restclient_scheme", this.inProduction() ? "https" : "http");
    }

    public String elasticsearchRestClientHost() {
        return this.getConfigParam("es.restclient_host", "localhost");
    }

    public int elasticsearchRestClientPort() {
        return this.getConfigInt("es.restclient_port", 9200);
    }

    public boolean elasticsearchSignRequestsForAwsEnabled() {
        return this.getConfigBoolean("es.sign_requests_to_aws", this.elasticsearchRestClientHost().contains("amazonaws.com"));
    }

    public String elasticsearchRestClientContextPath() {
        return this.getConfigParam("es.restclient_context_path", "");
    }

    public String elasticsearchAutoExpandReplicas() {
        return this.getConfigParam("es.auto_expand_replicas", "0-1");
    }

    public boolean elasticsearchRootIndexSharingEnabled() {
        return this.getConfigBoolean("es.root_index_sharing_enabled", false);
    }

    public String elasticsearchTrackTotalHits() {
        return this.getConfigParam("es.track_total_hits", "true");
    }

    public String elasticsearchAwsRegion() {
        return this.getConfigParam("es.aws_region", "eu-west-1");
    }

    public String elasticsearchAuthUser() {
        return this.getConfigParam("es.basic_auth_login", "");
    }

    public String elasticsearchAuthPassword() {
        return this.getConfigParam("es.basic_auth_password", "");
    }

    public int elasticsearchBulkSizeLimitMb() {
        return this.getConfigInt("es.bulk.size_limit_mb", 5);
    }

    public int elasticsearchBulkActionLimit() {
        return this.getConfigInt("es.bulk.action_limit", 1000);
    }

    public int elasticsearchBulkConcurrentRequests() {
        return this.getConfigInt("es.bulk.concurrent_requests", 1);
    }

    public int elasticsearchBulkFlushIntervalSec() {
        return this.getConfigInt("es.bulk.flush_interval_ms", 5000);
    }

    public int elasticsearchBulkBackoffDelayMs() {
        return this.getConfigInt("es.bulk.backoff_initial_delay_ms", 50);
    }

    public int elasticsearchBulkBackoffRetries() {
        return this.getConfigInt("es.bulk.max_num_retries", 8);
    }

    public String elasticsearchProxyPath() {
        return this.getConfigParam("es.proxy_path", "_elasticsearch");
    }

    public boolean elasticsearchProxyEnabled() {
        return this.getConfigBoolean("es.proxy_enabled", false);
    }

    public boolean elasticsearchProxyReindexingEnabled() {
        return this.getConfigBoolean("es.proxy_reindexing_enabled", false);
    }

    public boolean hazelcastAsyncEnabled() {
        return this.getConfigBoolean("hc.async_enabled", false);
    }

    public int hazelcastTtlSec() {
        return this.getConfigInt("hc.ttl_seconds", 3600);
    }

    public boolean hazelcastEc2DiscoveryEnabled() {
        return this.getConfigBoolean("hc.ec2_discovery_enabled", true);
    }

    public String hazelcastAwsAccessKey() {
        return this.getConfigParam("aws_access_key", System.getenv("AWS_ACCESS_KEY_ID"));
    }

    public String hazelcastAwsSecretKey() {
        return this.getConfigParam("aws_secret_key", System.getenv("AWS_SECRET_ACCESS_KEY"));
    }

    public String hazelcastEc2DiscoveryGroup() {
        return this.getConfigParam("hc.discovery_group", "hazelcast");
    }

    public int hazelcastMaxCacheSize() {
        return this.getConfigInt("hc.max_size", 5000);
    }

    public Object hazelcastEvictionPolicy() {
        return this.getConfigParam("hc.eviction_policy", "LRU");
    }

    public boolean mongoSslEnabled() {
        return this.getConfigBoolean("mongodb.ssl_enabled", false);
    }

    public boolean mongoSslAllowAll() {
        return this.getConfigBoolean("mongodb.ssl_allow_all", false);
    }

    public String mongoConnectionUri() {
        return this.getConfigParam("mongodb.uri", "");
    }

    public String mongoDatabase() {
        return this.getConfigParam("mongodb.database", this.getRootAppIdentifier());
    }

    public String mongoHost() {
        return this.getConfigParam("mongodb.host", "localhost");
    }

    public int mongoPort() {
        return this.getConfigInt("mongodb.port", 27017);
    }

    public String mongoAuthUser() {
        return this.getConfigParam("mongodb.user", "");
    }

    public String mongoAuthPassword() {
        return this.getConfigParam("mongodb.password", "");
    }
}

