/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.utils;

import com.erudika.para.core.ParaObject;
import com.erudika.para.core.utils.HumanTime;
import com.erudika.para.core.utils.Para;
import com.samskivert.mustache.Mustache;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.ext.emoji.EmojiImageType;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.media.tags.MediaTagsExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[A-Za-z0-9.%'+_\\-]+@[A-Za-z0-9.\\-]+\\.[A-Za-z\\S]{2,20}$");
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final Safelist SAFE_HTML_TAGS = Utils.getHTMLTagsWhitelist();
    private static final MutableDataHolder MD_OPTIONS = Utils.getMarkdownOptions();
    private static final Parser MD_PARSER = Parser.builder((DataHolder)MD_OPTIONS).build();
    private static final HtmlRenderer HTML_RENDERER_STRICT = HtmlRenderer.builder((DataHolder)MD_OPTIONS).build();
    private static final HtmlRenderer HTML_RENDERER_LOOSE = HtmlRenderer.builder((DataHolder)MD_OPTIONS.set(HtmlRenderer.ESCAPE_HTML, (Object)false)).build();
    private static HumanTime humantime;
    private static Utils instance;
    private static final long TIMER_OFFSET = 1310084584692L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATACENTER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATACENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATACENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private static long lastTimestamp;
    private static long dataCenterId;
    private static long workerId;
    private static long sequence;

    private Utils() {
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public static HumanTime getHumanTime() {
        if (humantime == null) {
            humantime = new HumanTime();
        }
        return humantime;
    }

    private static void initIdGenerator() {
        String workerID = Para.getConfig().workerId();
        workerId = NumberUtils.toLong((String)workerID, (long)1L);
        if (workerId > 31L || workerId < 0L) {
            workerId = ThreadLocalRandom.current().nextInt(32);
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            dataCenterId = ThreadLocalRandom.current().nextInt(32);
        }
    }

    public static String md5(String s) {
        if (s == null) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes());
            byte[] byteData = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return "";
        }
    }

    public static String hmacSHA256(String message, String secret) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            hmac.init(new SecretKeySpec(secret.getBytes(Para.getConfig().defaultEncoding()), "HmacSHA256"));
            return Utils.base64enc(hmac.doFinal(message.getBytes(Para.getConfig().defaultEncoding())));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String bcrypt(String s) {
        return s == null ? s : BCrypt.hashpw((String)s, (String)BCrypt.gensalt((int)12));
    }

    public static boolean bcryptMatches(String plain, String storedHash) {
        if (StringUtils.isBlank((CharSequence)plain) || StringUtils.isBlank((CharSequence)storedHash)) {
            return false;
        }
        try {
            return BCrypt.checkpw((String)plain, (String)storedHash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String generateSecurityToken(int length, boolean urlSafe) {
        SecureRandom rand;
        byte[] bytes = new byte[length];
        try {
            rand = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(null, (Throwable)ex);
            rand = new SecureRandom();
        }
        rand.nextBytes(bytes);
        return urlSafe ? Utils.base64encURL(bytes) : Utils.base64enc(bytes);
    }

    public static String generateSecurityToken(int length) {
        return Utils.generateSecurityToken(length, false);
    }

    public static String generateSecurityToken() {
        return Utils.generateSecurityToken(32);
    }

    public static String escapeJavascript(String str) {
        return str == null ? "" : StringEscapeUtils.escapeEcmaScript((String)str);
    }

    public static String stripHtml(String html) {
        return html == null ? "" : Jsoup.parse((String)html).text();
    }

    public static String markdownToHtml(String markdownString) {
        return Utils.markdownToHtml(markdownString, false);
    }

    public static String markdownToHtml(String markdownString, boolean htmlTagsRenderingEnabled) {
        if (StringUtils.isBlank((CharSequence)markdownString)) {
            return "";
        }
        Document parsed = MD_PARSER.parse(markdownString);
        if (htmlTagsRenderingEnabled) {
            return Jsoup.clean((String)HTML_RENDERER_LOOSE.render((Node)parsed), (Safelist)SAFE_HTML_TAGS);
        }
        return HTML_RENDERER_STRICT.render((Node)parsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compileMustache(Map<String, Object> context, String template) {
        if (context == null || StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        StringWriter writer = new StringWriter();
        try {
            Mustache.compiler().escapeHTML(false).emptyStringIsFalse(true).compile(template).execute(context, (Writer)writer);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                logger.error(null, (Throwable)e);
            }
        }
        return ((Object)writer).toString();
    }

    public static String abbreviate(String str, int max) {
        return StringUtils.isBlank((CharSequence)str) ? "" : StringUtils.abbreviate((String)str, (int)max);
    }

    public static String arrayJoin(List<String> arr, String separator) {
        return arr == null || separator == null ? "" : StringUtils.join(arr, (String)separator);
    }

    public static String stripAndTrim(String str) {
        return Utils.stripAndTrim(str, "");
    }

    public static String stripAndTrim(String str, String replaceWith) {
        return Utils.stripAndTrim(str, replaceWith, false);
    }

    public static String stripAndTrim(String str, String replaceWith, boolean asciiOnly) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        String s = str;
        if (asciiOnly) {
            s = str.replaceAll("[^\\p{ASCII}]", "");
        }
        return s.replaceAll("[\\p{S}\\p{P}\\p{C}]", replaceWith).replaceAll("\\p{Z}+", " ").trim();
    }

    public static String noSpaces(String str, String replaceWith) {
        return StringUtils.isBlank((CharSequence)str) ? "" : str.trim().replaceAll("[\\p{C}\\p{Z}]+", StringUtils.trimToEmpty((String)replaceWith)).toLowerCase();
    }

    public static String formatMessage(String msg, Object ... params) {
        try {
            msg = StringUtils.replace((String)msg, (String)"'", (String)"''");
            return StringUtils.isBlank((CharSequence)msg) ? "" : MessageFormat.format(msg, params);
        }
        catch (IllegalArgumentException e) {
            return msg;
        }
    }

    public static String base64enc(byte[] str) {
        if (str == null) {
            return "";
        }
        return new String(Base64.encodeBase64((byte[])str));
    }

    public static String base64encURL(byte[] str) {
        if (str == null) {
            return "";
        }
        return new String(Base64.encodeBase64URLSafe((byte[])str));
    }

    public static String base64dec(String str) {
        if (str == null) {
            return "";
        }
        try {
            return new String(Base64.decodeBase64((String)str), Para.getConfig().defaultEncoding());
        }
        catch (Exception ex) {
            logger.error("Failed to decode base64 string '{}'.", (Object)str, (Object)ex);
            return "";
        }
    }

    private static MutableDataHolder getMarkdownOptions() {
        return new MutableDataSet().set(HtmlRenderer.ESCAPE_HTML, (Object)true).set(HtmlRenderer.SUPPRESSED_LINKS, (Object)"(?i)javascript:.*").set(HtmlRenderer.SOFT_BREAK, (Object)Para.getConfig().markdownSoftBreak()).set(HtmlRenderer.AUTOLINK_WWW_PREFIX, (Object)"https://").set(EmojiExtension.USE_IMAGE_TYPE, (Object)EmojiImageType.UNICODE_FALLBACK_TO_IMAGE).set(TablesExtension.COLUMN_SPANS, (Object)false).set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)true).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true).set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create(), EmojiExtension.create(), StrikethroughExtension.create(), TaskListExtension.create(), AutolinkExtension.create(), MediaTagsExtension.create()));
    }

    private static Safelist getHTMLTagsWhitelist() {
        Safelist whitelist = Safelist.relaxed();
        whitelist.addTags(new String[]{"abbr", "hr", "del", "details", "summary", "center", "audio", "video", "source"});
        whitelist.addProtocols("a", "href", new String[]{"#"});
        whitelist.addEnforcedAttribute("a", "rel", "nofollow");
        whitelist.addAttributes("abbr", new String[]{"title"});
        whitelist.addAttributes("th", new String[]{"align"});
        whitelist.addAttributes("td", new String[]{"align"});
        whitelist.addAttributes("code", new String[]{"class"});
        whitelist.addAttributes("div", new String[]{"class"});
        whitelist.addAttributes("a", new String[]{"rel"});
        whitelist.addAttributes("audio", new String[]{"controls", "autoplay", "muted", "loop"});
        whitelist.addAttributes("video", new String[]{"controls", "autoplay", "muted", "playsinline", "loop"});
        whitelist.addAttributes("source", new String[]{"src", "type"});
        whitelist.addAttributes("details", new String[]{"class", "open"});
        whitelist.addAttributes("h1", new String[]{"id"});
        whitelist.addAttributes("h2", new String[]{"id"});
        whitelist.addAttributes("h3", new String[]{"id"});
        whitelist.addAttributes("h4", new String[]{"id"});
        whitelist.addAttributes("h5", new String[]{"id"});
        whitelist.addAttributes("h6", new String[]{"id"});
        whitelist.addAttributes("h7", new String[]{"id"});
        return whitelist;
    }

    public static String formatDate(Long timestamp, String format, Locale loc) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.getPattern();
        }
        if (timestamp == null) {
            timestamp = Utils.timestamp();
        }
        if (loc == null) {
            loc = Locale.US;
        }
        return DateFormatUtils.format((long)timestamp, (String)format, (Locale)loc);
    }

    public static String formatDate(String format, Locale loc) {
        return Utils.formatDate(Utils.timestamp(), format, loc);
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static long timestamp() {
        return System.currentTimeMillis();
    }

    public static String[] getMonths(Locale locale) {
        if (locale == null) {
            locale = Locale.US;
        }
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        return dfs.getMonths();
    }

    public static Locale getLocale(String localeStr) {
        try {
            return LocaleUtils.toLocale((String)localeStr);
        }
        catch (Exception e) {
            return Locale.US;
        }
    }

    public static int round(float d) {
        return Math.round(d);
    }

    public static String formatPrice(double price) {
        return NUMBER_FORMAT.format(price);
    }

    public static double roundHalfUp(double d) {
        return Utils.roundHalfUp(d, 2);
    }

    public static double roundHalfUp(double d, int scale) {
        return BigDecimal.valueOf(d).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static String abbreviateInt(Number number, int decPlaces) {
        if (number == null) {
            return "";
        }
        Object abbrevn = number.toString();
        decPlaces = (int)Math.pow(10.0, decPlaces);
        String[] abbrev = new String[]{"K", "M", "B", "T"};
        boolean done = false;
        for (int i = abbrev.length - 1; i >= 0 && !done; --i) {
            int size = (int)Math.pow(10.0, (double)(i + 1) * 3.0);
            if (size > number.intValue()) continue;
            number = Math.round((float)(number.intValue() * decPlaces) / (float)size) / decPlaces;
            abbrevn = number + abbrev[i];
            done = true;
        }
        return abbrevn;
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return "";
        }
        String decoded = s;
        try {
            decoded = URLDecoder.decode(s, Para.getConfig().defaultEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(null, (Throwable)ex);
        }
        return decoded;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return "";
        }
        String encoded = s;
        try {
            encoded = URLEncoder.encode(s, Para.getConfig().defaultEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(null, (Throwable)ex);
        }
        return encoded;
    }

    public static boolean isValidURL(String url) {
        return Utils.toURL(url) != null;
    }

    public static boolean isValidEmail(String email) {
        return email != null && EMAIL_PATTERN.matcher(email).matches();
    }

    public static String getHostFromURL(String url) {
        URL u = Utils.toURL(url);
        String host = u == null ? "" : u.getHost();
        return host;
    }

    public static String getBaseURL(String url) {
        URL u = Utils.toURL(url);
        String base = null;
        if (u != null) {
            try {
                base = u.toURI().getScheme().concat("://").concat(u.getAuthority());
            }
            catch (URISyntaxException ex) {
                base = null;
            }
        }
        return base;
    }

    private static URL toURL(String url) {
        URL u;
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            u = null;
        }
        return u;
    }

    public static String getObjectURI(ParaObject obj, boolean includeName, boolean includeId) {
        if (obj == null) {
            return "/";
        }
        if (includeId && obj.getId() != null) {
            return includeName && !StringUtils.isBlank((CharSequence)obj.getName()) ? obj.getObjectURI().concat("-").concat(Utils.urlEncode(Utils.noSpaces(obj.getName(), "-"))) : obj.getObjectURI();
        }
        return obj.getObjectURI();
    }

    public static String getSystemProperty(String name) {
        return StringUtils.isBlank((CharSequence)name) ? "" : System.getProperty(name);
    }

    public static boolean isJsonType(String contentType) {
        return StringUtils.startsWith((CharSequence)contentType, (CharSequence)"application/json") || StringUtils.startsWith((CharSequence)contentType, (CharSequence)"application/javascript") || StringUtils.startsWith((CharSequence)contentType, (CharSequence)"text/javascript");
    }

    public static String singularToPlural(String singul) {
        if (!StringUtils.isAsciiPrintable((CharSequence)singul)) {
            return singul;
        }
        return StringUtils.isBlank((CharSequence)singul) || singul.endsWith("es") || singul.endsWith("ies") ? singul : (singul.endsWith("s") ? singul + "es" : (singul.endsWith("y") ? StringUtils.removeEndIgnoreCase((String)singul, (String)"y") + "ies" : singul + "s"));
    }

    public static boolean isBasicType(Class<?> clazz) {
        return clazz == null ? false : clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Long.class) || clazz.equals(Integer.class) || clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Float.class) || clazz.equals(Double.class) || clazz.equals(Character.class);
    }

    public static String type(Class<? extends ParaObject> clazz) {
        return clazz == null ? "" : clazz.getSimpleName().toLowerCase();
    }

    public static List<Field> getAllDeclaredFields(Class<? extends ParaObject> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        if (clazz == null) {
            return fields;
        }
        Class<? extends ParaObject> parent = clazz;
        do {
            for (Field field : parent.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || field.getName().equals("serialVersionUID")) continue;
                fields.add(field);
            }
        } while (!(parent = parent.getSuperclass()).equals(Object.class));
        return fields;
    }

    public static synchronized String getNewId() {
        long timestamp = Utils.timestamp();
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = Utils.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        if (timestamp < lastTimestamp) {
            throw new IllegalStateException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        lastTimestamp = timestamp;
        return Long.toString(timestamp - 1310084584692L << 22 | dataCenterId << 17 | workerId << 12 | sequence);
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = Utils.timestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = Utils.timestamp();
        }
        return timestamp;
    }

    static {
        lastTimestamp = -1L;
        dataCenterId = 0L;
        sequence = 0L;
        Utils.initIdGenerator();
        NUMBER_FORMAT.setMinimumFractionDigits(2);
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }
}

