/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core.validation;

import com.erudika.para.core.annotations.Email;
import com.erudika.para.core.utils.Utils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.validator.constraints.URL;

public abstract class Constraint {
    private String name;
    private Map<String, Object> payload;
    private static final String MSG_PREFIX = "messages.";
    private static final Map<Class<?>, String> VALIDATORS = new HashMap<Class<?>, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Min.class, "min");
            this.put(Max.class, "max");
            this.put(Size.class, "size");
            this.put(Email.class, "email");
            this.put(Digits.class, "digits");
            this.put(Pattern.class, "pattern");
            this.put(NotNull.class, "required");
            this.put(NotEmpty.class, "required");
            this.put(NotBlank.class, "required");
            this.put(AssertFalse.class, "false");
            this.put(AssertTrue.class, "true");
            this.put(Future.class, "future");
            this.put(Past.class, "past");
            this.put(URL.class, "url");
        }
    };
    private static final Map<String, Constraint> SIMPLE_CONSTRAINTS = new HashMap<String, Constraint>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("required", Constraint.required());
            this.put("email", Constraint.email());
            this.put("false", Constraint.falsy());
            this.put("true", Constraint.truthy());
            this.put("future", Constraint.future());
            this.put("past", Constraint.past());
            this.put("url", Constraint.url());
        }
    };

    public abstract boolean isValid(Object var1);

    private Constraint(String name, Map<String, Object> payload) {
        this.name = name;
        this.payload = payload;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getPayload() {
        if (this.payload == null) {
            this.payload = new LinkedHashMap<String, Object>();
        }
        return this.payload;
    }

    public void setPayload(Map<String, Object> payload) {
        this.payload = payload;
    }

    public static boolean matches(Class<? extends Annotation> anno, String consName) {
        return VALIDATORS.get(anno).equals(consName);
    }

    public static Constraint fromAnnotation(Annotation anno) {
        if (anno instanceof Min) {
            return Constraint.min(((Min)anno).value());
        }
        if (anno instanceof Max) {
            return Constraint.max(((Max)anno).value());
        }
        if (anno instanceof Size) {
            return Constraint.size(((Size)anno).min(), ((Size)anno).max());
        }
        if (anno instanceof Digits) {
            return Constraint.digits(((Digits)anno).integer(), ((Digits)anno).fraction());
        }
        if (anno instanceof Pattern) {
            return Constraint.pattern(((Pattern)anno).regexp());
        }
        return new Constraint(VALIDATORS.get(anno.annotationType()), (Map)Constraint.simplePayload(VALIDATORS.get(anno.annotationType()))){

            @Override
            public boolean isValid(Object actualValue) {
                return true;
            }
        };
    }

    static Map<String, Object> simplePayload(String name) {
        if (name == null) {
            return null;
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("message", MSG_PREFIX + name);
        return payload;
    }

    static Map<String, Object> minPayload(Object min) {
        if (min == null) {
            return null;
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("value", min);
        payload.put("message", MSG_PREFIX + VALIDATORS.get(Min.class));
        return payload;
    }

    static Map<String, Object> maxPayload(Object max) {
        if (max == null) {
            return null;
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("value", max);
        payload.put("message", MSG_PREFIX + VALIDATORS.get(Max.class));
        return payload;
    }

    static Map<String, Object> sizePayload(Object min, Object max) {
        if (min == null || max == null) {
            return null;
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("min", min);
        payload.put("max", max);
        payload.put("message", MSG_PREFIX + VALIDATORS.get(Size.class));
        return payload;
    }

    static Map<String, Object> digitsPayload(Object i, Object f) {
        if (i == null || f == null) {
            return null;
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("integer", i);
        payload.put("fraction", f);
        payload.put("message", MSG_PREFIX + VALIDATORS.get(Digits.class));
        return payload;
    }

    static Map<String, Object> patternPayload(Object regex) {
        if (regex == null) {
            return null;
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("value", regex);
        payload.put("message", MSG_PREFIX + VALIDATORS.get(Pattern.class));
        return payload;
    }

    public static boolean isValidConstraintName(String name) {
        return name != null && VALIDATORS.containsValue(name.toLowerCase());
    }

    public static boolean isValidConstraintType(Class<? extends Annotation> type) {
        return type != null && VALIDATORS.containsKey(type);
    }

    public static Constraint required() {
        return new Constraint("required", (Map)Constraint.simplePayload("required")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue != null && !StringUtils.isBlank((CharSequence)actualValue.toString());
            }
        };
    }

    public static Constraint min(final Number min) {
        return new Constraint("min", Constraint.minPayload(min)){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || actualValue instanceof Number && min != null && min.longValue() <= ((Number)actualValue).longValue();
            }
        };
    }

    public static Constraint max(final Number max) {
        return new Constraint("max", Constraint.maxPayload(max)){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || actualValue instanceof Number && max != null && max.longValue() >= ((Number)actualValue).longValue();
            }
        };
    }

    public static Constraint size(final Number min, final Number max) {
        return new Constraint("size", Constraint.sizePayload(min, max)){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null && min != null && max != null) {
                    if (actualValue instanceof String) {
                        return !Constraint.isOutOfRange(((String)actualValue).length(), min, max);
                    }
                    if (actualValue instanceof Collection) {
                        return !Constraint.isOutOfRange(((Collection)actualValue).size(), min, max);
                    }
                    if (actualValue instanceof Map) {
                        return !Constraint.isOutOfRange(((Map)actualValue).size(), min, max);
                    }
                    if (actualValue.getClass().isArray()) {
                        return !Constraint.isOutOfRange(ArrayUtils.getLength((Object)actualValue), min, max);
                    }
                    return false;
                }
                return true;
            }
        };
    }

    private static boolean isOutOfRange(int x, Number min, Number max) {
        return (long)x < min.longValue() || (long)x > max.longValue();
    }

    public static Constraint digits(final Number integer, final Number fraction) {
        return new Constraint("digits", Constraint.digitsPayload(integer, fraction)){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null) {
                    if (!(actualValue instanceof Number) && !(actualValue instanceof String)) {
                        return false;
                    }
                    if (integer != null && fraction != null) {
                        String val = actualValue.toString();
                        String[] split = val.split("[,.]");
                        if (!NumberUtils.isDigits((String)split[0])) {
                            return false;
                        }
                        if (integer.intValue() < split[0].length()) {
                            return false;
                        }
                        if (split.length > 1 && fraction.intValue() < split[1].length()) {
                            return false;
                        }
                    }
                }
                return true;
            }
        };
    }

    public static Constraint pattern(final Object regex) {
        return new Constraint("pattern", Constraint.patternPayload(regex)){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || regex == null || !(regex instanceof String) || actualValue instanceof String && ((String)actualValue).matches((String)regex);
            }
        };
    }

    public static Constraint email() {
        return new Constraint("email", (Map)Constraint.simplePayload("email")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || actualValue instanceof String && Utils.isValidEmail((String)actualValue);
            }
        };
    }

    public static Constraint falsy() {
        return new Constraint("false", (Map)Constraint.simplePayload("false")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || (!(actualValue instanceof Boolean) || (Boolean)actualValue == false) && (!(actualValue instanceof String) || !Boolean.parseBoolean((String)actualValue));
            }
        };
    }

    public static Constraint truthy() {
        return new Constraint("true", (Map)Constraint.simplePayload("true")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || (!(actualValue instanceof Boolean) || (Boolean)actualValue != false) && (!(actualValue instanceof String) || Boolean.parseBoolean((String)actualValue));
            }
        };
    }

    public static Constraint future() {
        return new Constraint("future", (Map)Constraint.simplePayload("future")){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null) {
                    long now = System.currentTimeMillis();
                    if (actualValue instanceof Date && ((Date)actualValue).getTime() <= now || actualValue instanceof Number && ((Number)actualValue).longValue() <= now) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Constraint past() {
        return new Constraint("past", (Map)Constraint.simplePayload("past")){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null) {
                    long now = System.currentTimeMillis();
                    if (actualValue instanceof Date && ((Date)actualValue).getTime() >= now || actualValue instanceof Number && ((Number)actualValue).longValue() >= now) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Constraint url() {
        return new Constraint("url", (Map)Constraint.simplePayload("url")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || Utils.isValidURL(actualValue.toString());
            }
        };
    }

    public static Constraint build(String cname, Map<String, Object> payload) {
        if (cname != null && payload != null) {
            if ("min".equals(cname) && payload.containsKey("value")) {
                return Constraint.min(NumberUtils.toLong((String)String.valueOf(payload.get("value")), (long)0L));
            }
            if ("max".equals(cname) && payload.containsKey("value")) {
                return Constraint.max(NumberUtils.toLong((String)String.valueOf(payload.get("value")), (long)10000L));
            }
            if ("size".equals(cname) && payload.containsKey("min") && payload.containsKey("max")) {
                return Constraint.size(NumberUtils.toLong((String)String.valueOf(payload.get("min")), (long)0L), NumberUtils.toLong((String)String.valueOf(payload.get("max")), (long)10000L));
            }
            if ("digits".equals(cname) && payload.containsKey("integer") && payload.containsKey("fraction")) {
                return Constraint.digits(NumberUtils.toLong((String)String.valueOf(payload.get("integer")), (long)0L), NumberUtils.toLong((String)String.valueOf(payload.get("fraction")), (long)0L));
            }
            if ("pattern".equals(cname) && payload.containsKey("value")) {
                return Constraint.pattern(payload.get("value"));
            }
            return SIMPLE_CONSTRAINTS.get(cname);
        }
        return null;
    }
}

