/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.FacebookParam;
import com.facebook.api.FacebookRestClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Facebook {
    private HttpServletRequest request;
    private HttpServletResponse response;
    protected FacebookRestClient apiClient;
    protected String apiKey;
    protected String secret;
    protected Map<String, String> fbParams;
    protected Long user;
    private static String FACEBOOK_URL_PATTERN = "^https?://([^/]*\\.)?facebook\\.com(:\\d+)?/.*";
    private String sessionKey;
    private boolean inCanvas;
    private boolean added;
    private boolean uninstall;
    private boolean installed;
    private Long canvasUser;
    private Long profileUpdateTime;
    private boolean inProfileTab;
    private Long profileUser;
    private String profileSessionKey;
    private Long pageId;
    private boolean pageAdded;

    public Facebook(HttpServletRequest request, HttpServletResponse response, String apiKey, String secret) {
        this.request = request;
        this.response = response;
        this.apiKey = apiKey;
        this.secret = secret;
        this.apiClient = new FacebookRestClient(this.apiKey, this.secret);
        this.validateFbParams();
        String friends = this.fbParams.get("friends");
        if (friends != null && !friends.equals("")) {
            ArrayList<Long> friendsList = new ArrayList<Long>();
            for (String friend : friends.split(",")) {
                friendsList.add(Long.parseLong(friend));
            }
            this.apiClient.friendsList = friendsList;
        }
        this.added = this.toBoolean(this.fbParams.get("added"));
        this.apiClient.added = this.added;
        this.inCanvas = this.toBoolean(this.fbParams.get("in_canvas"));
        this.inProfileTab = this.toBoolean(this.fbParams.get("in_profile_tab"));
        this.uninstall = this.toBoolean(this.fbParams.get("uninstall"));
        this.installed = this.toBoolean(request.getParameter("installed"));
        this.canvasUser = this.toLong(this.fbParams.get("canvas_user"));
        this.profileUser = this.toLong(this.fbParams.get("profile_user"));
        this.profileSessionKey = this.fbParams.get("profile_session_key");
        this.profileUpdateTime = this.toLong(this.fbParams.get("profile_update_time"));
        this.pageId = this.toLong(this.fbParams.get("page_id"));
        this.pageAdded = this.toBoolean(this.fbParams.get("page_added"));
    }

    private Long toLong(String s) {
        if (s == null) {
            return null;
        }
        return new Long(s);
    }

    private boolean toBoolean(String s) {
        return s != null && s.equals("1");
    }

    public FacebookRestClient getFacebookRestClient() {
        return this.apiClient;
    }

    public FacebookRestClient get_api_client() {
        return this.getFacebookRestClient();
    }

    public String getSecret() {
        return this.secret;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    private void validateFbParams() {
        this.fbParams = this.getValidFbParams(this._getRequestParams(), 172800, FacebookParam.SIGNATURE.toString());
        if (this.fbParams != null && !this.fbParams.isEmpty()) {
            String tmpSt = this.fbParams.get(FacebookParam.USER.getSignatureName());
            Long user_id = tmpSt != null ? Long.valueOf(tmpSt) : null;
            String session_key = this.fbParams.get(FacebookParam.SESSION_KEY.getSignatureName());
            tmpSt = this.fbParams.get(FacebookParam.EXPIRES.getSignatureName());
            Long expires = tmpSt != null ? Long.valueOf(tmpSt) : null;
            this.setUser(user_id, session_key, expires);
        } else {
            Map<String, String> cookieParams = this._getCookiesParams();
            this.fbParams = this.getValidFbParams(cookieParams, null, this.apiKey);
            if (this.fbParams != null && !this.fbParams.isEmpty()) {
                String tmpSt = this.fbParams.get(FacebookParam.USER.getSignatureName());
                Long user_id = tmpSt != null ? Long.valueOf(tmpSt) : null;
                String session_key = this.fbParams.get(FacebookParam.SESSION_KEY.getSignatureName());
                this.setUser(user_id, session_key, null);
            } else if (this.request.getParameter("auth_token") != null) {
                try {
                    this.doGetSession(this.request.getParameter("auth_token"));
                    this.setUser(this.apiClient._userId, this.apiClient._sessionKey, this.apiClient._expires);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String doGetSession(String authToken) {
        try {
            return this.apiClient.auth_getSession(authToken);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setUser(Long user_id, String session_key, Long expires) {
        Map<String, String> cookiesInfo;
        String cookieUser;
        if (!(this.inFbCanvas() || (cookieUser = (cookiesInfo = this._getCookiesParams()).get(this.apiKey + "_user")) != null && cookieUser.equals(user_id + ""))) {
            HashMap<String, String> cookies = new HashMap<String, String>();
            cookies.put("user", user_id + "");
            cookies.put("session_key", session_key);
            String sig = Facebook.generateSig(cookies, this.secret);
            int age = 0;
            if (expires != null) {
                age = (int)(expires - System.currentTimeMillis() / 1000L);
            }
            for (Map.Entry entry : cookies.entrySet()) {
                this.addCookie(this.apiKey + "_" + (String)entry.getKey(), (String)entry.getValue(), age);
            }
            this.addCookie(this.apiKey, sig, age);
        }
        this.user = user_id;
        this.sessionKey = session_key;
        this.apiClient._sessionKey = session_key;
    }

    private void addCookie(String key, String value, int age) {
        Cookie cookie = new Cookie(key, value);
        if (age > 0) {
            cookie.setMaxAge(age);
        }
        cookie.setPath(this.request.getContextPath());
        this.response.addCookie(cookie);
    }

    private Map<String, String> getValidFbParams(Map<String, String> params, Integer timeout, String namespace) {
        if (namespace == null) {
            namespace = "fb_sig";
        }
        String prefix = namespace + "_";
        int prefix_len = prefix.length();
        HashMap<String, String> fb_params = new HashMap<String, String>();
        for (Map.Entry<String, String> requestParam : params.entrySet()) {
            if (requestParam.getKey().indexOf(prefix) != 0) continue;
            fb_params.put(requestParam.getKey().substring(prefix_len), requestParam.getValue());
        }
        if (timeout != null) {
            if (!fb_params.containsKey(FacebookParam.TIME.getSignatureName())) {
                return new HashMap<String, String>();
            }
            String tmpTime = (String)fb_params.get(FacebookParam.TIME.getSignatureName());
            if (tmpTime.indexOf(46) > 0) {
                tmpTime = tmpTime.substring(0, tmpTime.indexOf(46));
            }
            long time = Long.parseLong(tmpTime);
            if (System.currentTimeMillis() / 1000L - time > (long)timeout.intValue()) {
                return new HashMap<String, String>();
            }
        }
        if (!params.containsKey(namespace) || !this.verifySignature(fb_params, params.get(namespace))) {
            return new HashMap<String, String>();
        }
        return fb_params;
    }

    private void redirect(String url) {
        try {
            if (this.inFbCanvas()) {
                String out = "<fb:redirect url=\"" + url + "\"/>";
                this.response.getWriter().print(out);
                this.response.flushBuffer();
            } else if (url.matches(FACEBOOK_URL_PATTERN)) {
                String out = "<script type=\"text/javascript\">\ntop.location.href = \"" + url + "\";\n</script>";
                this.response.getWriter().print(out);
                this.response.flushBuffer();
            } else {
                this.response.sendRedirect(url);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean inFrame() {
        return this.fbParams.containsKey(FacebookParam.IN_CANVAS.getSignatureName()) || this.fbParams.containsKey(FacebookParam.IN_IFRAME.getSignatureName());
    }

    public boolean inFbCanvas() {
        return this.fbParams.containsKey(FacebookParam.IN_CANVAS.getSignatureName());
    }

    public boolean isAdded() {
        return "1".equals(this.fbParams.get(FacebookParam.ADDED.getSignatureName()));
    }

    public boolean isLogin() {
        return this.getUser() != null;
    }

    public Long get_loggedin_user() {
        return this.getUser();
    }

    public Long getUser() {
        return this.user;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    private String currentUrl() {
        String url = this.request.getScheme() + "://" + this.request.getServerName();
        int port = this.request.getServerPort();
        if (port != 80) {
            url = url + ":" + port;
        }
        url = url + this.request.getRequestURI();
        return url;
    }

    public boolean requireLogin(String next) {
        if (this.getUser() != null) {
            return false;
        }
        this.redirect(this.getLoginUrl(next, this.inFrame()));
        return true;
    }

    public boolean requireAdd(String next) {
        if (this.getUser() != null && this.isAdded()) {
            return false;
        }
        this.redirect(this.getAddUrl(next));
        return true;
    }

    public boolean requireFrame(String next) {
        if (!this.inFrame()) {
            this.redirect(this.getLoginUrl(next, true));
            return true;
        }
        return false;
    }

    public String getLoginUrl(String next, boolean canvas) {
        String url = Facebook.getFacebookUrl(null) + "/login.php?v=1.0&api_key=" + this.apiKey;
        try {
            url = url + (next != null ? "&next=" + URLEncoder.encode(next, "UTF-8") : "");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        url = url + (canvas ? "&canvas" : "");
        return url;
    }

    public String getAddUrl(String next) {
        String url = Facebook.getFacebookUrl(null) + "/add.php?api_key=" + this.apiKey;
        try {
            url = url + (next != null ? "&next=" + URLEncoder.encode(next, "UTF-8") : "");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public static String getFacebookUrl(String subDomain) {
        if (subDomain == null || subDomain.equals("")) {
            subDomain = "www";
        }
        return "http://" + subDomain + ".facebook.com";
    }

    public static String generateSig(Map<String, String> params, String secret) {
        TreeSet<String> keys = new TreeSet<String>(params.keySet());
        keys.remove(FacebookParam.SIGNATURE.toString());
        String str = "";
        for (String key : keys) {
            str = str + key + "=" + params.get(key);
        }
        str = str + secret;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("UTF-8"));
            StringBuilder result = new StringBuilder();
            for (byte b : md.digest()) {
                result.append(Integer.toHexString((b & 0xF0) >>> 4));
                result.append(Integer.toHexString(b & 0xF));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verifySignature(Map<String, String> params, String expected_sig) {
        return Facebook.generateSig(params, this.secret).equals(expected_sig);
    }

    private Map<String, String> _getRequestParams() {
        HashMap<String, String> results = new HashMap<String, String>();
        Map map = this.request.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            results.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return results;
    }

    private Map<String, String> _getCookiesParams() {
        HashMap<String, String> results = new HashMap<String, String>();
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                results.put(cookie.getName(), cookie.getValue());
            }
        }
        return results;
    }

    public List<Long> getFriends() {
        return this.apiClient.friendsList;
    }

    public Long getProfileUser() {
        return this.profileUser;
    }

    public boolean isUninstall() {
        return this.uninstall;
    }

    public Long getProfileUpdateTime() {
        return this.profileUpdateTime;
    }

    public String getProfileSessionKey() {
        return this.profileSessionKey;
    }

    public Long getPageId() {
        return this.pageId;
    }

    public boolean isPageAdded() {
        return this.pageAdded;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isInProfileTab() {
        return this.inProfileTab;
    }

    public boolean isInCanvas() {
        return this.inCanvas;
    }

    public Long getCanvasUser() {
        return this.canvasUser;
    }
}

