/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MassApi;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.message.NotifyMessage;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.MpNews;
import com.foxinmy.weixin4j.tuple.NotifyTuple;
import com.foxinmy.weixin4j.util.StringUtil;
import java.util.List;

public class NotifyApi
extends MpApi {
    private final TokenManager tokenManager;
    private final MassApi massApi;

    public NotifyApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
        this.massApi = new MassApi(tokenManager);
    }

    public ApiResult sendNotify(NotifyMessage notify) throws WeixinException {
        return this.sendNotify(notify, null);
    }

    public ApiResult sendNotify(NotifyMessage notify, String kfAccount) throws WeixinException {
        NotifyTuple tuple = notify.getTuple();
        if (tuple instanceof MpNews) {
            MpNews _news = (MpNews)tuple;
            List _articles = _news.getArticles();
            if (StringUtil.isBlank((CharSequence)_news.getMediaId())) {
                if (_articles.isEmpty()) {
                    throw new WeixinException("notify fail:mediaId or articles is required");
                }
                tuple = new MpNews(this.massApi.uploadArticle(_articles));
            }
        }
        String msgtype = tuple.getMessageType();
        JSONObject obj = new JSONObject();
        obj.put("touser", (Object)notify.getTouser());
        obj.put("msgtype", (Object)msgtype);
        obj.put(msgtype, (Object)tuple);
        if (StringUtil.isNotBlank((CharSequence)kfAccount)) {
            JSONObject kf = new JSONObject();
            kf.put("kf_account", (Object)kfAccount);
            obj.put("customservice", (Object)kf);
        }
        String custom_notify_uri = this.getRequestUri("custom_notify_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(custom_notify_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }
}

