/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.WeixinAccount;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.model.OauthToken;
import com.foxinmy.weixin4j.mp.model.User;
import com.foxinmy.weixin4j.mp.type.Lang;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OauthApi
extends MpApi {
    private final WeixinAccount account;

    public OauthApi() {
        this(Weixin4jConfigUtil.getWeixinAccount());
    }

    public OauthApi(WeixinAccount account) {
        this.account = account;
    }

    public String getUserAuthorizationURL() {
        String redirectUri = Weixin4jConfigUtil.getValue((String)"user.oauth.redirect.uri");
        return this.getUserAuthorizationURL(redirectUri, "state", "snsapi_base");
    }

    public String getUserAuthorizationURL(String redirectUri, String state, String scope) {
        String sns_user_auth_uri = this.getRequestUri("sns_user_auth_uri");
        try {
            return String.format(sns_user_auth_uri, this.account.getId(), URLEncoder.encode(redirectUri, Consts.UTF_8.name()), scope, state);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public OauthToken getAuthorizationToken(String code) throws WeixinException {
        String user_token_uri = this.getRequestUri("sns_user_token_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(user_token_uri, this.account.getId(), this.account.getSecret(), code), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        OauthToken token = new OauthToken(result.getString("access_token"), result.getLongValue("expires_in") * 1000L);
        token.setUnionId(result.getString("unionid"));
        token.setOpenId(result.getString("openid"));
        token.setScope(result.getString("scope"));
        token.setRefreshToken(result.getString("refresh_token"));
        return token;
    }

    public OauthToken refreshAuthorizationToken(String refreshToken) throws WeixinException {
        String sns_token_refresh_uri = this.getRequestUri("sns_token_refresh_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(sns_token_refresh_uri, this.account.getId(), refreshToken), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        OauthToken token = new OauthToken(result.getString("access_token"), result.getLongValue("expires_in") * 1000L);
        token.setUnionId(result.getString("unionid"));
        token.setOpenId(result.getString("openid"));
        token.setScope(result.getString("scope"));
        token.setRefreshToken(result.getString("refresh_token"));
        return token;
    }

    public boolean verifyAuthorizationToken(String oauthToken, String openId) {
        String sns_auth_token_uri = this.getRequestUri("sns_auth_token_uri");
        try {
            this.weixinExecutor.get(String.format(sns_auth_token_uri, oauthToken, openId), new URLParameter[0]);
            return true;
        }
        catch (WeixinException e) {
            return false;
        }
    }

    public User getAuthorizationUser(OauthToken token) throws WeixinException {
        return this.getAuthorizationUser(token.getAccessToken(), token.getOpenId(), Lang.zh_CN);
    }

    public User getAuthorizationUser(String oauthToken, String openid, Lang lang) throws WeixinException {
        String user_info_uri = this.getRequestUri("sns_user_info_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(user_info_uri, oauthToken, openid, lang.name()), new URLParameter[0]);
        return (User)response.getAsObject((TypeReference)new TypeReference<User>(){});
    }

    public String getOpenAuthorizationURL() {
        String redirectUri = Weixin4jConfigUtil.getValue((String)"open.user.oauth.redirect.uri");
        return this.getOpenAuthorizationURL(redirectUri, "state");
    }

    public String getOpenAuthorizationURL(String redirectUri, String state) {
        String open_user_auth_uri = this.getRequestUri("open_user_auth_uri");
        try {
            return String.format(open_user_auth_uri, this.account.getId(), URLEncoder.encode(redirectUri, Consts.UTF_8.name()), "snsapi_login", state);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

