/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.message;

import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.util.NameValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TemplateMessage
implements Serializable {
    private static final long serialVersionUID = 7950608393821661436L;
    @JSONField(name="touser")
    private String toUser;
    @JSONField(name="template_id")
    private String templateId;
    private String url;
    @JSONField(serialize=false)
    private NameValue head;
    @JSONField(serialize=false)
    private NameValue tail;
    @JSONField(name="data")
    private Map<String, NameValue> content;
    private static final String HEAD_KEY = "first";
    private static final String TAIL_KEY = "remark";
    private static final String DEFAULT_COLOR = "#173177";

    @JSONCreator
    public TemplateMessage(@JSONField(name="toUser") String toUser, @JSONField(name="templateId") String templateId, @JSONField(name="url") String url) {
        this.toUser = toUser;
        this.templateId = templateId;
        this.url = url;
        this.content = new HashMap<String, NameValue>();
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getUrl() {
        return this.url;
    }

    public NameValue getHead() {
        return this.head == null ? this.content.get(HEAD_KEY) : this.head;
    }

    public NameValue getTail() {
        return this.tail == null ? this.content.get(TAIL_KEY) : this.tail;
    }

    public Map<String, NameValue> getContent() {
        return this.content;
    }

    public TemplateMessage pushHead(String text) {
        return this.pushHead("#FF0000", text);
    }

    public TemplateMessage pushHead(String color, String text) {
        this.head = new NameValue(color, text);
        this.content.put(HEAD_KEY, this.head);
        return this;
    }

    public TemplateMessage pushTail(String text) {
        return this.pushTail(DEFAULT_COLOR, text);
    }

    public TemplateMessage pushTail(String color, String text) {
        this.tail = new NameValue(color, text);
        this.content.put(TAIL_KEY, this.tail);
        return this;
    }

    public TemplateMessage pushItem(String key, String text) {
        return this.pushItem(key, DEFAULT_COLOR, text);
    }

    public TemplateMessage pushItem(String key, String color, String text) {
        this.content.put(key, new NameValue(color, text));
        return this;
    }

    public void setItems(Map<String, NameValue> items) {
        this.content = items;
    }

    public String toString() {
        return "TemplateMessage [toUser=" + this.toUser + ", templateId=" + this.templateId + ", url=" + this.url + ", head=" + this.getHead() + ", tail=" + this.getTail() + ", content=" + this.content + "]";
    }
}

