/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public final class AuthorizerOption
implements Serializable {
    private static final long serialVersionUID = -3124882411789627403L;
    private AuthorizerOptionName name;
    private int value;
    private List<Integer> options;

    private AuthorizerOption(AuthorizerOptionName name, int value, Integer ... options) {
        this.name = name;
        this.value = value;
        this.options = Arrays.asList(options);
    }

    public static AuthorizerOption createLocationReportOption(int value) {
        return new AuthorizerOption(AuthorizerOptionName.location_report, value, 0, 1, 2);
    }

    public static AuthorizerOption createVoiceRecognizeOption(int value) {
        return new AuthorizerOption(AuthorizerOptionName.voice_recognize, value, 0, 1);
    }

    public static AuthorizerOption createCustomerServiceOption(int value) {
        return new AuthorizerOption(AuthorizerOptionName.customer_service, value, 0, 1);
    }

    public static AuthorizerOption parse(AuthorizerOptionName optionName, int optionValue) {
        if (optionName == AuthorizerOptionName.customer_service) {
            return AuthorizerOption.createCustomerServiceOption(optionValue);
        }
        if (optionName == AuthorizerOptionName.location_report) {
            return AuthorizerOption.createLocationReportOption(optionValue);
        }
        if (optionName == AuthorizerOptionName.voice_recognize) {
            return AuthorizerOption.createVoiceRecognizeOption(optionValue);
        }
        throw new IllegalArgumentException("unkown option:" + (Object)((Object)optionName));
    }

    public AuthorizerOptionName getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public List<Integer> getOptions() {
        return this.options;
    }

    public String toString() {
        return "AuthorizerOption [name=" + (Object)((Object)this.name) + ", value=" + this.value + ", options=" + this.options + "]";
    }

    public static enum AuthorizerOptionName {
        location_report,
        voice_recognize,
        customer_service;

    }
}

