/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.oldpayment;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.PayPackage;
import com.foxinmy.weixin4j.util.DateUtil;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PayPackageV2
extends PayPackage {
    private static final long serialVersionUID = 5557542103637795834L;
    @XmlElement(name="bank_type")
    @JSONField(name="bank_type")
    private String bankType;
    private String partner;
    @XmlElement(name="fee_type")
    @JSONField(name="fee_type")
    private String feeType;
    @XmlElement(name="transport_fee")
    @JSONField(name="transport_fee")
    private Integer transportFee;
    @XmlElement(name="product_fee")
    @JSONField(name="product_fee")
    private Integer productFee;
    @XmlElement(name="input_charset")
    @JSONField(name="input_charset")
    private String inputCharset;

    protected PayPackageV2() {
    }

    public PayPackageV2(String partner, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp) {
        this(partner, body, outTradeNo, totalFee, notifyUrl, createIp, null, null, null, 0.0, 0.0, null);
    }

    public PayPackageV2(String partner, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach, Date timeStart, Date timeExpire, double transportFee, double productFee, String goodsTag) {
        this.setBody(body);
        this.setOutTradeNo(outTradeNo);
        this.setTotalFee(totalFee);
        this.setNotifyUrl(notifyUrl);
        this.setCreateIp(createIp);
        this.setAttach(attach);
        this.setTimeStart(timeStart);
        this.setTimeExpire(timeExpire);
        this.setGoodsTag(goodsTag);
        this.bankType = "WX";
        this.feeType = "1";
        this.inputCharset = "UTF-8";
        this.partner = partner;
        this.transportFee = transportFee > 0.0 ? Integer.valueOf(DateUtil.formatYuan2Fen((double)transportFee)) : null;
        this.productFee = productFee > 0.0 ? Integer.valueOf(DateUtil.formatYuan2Fen((double)productFee)) : null;
    }

    public String getBankType() {
        return this.bankType;
    }

    public String getPartner() {
        return this.partner;
    }

    public void setPartner(String partner) {
        this.partner = partner;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public Integer getTransportFee() {
        return this.transportFee;
    }

    @JSONField(serialize=false)
    public double getFormatTransportFee() {
        return this.transportFee != null ? (double)this.transportFee.intValue() / 100.0 : 0.0;
    }

    public void setTransportFee(double transportFee) {
        this.transportFee = DateUtil.formatYuan2Fen((double)transportFee);
    }

    public Integer getProductFee() {
        return this.productFee;
    }

    @JSONField(serialize=false)
    public double getFormatProductFee() {
        return this.productFee != null ? (double)this.productFee.intValue() / 100.0 : 0.0;
    }

    public void setProductFee(double productFee) {
        this.productFee = DateUtil.formatYuan2Fen((double)productFee);
    }

    public String getInputCharset() {
        return this.inputCharset;
    }

    public String toString() {
        return "PayPackageV2 [bankType=" + this.bankType + ", partner=" + this.partner + ", feeType=" + this.feeType + ", transportFee=" + this.transportFee + ", productFee=" + this.productFee + ", inputCharset=" + this.inputCharset + ", " + super.toString() + "]";
    }
}

