/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.paging.Pagedata;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.model.shakearound.Device;
import com.foxinmy.weixin4j.mp.model.shakearound.DeviceAuditState;
import com.foxinmy.weixin4j.mp.model.shakearound.ShakeUserInfo;
import com.foxinmy.weixin4j.token.TokenManager;
import java.util.ArrayList;
import java.util.List;

public class ShakeAroundApi
extends MpApi {
    private final TokenManager tokenManager;

    public ShakeAroundApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public DeviceAuditState deviceApply(Integer quantity, String applyReason, String comment) throws WeixinException {
        String device_apply_uri = this.getRequestUri("shake_around_device_apply");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("quantity", (Object)quantity);
        jsonObject.put("apply_reason", (Object)applyReason);
        jsonObject.put("comment", (Object)comment);
        WeixinResponse response = this.weixinExecutor.post(String.format(device_apply_uri, token.getAccessToken()), jsonObject.toJSONString());
        DeviceAuditState result = (DeviceAuditState)JSON.parseObject((String)response.getAsJson().getString("data"), DeviceAuditState.class);
        result.setApplyTime(System.currentTimeMillis() / 1000L);
        result.setAuditTime(0L);
        return result;
    }

    public DeviceAuditState deviceQueryApplyStatus(int applyId) throws WeixinException {
        String device_apply_status_uri = this.getRequestUri("shake_around_device_apply_status_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("apply_id", (Object)applyId);
        WeixinResponse response = this.weixinExecutor.post(String.format(device_apply_status_uri, token.getAccessToken()), jsonObject.toJSONString());
        DeviceAuditState result = (DeviceAuditState)JSON.parseObject((String)response.getAsJson().getString("data"), DeviceAuditState.class);
        result.setApplyId(applyId);
        return result;
    }

    public List<Device> deviceSearchDevices(List<Device> device) throws WeixinException {
        String device_search_uri = this.getRequestUri("shake_around_device_search_uri");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)1);
        jsonObject.put("device_identifiers", device);
        WeixinResponse response = this.weixinExecutor.post(String.format(device_search_uri, this.tokenManager.getAccessToken()), jsonObject.toJSONString());
        JSONObject json = response.getAsJson();
        String deviceStr = json.getJSONObject("data").getString("devices");
        return JSON.parseArray((String)deviceStr, Device.class);
    }

    public Pagedata<Device> deviceSearchDevices(int pageSize) throws WeixinException {
        return this.deviceSearchDevices(0, pageSize);
    }

    public Pagedata<Device> deviceSearchDevices(int lastDeviceId, int pageSize) throws WeixinException {
        String device_search_uri = this.getRequestUri("shake_around_device_search_uri");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)2);
        jsonObject.put("last_seen", (Object)lastDeviceId);
        if (pageSize > 50) {
            pageSize = 50;
        }
        jsonObject.put("count", (Object)pageSize);
        WeixinResponse response = this.weixinExecutor.post(String.format(device_search_uri, this.tokenManager.getAccessToken()), jsonObject.toJSONString());
        JSONObject json = response.getAsJson();
        JSONObject data = json.getJSONObject("data");
        String deviceStr = data.getString("devices");
        List devices = JSON.parseArray((String)deviceStr, Device.class);
        Pagedata pagedata = new Pagedata(null, data.getIntValue("total_count"), devices);
        return pagedata;
    }

    public List<Device> deviceSearchDevicesByApplyId(Integer applyId) throws WeixinException {
        ArrayList<Device> devices = new ArrayList();
        Pagedata<Device> pagedata = this.deviceSearchDevicesByApplyId(applyId, 50);
        devices = pagedata.getContent();
        for (int page = 50; page < pagedata.getTotalElements(); page += 50) {
            List _devices = pagedata.getContent();
            pagedata = this.deviceSearchDevicesByApplyId(applyId, ((Device)_devices.get(_devices.size() - 1)).getDeviceId(), 50);
            _devices = pagedata.getContent();
            devices.addAll(_devices);
        }
        return devices;
    }

    public Pagedata<Device> deviceSearchDevicesByApplyId(Integer applyId, int pageSize) throws WeixinException {
        return this.deviceSearchDevicesByApplyId(applyId, 0, pageSize);
    }

    public Pagedata<Device> deviceSearchDevicesByApplyId(Integer applyId, int lastDeviceId, int pageSize) throws WeixinException {
        String device_search_uri = this.getRequestUri("shake_around_device_search_uri");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)3);
        jsonObject.put("apply_id", (Object)applyId);
        jsonObject.put("last_seen", (Object)lastDeviceId);
        if (pageSize > 50) {
            pageSize = 50;
        }
        jsonObject.put("count", (Object)pageSize);
        WeixinResponse response = this.weixinExecutor.post(String.format(device_search_uri, this.tokenManager.getAccessToken()), jsonObject.toJSONString());
        JSONObject json = response.getAsJson();
        JSONObject data = json.getJSONObject("data");
        String deviceStr = data.getString("devices");
        List devices = JSON.parseArray((String)deviceStr, Device.class);
        Pagedata pagedata = new Pagedata(null, data.getIntValue("total_count"), devices);
        return pagedata;
    }

    public ApiResult deviceUpdateComment(Device device, String comment) throws WeixinException {
        String device_update_uri = this.getRequestUri("shake_around_device_update_uri");
        JSONObject jsonObject = new JSONObject();
        JSONObject deviceJsonObj = new JSONObject();
        jsonObject.put("device_identifier", (Object)deviceJsonObj);
        jsonObject.put("comment", (Object)comment);
        if (device.getDeviceId() == null) {
            deviceJsonObj.put("uuid", (Object)device.getUuid());
            deviceJsonObj.put("major", (Object)device.getMajor());
            deviceJsonObj.put("minor", (Object)device.getMinor());
        } else {
            deviceJsonObj.put("device_id", (Object)device.getDeviceId());
        }
        WeixinResponse weixinResponse = this.weixinExecutor.post(String.format(device_update_uri, this.tokenManager.getAccessToken()), jsonObject.toJSONString());
        return weixinResponse.getAsResult();
    }

    public ShakeUserInfo getShakeUserInfo(String ticket) throws WeixinException {
        String user_get_shake_info_url = this.getRequestUri("shake_around_user_get_shake_info");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ticket", (Object)ticket);
        WeixinResponse weixinResponse = this.weixinExecutor.post(String.format(user_get_shake_info_url, this.tokenManager.getAccessToken()), jsonObject.toJSONString());
        return (ShakeUserInfo)weixinResponse.getAsJson().getObject("data", ShakeUserInfo.class);
    }
}

