/*
 * Decompiled with CFR 0.152.
 */
package com.freeway.image.combiner.painter;

import com.freeway.image.combiner.element.CombineElement;
import com.freeway.image.combiner.element.RectangleElement;
import com.freeway.image.combiner.painter.IPainter;
import java.awt.AlphaComposite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class RectanglePainter
implements IPainter {
    @Override
    public void draw(Graphics2D g, CombineElement element, int canvasWidth) {
        RectangleElement rectangleElement = (RectangleElement)element;
        g.setColor(rectangleElement.getColor());
        if (rectangleElement.isCenter()) {
            int centerX = (canvasWidth - rectangleElement.getWidth()) / 2;
            rectangleElement.setX(centerX);
        }
        if (rectangleElement.getFromColor() != null) {
            float fromX = 0.0f;
            float fromY = 0.0f;
            float toX = 0.0f;
            float toY = 0.0f;
            switch (rectangleElement.getGradientDirection()) {
                case TopBottom: {
                    fromX = rectangleElement.getX() + rectangleElement.getWidth() / 2;
                    fromY = rectangleElement.getY() - rectangleElement.getFromExtend();
                    toX = fromX;
                    toY = rectangleElement.getY() + rectangleElement.getHeight() + rectangleElement.getToExtend();
                    break;
                }
                case LeftRight: {
                    fromX = rectangleElement.getX() - rectangleElement.getFromExtend();
                    fromY = rectangleElement.getY() + rectangleElement.getHeight() / 2;
                    toX = rectangleElement.getX() + rectangleElement.getWidth() + rectangleElement.getToExtend();
                    toY = fromY;
                    break;
                }
                case LeftTopRightBottom: {
                    fromX = (float)rectangleElement.getX() - (float)Math.sqrt(rectangleElement.getFromExtend().intValue());
                    fromY = (float)rectangleElement.getY() - (float)Math.sqrt(rectangleElement.getFromExtend().intValue());
                    toX = (float)(rectangleElement.getX() + rectangleElement.getWidth()) + (float)Math.sqrt(rectangleElement.getToExtend().intValue());
                    toY = (float)(rectangleElement.getY() + rectangleElement.getHeight()) + (float)Math.sqrt(rectangleElement.getToExtend().intValue());
                    break;
                }
                case RightTopLeftBottom: {
                    fromX = (float)(rectangleElement.getX() + rectangleElement.getWidth()) + (float)Math.sqrt(rectangleElement.getFromExtend().intValue());
                    fromY = (float)rectangleElement.getY() - (float)Math.sqrt(rectangleElement.getFromExtend().intValue());
                    toX = (float)rectangleElement.getX() - (float)Math.sqrt(rectangleElement.getToExtend().intValue());
                    toY = (float)(rectangleElement.getY() + rectangleElement.getHeight()) + (float)Math.sqrt(rectangleElement.getToExtend().intValue());
                }
            }
            g.setPaint(new GradientPaint(fromX, fromY, rectangleElement.getFromColor(), toX, toY, rectangleElement.getToColor()));
        } else {
            g.setPaint(null);
        }
        g.setComposite(AlphaComposite.getInstance(3, rectangleElement.getAlpha()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(rectangleElement.getX(), rectangleElement.getY(), rectangleElement.getWidth(), rectangleElement.getHeight(), rectangleElement.getRoundCorner(), rectangleElement.getRoundCorner());
    }
}

