/*
 * Decompiled with CFR 0.152.
 */
package com.geirsson.junit;

import com.geirsson.junit.CustomRunners;
import com.geirsson.junit.JUnitRunnerWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.runner.Computer;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class JUnitComputer
extends Computer {
    final Map<Class<?>, Class<?>> suiteRunners = new HashMap();

    public JUnitComputer(ClassLoader classLoader, CustomRunners customRunners) {
        customRunners.all().forEach((string, string2) -> {
            try {
                this.suiteRunners.put(classLoader.loadClass((String)string), classLoader.loadClass((String)string2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        });
    }

    public Optional<Class<?>> customRunner(Class<?> clazz) {
        for (Map.Entry<Class<?>, Class<?>> entry : this.suiteRunners.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Runner getSuite(final RunnerBuilder runnerBuilder, Class<?>[] classArray) throws InitializationError {
        RunnerBuilder runnerBuilder2 = new RunnerBuilder(){

            public Runner runnerForClass(Class<?> clazz) throws Throwable {
                return JUnitComputer.this.getRunner(runnerBuilder, clazz);
            }
        };
        return new MySuite(runnerBuilder2, classArray);
    }

    protected Runner getRunner(RunnerBuilder runnerBuilder, Class<?> clazz) throws Throwable {
        Optional<Class<?>> optional = this.customRunner(clazz);
        if (optional.isPresent()) {
            Runner runner = (Runner)optional.get().getConstructor(Class.class).newInstance(clazz);
            return new JUnitRunnerWrapper(runner);
        }
        return super.getRunner(runnerBuilder, clazz);
    }

    private class MySuite
    extends Suite
    implements Filterable {
        public MySuite(RunnerBuilder runnerBuilder, Class<?>[] classArray) throws InitializationError {
            super(runnerBuilder, (Class[])classArray);
        }

        public void filter(Filter filter) throws NoTestsRemainException {
            for (Runner runner : super.getChildren()) {
                filter.apply((Object)runner);
            }
        }
    }
}

