/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.log4j2;

import com.getsentry.raven.Raven;
import com.getsentry.raven.RavenFactory;
import com.getsentry.raven.config.Lookup;
import com.getsentry.raven.dsn.Dsn;
import com.getsentry.raven.dsn.InvalidDsnException;
import com.getsentry.raven.environment.RavenEnvironment;
import com.getsentry.raven.event.Event;
import com.getsentry.raven.event.EventBuilder;
import com.getsentry.raven.event.interfaces.ExceptionInterface;
import com.getsentry.raven.event.interfaces.MessageInterface;
import com.getsentry.raven.event.interfaces.SentryInterface;
import com.getsentry.raven.event.interfaces.StackTraceInterface;
import com.getsentry.raven.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="Raven", category="Core", elementType="appender", printObject=true)
public class SentryAppender
extends AbstractAppender {
    public static final String APPENDER_NAME = "raven";
    public static final String LOG4J_NDC = "log4j2-NDC";
    public static final String LOG4J_MARKER = "log4j2-Marker";
    public static final String THREAD_NAME = "Raven-Threadname";
    protected volatile Raven raven;
    protected String dsn;
    protected String ravenFactory;
    protected String release;
    protected String environment;
    protected String serverName;
    protected Map<String, String> tags = Collections.emptyMap();
    protected Set<String> extraTags = Collections.emptySet();

    public SentryAppender() {
        this(APPENDER_NAME, null);
    }

    public SentryAppender(Raven raven) {
        this();
        this.raven = raven;
    }

    protected SentryAppender(String name, Filter filter) {
        super(name, filter, null, true);
        this.setRavenFactory(Lookup.lookup((String)"ravenFactory"));
        this.setRelease(Lookup.lookup((String)"release"));
        this.setEnvironment(Lookup.lookup((String)"environment"));
        this.setServerName(Lookup.lookup((String)"serverName"));
        this.setTags(Lookup.lookup((String)"tags"));
        this.setExtraTags(Lookup.lookup((String)"extraTags"));
        this.addFilter((Filter)new DropRavenFilter());
    }

    @PluginFactory
    public static SentryAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="dsn") String dsn, @PluginAttribute(value="ravenFactory") String ravenFactory, @PluginAttribute(value="release") String release, @PluginAttribute(value="environment") String environment, @PluginAttribute(value="serverName") String serverName, @PluginAttribute(value="tags") String tags, @PluginAttribute(value="extraTags") String extraTags, @PluginElement(value="filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for SentryAppender");
            return null;
        }
        SentryAppender sentryAppender = new SentryAppender(name, filter);
        sentryAppender.setDsn(dsn);
        if (release != null) {
            sentryAppender.setRelease(release);
        }
        if (environment != null) {
            sentryAppender.setEnvironment(environment);
        }
        if (serverName != null) {
            sentryAppender.setServerName(serverName);
        }
        if (tags != null) {
            sentryAppender.setTags(tags);
        }
        if (extraTags != null) {
            sentryAppender.setExtraTags(extraTags);
        }
        sentryAppender.setRavenFactory(ravenFactory);
        return sentryAppender;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isMoreSpecificThan(Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            return Event.Level.INFO;
        }
        return Event.Level.DEBUG;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> stringParameters = new ArrayList<String>(parameters.length);
        for (Object parameter : parameters) {
            stringParameters.add(parameter != null ? parameter.toString() : null);
        }
        return stringParameters;
    }

    public void append(LogEvent logEvent) {
        if (RavenEnvironment.isManagingThread()) {
            return;
        }
        RavenEnvironment.startManagingThread();
        try {
            if (this.raven == null) {
                this.initRaven();
            }
            Event event = this.buildEvent(logEvent);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.error("An exception occurred while creating a new event in Raven", logEvent, e);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    protected synchronized void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.error("An exception occurred during the retrieval of the DSN for Raven", e);
        }
        catch (Exception e) {
            this.error("An exception occurred during the creation of a Raven instance", e);
        }
    }

    protected Event buildEvent(LogEvent event) {
        Throwable throwable;
        Message eventMessage = event.getMessage();
        EventBuilder eventBuilder = new EventBuilder().withSdkName("raven-java:log4j2").withTimestamp(new Date(event.getTimeMillis())).withMessage(eventMessage.getFormattedMessage()).withLogger(event.getLoggerName()).withLevel(SentryAppender.formatLevel(event.getLevel())).withExtra(THREAD_NAME, (Object)event.getThreadName());
        if (!Util.isNullOrEmpty((String)this.serverName)) {
            eventBuilder.withServerName(this.serverName.trim());
        }
        if (!Util.isNullOrEmpty((String)this.release)) {
            eventBuilder.withRelease(this.release.trim());
        }
        if (!Util.isNullOrEmpty((String)this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        if (!eventMessage.getFormattedMessage().equals(eventMessage.getFormat())) {
            eventBuilder.withSentryInterface((SentryInterface)new MessageInterface(eventMessage.getFormat(), SentryAppender.formatMessageParameters(eventMessage.getParameters()), eventMessage.getFormattedMessage()));
        }
        if ((throwable = event.getThrown()) != null) {
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (event.getSource() != null) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{event.getSource()};
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(stackTrace));
        }
        if (event.getSource() != null) {
            eventBuilder.withCulprit(event.getSource());
        } else {
            eventBuilder.withCulprit(event.getLoggerName());
        }
        if (event.getContextStack() != null) {
            eventBuilder.withExtra(LOG4J_NDC, (Object)event.getContextStack().asList());
        }
        if (event.getContextMap() != null) {
            for (Map.Entry<Object, Object> entry : event.getContextMap().entrySet()) {
                if (this.extraTags.contains(entry.getKey())) {
                    eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                eventBuilder.withExtra((String)entry.getKey(), entry.getValue());
            }
        }
        if (event.getMarker() != null) {
            eventBuilder.withTag(LOG4J_MARKER, event.getMarker().getName());
        }
        for (Map.Entry<Object, Object> entry : this.tags.entrySet()) {
            eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setTags(String tags) {
        this.tags = Util.parseTags((String)tags);
    }

    public void setExtraTags(String extraTags) {
        this.extraTags = Util.parseExtraTags((String)extraTags);
    }

    public void stop() {
        RavenEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            if (this.raven != null) {
                this.raven.closeConnection();
            }
        }
        catch (Exception e) {
            this.error("An exception occurred while closing the Raven connection", e);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    private class DropRavenFilter
    extends AbstractFilter {
        private DropRavenFilter() {
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(LogEvent event) {
            return this.filter(event.getLoggerName());
        }

        private Filter.Result filter(String loggerName) {
            if (loggerName != null && loggerName.startsWith("com.getsentry.raven")) {
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }
    }
}

