/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.IdentityHashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.SerializableTypeWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ResolvableType
implements Serializable {
    public static final ResolvableType NONE = new ResolvableType(EmptyType.INSTANCE, null, null, 0);
    private static final ResolvableType[] EMPTY_TYPES_ARRAY = new ResolvableType[0];
    private static final ConcurrentReferenceHashMap<ResolvableType, ResolvableType> cache = new ConcurrentReferenceHashMap(256);
    private final Type type;
    @Nullable
    private final SerializableTypeWrapper.TypeProvider typeProvider;
    @Nullable
    private final VariableResolver variableResolver;
    @Nullable
    private final ResolvableType componentType;
    @Nullable
    private final Integer hash;
    @Nullable
    private Class<?> resolved;
    @Nullable
    private volatile ResolvableType superType;
    @Nullable
    private volatile ResolvableType[] interfaces;
    @Nullable
    private volatile ResolvableType[] generics;

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.hash = this.calculateHashCode();
        this.resolved = null;
    }

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver, @Nullable Integer hash) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.hash = hash;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver, @Nullable ResolvableType componentType) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = componentType;
        this.hash = null;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(@Nullable Class<?> clazz) {
        this.type = this.resolved = clazz != null ? clazz : Object.class;
        this.typeProvider = null;
        this.variableResolver = null;
        this.componentType = null;
        this.hash = null;
    }

    public Type getType() {
        return SerializableTypeWrapper.unwrap(this.type);
    }

    @Nullable
    public Class<?> getRawClass() {
        if (this.type == this.resolved) {
            return this.resolved;
        }
        Type rawType = this.type;
        if (rawType instanceof ParameterizedType) {
            rawType = ((ParameterizedType)rawType).getRawType();
        }
        return rawType instanceof Class ? (Class)rawType : null;
    }

    public Object getSource() {
        Object source = this.typeProvider != null ? this.typeProvider.getSource() : null;
        return source != null ? source : this.type;
    }

    public boolean isAssignableFrom(ResolvableType other) {
        return this.isAssignableFrom(other, null);
    }

    private boolean isAssignableFrom(ResolvableType other, @Nullable Map<Type, Type> matchedBefore) {
        Assert.notNull((Object)other, "ResolvableType must not be null");
        if (this == NONE || other == NONE) {
            return false;
        }
        if (this.isArray()) {
            return other.isArray() && this.getComponentType().isAssignableFrom(other.getComponentType());
        }
        if (matchedBefore != null && matchedBefore.get(this.type) == other.type) {
            return true;
        }
        WildcardBounds ourBounds = WildcardBounds.get(this);
        WildcardBounds typeBounds = WildcardBounds.get(other);
        if (typeBounds != null) {
            return ourBounds != null && ourBounds.isSameKind(typeBounds) && ourBounds.isAssignableFrom(typeBounds.getBounds());
        }
        if (ourBounds != null) {
            return ourBounds.isAssignableFrom(other);
        }
        boolean exactMatch = matchedBefore != null;
        boolean checkGenerics = true;
        Class<?> ourResolved = null;
        if (this.type instanceof TypeVariable) {
            ResolvableType resolved;
            TypeVariable variable = (TypeVariable)this.type;
            if (this.variableResolver != null && (resolved = this.variableResolver.resolveVariable(variable)) != null) {
                ourResolved = resolved.resolve();
            }
            if (ourResolved == null && other.variableResolver != null && (resolved = other.variableResolver.resolveVariable(variable)) != null) {
                ourResolved = resolved.resolve();
                checkGenerics = false;
            }
            if (ourResolved == null) {
                exactMatch = false;
            }
        }
        if (ourResolved == null) {
            ourResolved = this.resolve(Object.class);
        }
        Class<?> otherResolved = other.resolve(Object.class);
        if (exactMatch ? !ourResolved.equals(otherResolved) : !ClassUtils.isAssignable(ourResolved, otherResolved)) {
            return false;
        }
        if (checkGenerics) {
            ResolvableType[] typeGenerics;
            ResolvableType[] ourGenerics = this.getGenerics();
            if (ourGenerics.length != (typeGenerics = other.as(ourResolved).getGenerics()).length) {
                return false;
            }
            if (matchedBefore == null) {
                matchedBefore = new IdentityHashMap<Type, Type>(1);
            }
            matchedBefore.put(this.type, other.type);
            for (int i = 0; i < ourGenerics.length; ++i) {
                if (ourGenerics[i].isAssignableFrom(typeGenerics[i], matchedBefore)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isArray() {
        if (this == NONE) {
            return false;
        }
        return this.type instanceof Class && ((Class)this.type).isArray() || this.type instanceof GenericArrayType || this.resolveType().isArray();
    }

    public ResolvableType getComponentType() {
        if (this == NONE) {
            return NONE;
        }
        if (this.componentType != null) {
            return this.componentType;
        }
        if (this.type instanceof Class) {
            Class<?> componentType = ((Class)this.type).getComponentType();
            return ResolvableType.forType(componentType, this.variableResolver);
        }
        if (this.type instanceof GenericArrayType) {
            return ResolvableType.forType(((GenericArrayType)this.type).getGenericComponentType(), this.variableResolver);
        }
        return this.resolveType().getComponentType();
    }

    public ResolvableType as(Class<?> type) {
        if (this == NONE) {
            return NONE;
        }
        if (ObjectUtils.nullSafeEquals(this.resolve(), type)) {
            return this;
        }
        for (ResolvableType interfaceType : this.getInterfaces()) {
            ResolvableType interfaceAsType = interfaceType.as(type);
            if (interfaceAsType == NONE) continue;
            return interfaceAsType;
        }
        return this.getSuperType().as(type);
    }

    public ResolvableType getSuperType() {
        Class<?> resolved = this.resolve();
        if (resolved == null || resolved.getGenericSuperclass() == null) {
            return NONE;
        }
        ResolvableType superType = this.superType;
        if (superType == null) {
            this.superType = superType = ResolvableType.forType(SerializableTypeWrapper.forGenericSuperclass(resolved), this.asVariableResolver());
        }
        return superType;
    }

    public ResolvableType[] getInterfaces() {
        Class<?> resolved = this.resolve();
        if (resolved == null || ObjectUtils.isEmpty(resolved.getGenericInterfaces())) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] interfaces = this.interfaces;
        if (interfaces == null) {
            interfaces = ResolvableType.forTypes(SerializableTypeWrapper.forGenericInterfaces(resolved), this.asVariableResolver());
            this.interfaces = interfaces;
        }
        return interfaces;
    }

    public boolean hasGenerics() {
        return this.getGenerics().length > 0;
    }

    public ResolvableType getNested(int nestingLevel, @Nullable Map<Integer, Integer> typeIndexesPerLevel) {
        ResolvableType result = this;
        for (int i = 2; i <= nestingLevel; ++i) {
            if (result.isArray()) {
                result = result.getComponentType();
                continue;
            }
            while (result != NONE && !result.hasGenerics()) {
                result = result.getSuperType();
            }
            Integer index = typeIndexesPerLevel != null ? typeIndexesPerLevel.get(i) : null;
            index = index == null ? result.getGenerics().length - 1 : index;
            result = result.getGeneric(index);
        }
        return result;
    }

    public ResolvableType getGeneric(int ... indexes) {
        ResolvableType[] generics = this.getGenerics();
        if (indexes == null || indexes.length == 0) {
            return generics.length == 0 ? NONE : generics[0];
        }
        ResolvableType generic = this;
        for (int index : indexes) {
            generics = generic.getGenerics();
            if (index < 0 || index >= generics.length) {
                return NONE;
            }
            generic = generics[index];
        }
        return generic;
    }

    public ResolvableType[] getGenerics() {
        if (this == NONE) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] generics = this.generics;
        if (generics == null) {
            if (this.type instanceof Class) {
                Class typeClass = (Class)this.type;
                generics = ResolvableType.forTypes(SerializableTypeWrapper.forTypeParameters(typeClass), this.variableResolver);
            } else if (this.type instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)this.type).getActualTypeArguments();
                generics = new ResolvableType[actualTypeArguments.length];
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    generics[i] = ResolvableType.forType(actualTypeArguments[i], this.variableResolver);
                }
            } else {
                generics = this.resolveType().getGenerics();
            }
            this.generics = generics;
        }
        return generics;
    }

    @Nullable
    public Class<?> resolve() {
        return this.resolved;
    }

    public Class<?> resolve(Class<?> fallback) {
        return this.resolved != null ? this.resolved : fallback;
    }

    @Nullable
    private Class<?> resolveClass() {
        if (this.type == EmptyType.INSTANCE) {
            return null;
        }
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof GenericArrayType) {
            Class<?> resolvedComponent = this.getComponentType().resolve();
            return resolvedComponent != null ? Array.newInstance(resolvedComponent, 0).getClass() : null;
        }
        return this.resolveType().resolve();
    }

    ResolvableType resolveType() {
        if (this.type instanceof ParameterizedType) {
            return ResolvableType.forType(((ParameterizedType)this.type).getRawType(), this.variableResolver);
        }
        if (this.type instanceof WildcardType) {
            Type resolved = this.resolveBounds(((WildcardType)this.type).getUpperBounds());
            if (resolved == null) {
                resolved = this.resolveBounds(((WildcardType)this.type).getLowerBounds());
            }
            return ResolvableType.forType(resolved, this.variableResolver);
        }
        if (this.type instanceof TypeVariable) {
            ResolvableType resolved;
            TypeVariable variable = (TypeVariable)this.type;
            if (this.variableResolver != null && (resolved = this.variableResolver.resolveVariable(variable)) != null) {
                return resolved;
            }
            return ResolvableType.forType(this.resolveBounds(variable.getBounds()), this.variableResolver);
        }
        return NONE;
    }

    @Nullable
    private Type resolveBounds(Type[] bounds) {
        if (ObjectUtils.isEmpty(bounds) || Object.class == bounds[0]) {
            return null;
        }
        return bounds[0];
    }

    @Nullable
    private ResolvableType resolveVariable(TypeVariable<?> variable) {
        if (this.type instanceof TypeVariable) {
            return this.resolveType().resolveVariable(variable);
        }
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.type;
            Class<?> resolved = this.resolve();
            if (resolved == null) {
                return null;
            }
            TypeVariable<Class<?>>[] variables = resolved.getTypeParameters();
            for (int i = 0; i < variables.length; ++i) {
                if (!ObjectUtils.nullSafeEquals(variables[i].getName(), variable.getName())) continue;
                Type actualType = parameterizedType.getActualTypeArguments()[i];
                return ResolvableType.forType(actualType, this.variableResolver);
            }
            Type ownerType = parameterizedType.getOwnerType();
            if (ownerType != null) {
                return ResolvableType.forType(ownerType, this.variableResolver).resolveVariable(variable);
            }
        }
        if (this.variableResolver != null) {
            return this.variableResolver.resolveVariable(variable);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvableType)) {
            return false;
        }
        ResolvableType otherType = (ResolvableType)other;
        if (!ObjectUtils.nullSafeEquals(this.type, otherType.type)) {
            return false;
        }
        if (!(this.typeProvider == otherType.typeProvider || this.typeProvider != null && otherType.typeProvider != null && ObjectUtils.nullSafeEquals(this.typeProvider.getType(), otherType.typeProvider.getType()))) {
            return false;
        }
        if (!(this.variableResolver == otherType.variableResolver || this.variableResolver != null && otherType.variableResolver != null && ObjectUtils.nullSafeEquals(this.variableResolver.getSource(), otherType.variableResolver.getSource()))) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.componentType, otherType.componentType);
    }

    public int hashCode() {
        return this.hash != null ? this.hash.intValue() : this.calculateHashCode();
    }

    private int calculateHashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.type);
        if (this.typeProvider != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.typeProvider.getType());
        }
        if (this.variableResolver != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.variableResolver.getSource());
        }
        if (this.componentType != null) {
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.componentType);
        }
        return hashCode;
    }

    @Nullable
    VariableResolver asVariableResolver() {
        if (this == NONE) {
            return null;
        }
        return new DefaultVariableResolver();
    }

    private Object readResolve() {
        return this.type == EmptyType.INSTANCE ? NONE : this;
    }

    public String toString() {
        if (this.isArray()) {
            return this.getComponentType() + "[]";
        }
        if (this.resolved == null) {
            return "?";
        }
        if (this.type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)this.type;
            if (this.variableResolver == null || this.variableResolver.resolveVariable(variable) == null) {
                return "?";
            }
        }
        StringBuilder result = new StringBuilder(this.resolved.getName());
        if (this.hasGenerics()) {
            result.append('<');
            result.append(StringUtils.arrayToDelimitedString(this.getGenerics(), ", "));
            result.append('>');
        }
        return result.toString();
    }

    public static ResolvableType forMethodParameter(Method method, int parameterIndex, Class<?> implementationClass) {
        Assert.notNull((Object)method, "Method must not be null");
        MethodParameter methodParameter = new MethodParameter(method, parameterIndex);
        methodParameter.setContainingClass(implementationClass);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter) {
        return ResolvableType.forMethodParameter(methodParameter, null);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable Type targetType) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        ResolvableType owner = ResolvableType.forType(methodParameter.getContainingClass()).as(methodParameter.getDeclaringClass());
        return ResolvableType.forType(targetType, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), owner.asVariableResolver()).getNested(methodParameter.getNestingLevel(), methodParameter.typeIndexesPerLevel);
    }

    private static ResolvableType[] forTypes(Type[] types, @Nullable VariableResolver owner) {
        ResolvableType[] result = new ResolvableType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = ResolvableType.forType(types[i], owner);
        }
        return result;
    }

    public static ResolvableType forType(@Nullable Type type) {
        return ResolvableType.forType(type, null, null);
    }

    static ResolvableType forType(@Nullable Type type, @Nullable VariableResolver variableResolver) {
        return ResolvableType.forType(type, null, variableResolver);
    }

    static ResolvableType forType(@Nullable Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        if (type == null && typeProvider != null) {
            type = SerializableTypeWrapper.forTypeProvider(typeProvider);
        }
        if (type == null) {
            return NONE;
        }
        if (type instanceof Class) {
            return new ResolvableType(type, typeProvider, variableResolver, (ResolvableType)null);
        }
        cache.purgeUnreferencedEntries();
        ResolvableType resultType = new ResolvableType(type, typeProvider, variableResolver);
        ResolvableType cachedType = cache.get(resultType);
        if (cachedType == null) {
            cachedType = new ResolvableType(type, typeProvider, variableResolver, resultType.hash);
            cache.put(cachedType, cachedType);
        }
        resultType.resolved = cachedType.resolved;
        return resultType;
    }

    static class EmptyType
    implements Type,
    Serializable {
        static final Type INSTANCE = new EmptyType();

        EmptyType() {
        }

        Object readResolve() {
            return INSTANCE;
        }
    }

    private static class WildcardBounds {
        private final Kind kind;
        private final ResolvableType[] bounds;

        public WildcardBounds(Kind kind, ResolvableType[] bounds) {
            this.kind = kind;
            this.bounds = bounds;
        }

        public boolean isSameKind(WildcardBounds bounds) {
            return this.kind == bounds.kind;
        }

        public boolean isAssignableFrom(ResolvableType ... types) {
            for (ResolvableType bound : this.bounds) {
                for (ResolvableType type : types) {
                    if (this.isAssignable(bound, type)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isAssignable(ResolvableType source, ResolvableType from) {
            return this.kind == Kind.UPPER ? source.isAssignableFrom(from) : from.isAssignableFrom(source);
        }

        public ResolvableType[] getBounds() {
            return this.bounds;
        }

        @Nullable
        public static WildcardBounds get(ResolvableType type) {
            ResolvableType resolveToWildcard = type;
            while (!(resolveToWildcard.getType() instanceof WildcardType)) {
                if (resolveToWildcard == NONE) {
                    return null;
                }
                resolveToWildcard = resolveToWildcard.resolveType();
            }
            WildcardType wildcardType = (WildcardType)resolveToWildcard.type;
            Kind boundsType = wildcardType.getLowerBounds().length > 0 ? Kind.LOWER : Kind.UPPER;
            Type[] bounds = boundsType == Kind.UPPER ? wildcardType.getUpperBounds() : wildcardType.getLowerBounds();
            ResolvableType[] resolvableBounds = new ResolvableType[bounds.length];
            for (int i = 0; i < bounds.length; ++i) {
                resolvableBounds[i] = ResolvableType.forType(bounds[i], type.variableResolver);
            }
            return new WildcardBounds(boundsType, resolvableBounds);
        }

        static enum Kind {
            UPPER,
            LOWER;

        }
    }

    private class DefaultVariableResolver
    implements VariableResolver {
        private DefaultVariableResolver() {
        }

        @Override
        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            return ResolvableType.this.resolveVariable(variable);
        }

        @Override
        public Object getSource() {
            return ResolvableType.this;
        }
    }

    static interface VariableResolver
    extends Serializable {
        public Object getSource();

        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> var1);
    }
}

