/*
 * Decompiled with CFR 0.152.
 */
package com.github.zkclient;

import com.github.zkclient.exception.ZkException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ZkConnection.class);
    private ZooKeeper _zk = null;
    private final Lock _zookeeperLock = new ReentrantLock();
    private final String _servers;
    private final int _sessionTimeOut;
    private static final Method method;

    public ZkConnection(String zkServers, int sessionTimeOut) {
        this._servers = zkServers;
        this._sessionTimeOut = sessionTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Watcher watcher) {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                throw new IllegalStateException("zk client has already been started");
            }
            try {
                LOG.debug("Creating new ZookKeeper instance to connect to " + this._servers + ".");
                this._zk = new ZooKeeper(this._servers, this._sessionTimeOut, watcher);
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + this._servers, e);
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                LOG.debug("Closing ZooKeeper connected to " + this._servers);
                this._zk.close();
                this._zk = null;
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    public String create(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    public void delete(String path) throws InterruptedException, KeeperException {
        this._zk.delete(path, -1);
    }

    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.exists(path, watch) != null;
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getChildren(path, watch);
    }

    public byte[] readData(String path, Stat stat, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getData(path, watch, stat);
    }

    public List<?> multi(Iterable<?> ops) {
        if (method == null) {
            throw new UnsupportedOperationException("multi operation must use zookeeper 3.4+");
        }
        try {
            return (List)method.invoke((Object)this._zk, ops);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException("ops must be 'org.apache.zookeeper.Op'");
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Stat writeData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this._zk.setData(path, data, version);
    }

    public ZooKeeper.States getZookeeperState() {
        return this._zk != null ? this._zk.getState() : null;
    }

    public long getCreateTime(String path) throws KeeperException, InterruptedException {
        Stat stat = this._zk.exists(path, false);
        if (stat != null) {
            return stat.getCtime();
        }
        return -1L;
    }

    public String getServers() {
        return this._servers;
    }

    public ZooKeeper getZooKeeper() {
        return this._zk;
    }

    static {
        Method[] methods = ZooKeeper.class.getDeclaredMethods();
        Method m = null;
        for (Method method : methods) {
            if (!method.getName().equals("multi")) continue;
            m = method;
            break;
        }
        method = m;
    }
}

