/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Cancellable;
import io.reactivex.internal.disposables.CancellableDisposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;

final class PerhapsCreate<T>
extends Perhaps<T> {
    final MaybeOnSubscribe<T> onCreate;

    PerhapsCreate(MaybeOnSubscribe<T> onCreate) {
        this.onCreate = onCreate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        PerhapsEmitter<T> parent = new PerhapsEmitter<T>(s);
        s.onSubscribe(parent);
        try {
            this.onCreate.subscribe(parent);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            parent.onError(ex);
        }
    }

    static final class PerhapsEmitter<T>
    extends DeferredScalarSubscription<T>
    implements MaybeEmitter<T> {
        private static final long serialVersionUID = -7149477775653368644L;
        final AtomicReference<Disposable> resource = new AtomicReference();

        PerhapsEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        public void onSuccess(T t) {
            Disposable d = this.resource.getAndSet((Disposable)DisposableHelper.DISPOSED);
            if (d != DisposableHelper.DISPOSED) {
                this.complete(t);
                if (d != null) {
                    d.dispose();
                }
            }
        }

        public void onError(Throwable t) {
            Disposable d = this.resource.getAndSet((Disposable)DisposableHelper.DISPOSED);
            if (d != DisposableHelper.DISPOSED) {
                this.actual.onError(t);
                if (d != null) {
                    d.dispose();
                }
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            Disposable d = this.resource.getAndSet((Disposable)DisposableHelper.DISPOSED);
            if (d != DisposableHelper.DISPOSED) {
                this.actual.onComplete();
                if (d != null) {
                    d.dispose();
                }
            }
        }

        public void setDisposable(Disposable s) {
            DisposableHelper.set(this.resource, (Disposable)s);
        }

        public void setCancellable(Cancellable c) {
            this.setDisposable((Disposable)new CancellableDisposable(c));
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.resource.get());
        }
    }
}

