/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloDoFinally<T>
extends Solo<T> {
    final Solo<T> source;
    final Action onFinally;

    SoloDoFinally(Solo<T> source, Action onFinally) {
        this.source = source;
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DoFinallySubscriber<T>(s, this.onFinally));
    }

    static final class DoFinallySubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -2447716698732984984L;
        final Subscriber<? super T> actual;
        final Action onFinally;
        Subscription s;
        QueueSubscription<T> queue;
        int sourceMode;

        DoFinallySubscriber(Subscriber<? super T> actual, Action onFinally) {
            this.actual = actual;
            this.onFinally = onFinally;
        }

        public void cancel() {
            this.s.cancel();
            this.runFinally();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                if (s instanceof QueueSubscription) {
                    this.queue = (QueueSubscription)s;
                }
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
            this.runFinally();
        }

        public void onComplete() {
            this.actual.onComplete();
            this.runFinally();
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    RxJavaPlugins.onError((Throwable)ex);
                }
            }
        }

        public int requestFusion(int mode) {
            QueueSubscription<T> qs = this.queue;
            if (qs != null && (mode & 4) == 0) {
                int m;
                this.sourceMode = m = qs.requestFusion(mode);
                return m;
            }
            return 0;
        }

        public T poll() throws Exception {
            Object v = this.queue.poll();
            if (this.sourceMode == 1 && v == null) {
                this.runFinally();
            }
            return (T)v;
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void clear() {
            this.queue.clear();
        }

        public void request(long n) {
            this.s.request(n);
        }
    }
}

