/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import hu.akarnokd.rxjava2.operators.FlowableIntervalBackpressure;
import hu.akarnokd.rxjava2.operators.FlowableOrderedMerge;
import hu.akarnokd.rxjava2.operators.FlowableRepeatCallable;
import hu.akarnokd.rxjava2.operators.FlowableRepeatScalar;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public final class Flowables {
    private Flowables() {
        throw new IllegalStateException("No instances!");
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(Publisher<T> ... sources) {
        return Flowables.orderedMerge(Functions.naturalOrder(), false, Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(boolean delayErrors, Publisher<T> ... sources) {
        return Flowables.orderedMerge(Functions.naturalOrder(), delayErrors, Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(boolean delayErrors, int prefetch, Publisher<T> ... sources) {
        return Flowables.orderedMerge(Functions.naturalOrder(), delayErrors, prefetch, sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Comparator<? super T> comparator, Publisher<T> ... sources) {
        return Flowables.orderedMerge(comparator, false, Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Comparator<? super T> comparator, boolean delayErrors, Publisher<T> ... sources) {
        return Flowables.orderedMerge(comparator, delayErrors, Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Comparator<? super T> comparator, boolean delayErrors, int prefetch, Publisher<T> ... sources) {
        ObjectHelper.requireNonNull(comparator, (String)"comparator is null");
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaPlugins.onAssembly(new FlowableOrderedMerge<T>(sources, null, comparator, delayErrors, prefetch));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, Comparator<? super T> comparator) {
        return Flowables.orderedMerge(sources, comparator, false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, Comparator<? super T> comparator, boolean delayErrors) {
        return Flowables.orderedMerge(sources, comparator, delayErrors, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, Comparator<? super T> comparator, boolean delayErrors, int prefetch) {
        ObjectHelper.requireNonNull(comparator, (String)"comparator is null");
        ObjectHelper.requireNonNull(sources, (String)"sources is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaPlugins.onAssembly(new FlowableOrderedMerge<T>(null, sources, comparator, delayErrors, prefetch));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources) {
        return Flowables.orderedMerge(sources, Functions.naturalOrder(), false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, boolean delayErrors) {
        return Flowables.orderedMerge(sources, Functions.naturalOrder(), delayErrors, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, boolean delayErrors, int prefetch) {
        return Flowables.orderedMerge(sources, Functions.naturalOrder(), delayErrors, prefetch);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> repeat(T item) {
        ObjectHelper.requireNonNull(item, (String)"item is null");
        return RxJavaPlugins.onAssembly(new FlowableRepeatScalar<T>(item));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> repeatCallable(Callable<T> callable) {
        ObjectHelper.requireNonNull(callable, (String)"callable is null");
        return RxJavaPlugins.onAssembly(new FlowableRepeatCallable<T>(callable));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> intervalBackpressure(long period, TimeUnit unit) {
        return Flowables.intervalBackpressure(period, period, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> intervalBackpressure(long period, TimeUnit unit, Scheduler scheduler) {
        return Flowables.intervalBackpressure(period, period, unit, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> intervalBackpressure(long initialDelay, long period, TimeUnit unit) {
        return Flowables.intervalBackpressure(initialDelay, period, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> intervalBackpressure(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        return RxJavaPlugins.onAssembly((Flowable)new FlowableIntervalBackpressure(initialDelay, period, unit, scheduler));
    }
}

