/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.LongConsumer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelPeek<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Consumer<? super T> onNext;
    final Consumer<? super T> onAfterNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminated;
    final Consumer<? super Subscription> onSubscribe;
    final LongConsumer onRequest;
    final Action onCancel;

    ParallelPeek(ParallelFlowable<T> source, Consumer<? super T> onNext, Consumer<? super T> onAfterNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminated, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        this.source = source;
        this.onNext = (Consumer)ObjectHelper.requireNonNull(onNext, (String)"onNext");
        this.onAfterNext = (Consumer)ObjectHelper.requireNonNull(onAfterNext, (String)"onAfterNext");
        this.onError = (Consumer)ObjectHelper.requireNonNull(onError, (String)"onError");
        this.onComplete = (Action)ObjectHelper.requireNonNull((Object)onComplete, (String)"onComplete");
        this.onAfterTerminated = (Action)ObjectHelper.requireNonNull((Object)onAfterTerminated, (String)"onAfterTerminated");
        this.onSubscribe = (Consumer)ObjectHelper.requireNonNull(onSubscribe, (String)"onSubscribe");
        this.onRequest = (LongConsumer)ObjectHelper.requireNonNull((Object)onRequest, (String)"onRequest");
        this.onCancel = (Action)ObjectHelper.requireNonNull((Object)onCancel, (String)"onCancel");
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new ParallelPeekSubscriber<T>(subscribers[i], this);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelPeekSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final ParallelPeek<T> parent;
        Subscription s;
        boolean done;

        ParallelPeekSubscriber(Subscriber<? super T> actual, ParallelPeek<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            try {
                this.parent.onRequest.accept(n);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
            this.s.request(n);
        }

        public void cancel() {
            try {
                this.parent.onCancel.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                try {
                    this.parent.onSubscribe.accept((Object)s);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    s.cancel();
                    this.actual.onSubscribe((Subscription)EmptySubscription.INSTANCE);
                    this.onError(ex);
                    return;
                }
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            try {
                this.parent.onNext.accept(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.onError(ex);
                return;
            }
            this.actual.onNext(t);
            try {
                this.parent.onAfterNext.accept(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.onError(ex);
                return;
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            try {
                this.parent.onError.accept((Object)t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                t = new CompositeException(new Throwable[]{t, ex});
            }
            this.actual.onError(t);
            try {
                this.parent.onAfterTerminated.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            try {
                this.parent.onComplete.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            this.actual.onComplete();
            try {
                this.parent.onAfterTerminated.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
        }
    }
}

