/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.parallel.ParallelTransformer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelSumDouble<T extends Number>
extends ParallelFlowable<Double>
implements ParallelTransformer<T, Double> {
    final ParallelFlowable<? extends Number> source;

    ParallelSumDouble(ParallelFlowable<? extends Number> source) {
        this.source = source;
    }

    public ParallelFlowable<Double> apply(ParallelFlowable<T> t) {
        return new ParallelSumDouble<T>(t);
    }

    public void subscribe(Subscriber<? super Double>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new SumIntSubscriber(subscribers[i]);
        }
        this.source.subscribe(parents);
    }

    public int parallelism() {
        return this.source.parallelism();
    }

    static final class SumIntSubscriber
    extends DeferredScalarSubscription<Double>
    implements FlowableSubscriber<Number> {
        private static final long serialVersionUID = -1502296701568087162L;
        double sum;
        boolean hasValue;
        Subscription upstream;

        public SumIntSubscriber(Subscriber<? super Double> actual) {
            super(actual);
        }

        public void onNext(Number t) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.sum += t.doubleValue();
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.hasValue) {
                this.complete(this.sum);
            } else {
                this.actual.onComplete();
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

