/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicSoloQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.LongConsumer;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloDoOnLifecycle<T>
extends Solo<T> {
    final Solo<T> source;
    final Consumer<? super T> onNext;
    final Consumer<? super T> onAfterNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminate;
    final Consumer<? super Subscription> onSubscribe;
    final LongConsumer onRequest;
    final Action onCancel;
    boolean done;

    SoloDoOnLifecycle(Solo<T> source, Consumer<? super T> onNext, Consumer<? super T> onAfterNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate, Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        this.source = source;
        this.onNext = onNext;
        this.onAfterNext = onAfterNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onAfterTerminate = onAfterTerminate;
        this.onSubscribe = onSubscribe;
        this.onRequest = onRequest;
        this.onCancel = onCancel;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DoOnSubscriber(s));
    }

    final class DoOnSubscriber
    extends BasicSoloQueueSubscription<T>
    implements Subscriber<T> {
        final Subscriber<? super T> downstream;
        Subscription upstream;
        QueueSubscription<T> queue;
        boolean done;
        int sourceMode;

        DoOnSubscriber(Subscriber<? super T> downstream) {
            this.downstream = downstream;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    this.queue = (QueueSubscription)s;
                }
                try {
                    SoloDoOnLifecycle.this.onSubscribe.accept((Object)s);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    s.cancel();
                    this.downstream.onSubscribe((Subscription)EmptySubscription.INSTANCE);
                    this.onError(ex);
                    return;
                }
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.done) {
                if (this.sourceMode != 0) {
                    this.downstream.onNext(null);
                    return;
                }
                try {
                    SoloDoOnLifecycle.this.onNext.accept(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.upstream.cancel();
                    this.onError(ex);
                    return;
                }
                this.downstream.onNext(t);
                try {
                    SoloDoOnLifecycle.this.onAfterNext.accept(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.upstream.cancel();
                    this.onError(ex);
                    return;
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            try {
                SoloDoOnLifecycle.this.onError.accept((Object)t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                t = new CompositeException(new Throwable[]{t, ex});
            }
            this.downstream.onError(t);
            this.doAfter();
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                try {
                    SoloDoOnLifecycle.this.onComplete.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.downstream.onError(ex);
                    return;
                }
                this.downstream.onComplete();
                this.doAfter();
            }
        }

        void doAfter() {
            try {
                SoloDoOnLifecycle.this.onAfterTerminate.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        public void cancel() {
            try {
                SoloDoOnLifecycle.this.onCancel.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
            this.upstream.cancel();
        }

        public void request(long n) {
            try {
                SoloDoOnLifecycle.this.onRequest.accept(n);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
            this.upstream.request(n);
        }

        public int requestFusion(int mode) {
            QueueSubscription qs = this.queue;
            if (qs != null) {
                int m;
                this.sourceMode = m = qs.requestFusion(mode);
                return m;
            }
            return 0;
        }

        public T poll() throws Exception {
            Object v = this.queue.poll();
            if (v != null) {
                SoloDoOnLifecycle.this.onNext.accept(v);
                SoloDoOnLifecycle.this.onAfterNext.accept(v);
            } else if (this.sourceMode == 1) {
                SoloDoOnLifecycle.this.onComplete.run();
                SoloDoOnLifecycle.this.onAfterTerminate.run();
            }
            return v;
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void clear() {
            this.queue.clear();
        }
    }
}

