/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SoloProcessor<T>
extends Solo<T>
implements Processor<T, T> {
    static final InnerSubscription[] EMPTY = new InnerSubscription[0];
    static final InnerSubscription[] TERMINATED = new InnerSubscription[0];
    final AtomicReference<InnerSubscription<T>[]> subscribers = new AtomicReference<InnerSubscription[]>(EMPTY);
    final AtomicBoolean once = new AtomicBoolean();
    T value;
    Throwable error;

    public static <T> SoloProcessor<T> create() {
        return new SoloProcessor<T>();
    }

    private SoloProcessor() {
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        InnerSubscription<? super T> inner = new InnerSubscription<T>(s, this);
        s.onSubscribe(inner);
        if (this.add(inner)) {
            if (inner.isCancelled()) {
                this.remove(inner);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                inner.error(ex);
            } else {
                inner.complete(this.value);
            }
        }
    }

    public void onSubscribe(Subscription s) {
        if (this.subscribers.get() == TERMINATED) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T t) {
        if (this.once.compareAndSet(false, true)) {
            this.value = t;
            for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                inner.complete(t);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.once.compareAndSet(false, true)) {
            this.error = t;
            for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                inner.error(t);
            }
        } else {
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    public void onComplete() {
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            NoSuchElementException t = new NoSuchElementException();
            this.error = t;
            for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                inner.error(t);
            }
        }
    }

    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    public boolean hasValue() {
        return this.subscribers.get() == TERMINATED && this.value != null;
    }

    public T getValue() {
        return this.subscribers.get() == TERMINATED ? (T)this.value : null;
    }

    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    public Throwable getThrowable() {
        return this.subscribers.get() == TERMINATED ? this.error : null;
    }

    boolean add(InnerSubscription<T> inner) {
        InnerSubscription[] b;
        InnerSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new InnerSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(InnerSubscription<T> inner) {
        InnerSubscription[] b;
        InnerSubscription<T>[] a;
        do {
            int n;
            if ((n = (a = this.subscribers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new InnerSubscription[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    static final class InnerSubscription<T>
    extends DeferredScalarSubscription<T> {
        final SoloProcessor<T> parent;
        private static final long serialVersionUID = -8241863418761502064L;

        InnerSubscription(Subscriber<? super T> downstream, SoloProcessor<T> parent) {
            super(downstream);
            this.parent = parent;
        }

        public void cancel() {
            super.cancel();
            this.parent.remove(this);
        }

        void error(Throwable ex) {
            this.downstream.onError(ex);
        }
    }
}

