/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloRetry<T>
extends Solo<T> {
    final Solo<T> source;
    final long times;

    SoloRetry(Solo<T> source, long times) {
        this.source = source;
        this.times = times;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        RetrySubscriber<T> parent = new RetrySubscriber<T>(s, this.times, this.source);
        s.onSubscribe(parent);
        parent.subscribeNext();
    }

    static final class RetrySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -1726278593241855499L;
        final AtomicInteger wip;
        final AtomicReference<Subscription> upstream;
        final Solo<T> source;
        long times;
        volatile boolean active;

        RetrySubscriber(Subscriber<? super T> downstream, long times, Solo<T> source) {
            super(downstream);
            this.times = times;
            this.source = source;
            this.wip = new AtomicInteger();
            this.upstream = new AtomicReference();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.replace(this.upstream, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            long c = this.times;
            if (c != Long.MAX_VALUE) {
                if (--c == 0L) {
                    this.downstream.onError(t);
                    return;
                }
                this.times = c;
            }
            this.active = false;
            this.subscribeNext();
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (SubscriptionHelper.isCancelled((Subscription)this.upstream.get())) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.source.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        public void onComplete() {
            Object v = this.value;
            if (v != null) {
                this.value = null;
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            SubscriptionHelper.cancel(this.upstream);
        }
    }
}

