/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloRetryWhen<T>
extends Solo<T> {
    final Solo<T> source;
    final Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler;

    SoloRetryWhen(Solo<T> source, Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler) {
        this.source = source;
        this.handler = handler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        Publisher when;
        FlowableProcessor pp = PublishProcessor.create().toSerialized();
        try {
            when = (Publisher)ObjectHelper.requireNonNull((Object)this.handler.apply((Object)pp), (String)"The handler returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        RetrySubscriber<T> parent = new RetrySubscriber<T>(s, (FlowableProcessor<Throwable>)pp, this.source);
        s.onSubscribe(parent);
        when.subscribe((Subscriber)parent.other);
        parent.subscribeNext();
    }

    static final class RetrySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -1726278593241855499L;
        final AtomicInteger wip;
        final AtomicReference<Subscription> upstream;
        final Solo<T> source;
        final FlowableProcessor<Throwable> signal;
        final OtherSubscriber other;
        final AtomicBoolean once;
        volatile boolean active;

        RetrySubscriber(Subscriber<? super T> downstream, FlowableProcessor<Throwable> signal, Solo<T> source) {
            super(downstream);
            this.signal = signal;
            this.source = source;
            this.other = new OtherSubscriber();
            this.wip = new AtomicInteger();
            this.upstream = new AtomicReference();
            this.once = new AtomicBoolean();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.replace(this.upstream, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.active = false;
            this.other.requestOne();
            this.signal.onNext((Object)t);
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (SubscriptionHelper.isCancelled((Subscription)this.upstream.get())) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.source.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        public void onComplete() {
            SubscriptionHelper.cancel((AtomicReference)this.other);
            if (this.once.compareAndSet(false, true)) {
                Object v = this.value;
                this.value = null;
                this.complete(v);
            }
        }

        public void cancel() {
            super.cancel();
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel((AtomicReference)this.other);
        }

        void otherError(Throwable ex) {
            SubscriptionHelper.cancel(this.upstream);
            if (this.once.compareAndSet(false, true)) {
                this.downstream.onError(ex);
            } else {
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        void otherComplete() {
            SubscriptionHelper.cancel(this.upstream);
            if (this.once.compareAndSet(false, true)) {
                this.downstream.onError((Throwable)new NoSuchElementException());
            }
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = -790600520757208416L;
            final AtomicLong requested = new AtomicLong();

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.deferredSetOnce((AtomicReference)this, (AtomicLong)this.requested, (Subscription)s);
            }

            public void onNext(Object t) {
                RetrySubscriber.this.subscribeNext();
            }

            public void onError(Throwable t) {
                RetrySubscriber.this.otherError(t);
            }

            public void onComplete() {
                RetrySubscriber.this.otherComplete();
            }

            void requestOne() {
                SubscriptionHelper.deferredRequest((AtomicReference)this, (AtomicLong)this.requested, (long)1L);
            }
        }
    }
}

