/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.ObservableWithSource;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.internal.observers.DeferredScalarObserver;

public class ObservableSumDouble
extends ObservableWithSource<Double, Double> {
    public ObservableSumDouble(ObservableSource<Double> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Double> observer) {
        this.source.subscribe((Observer)new SumDoubleObserver(observer));
    }

    static final class SumDoubleObserver
    extends DeferredScalarObserver<Double, Double> {
        private static final long serialVersionUID = -769098775594601087L;
        double accumulator;
        boolean hasValue;

        SumDoubleObserver(Observer<? super Double> downstream) {
            super(downstream);
        }

        public void onNext(Double value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.doubleValue();
        }

        public void onComplete() {
            if (this.hasValue) {
                this.complete(this.accumulator);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

