/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Maybe;
import io.reactivex.MaybeConverter;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class MaybeFlatMapSignalFlowable<T, R>
extends Flowable<R>
implements MaybeConverter<T, Flowable<R>> {
    final Maybe<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> onSuccessHandler;
    final Function<? super Throwable, ? extends Publisher<? extends R>> onErrorHandler;
    final Callable<? extends Publisher<? extends R>> onCompleteHandler;

    MaybeFlatMapSignalFlowable(Maybe<T> source, Function<? super T, ? extends Publisher<? extends R>> onSuccessHandler, Function<? super Throwable, ? extends Publisher<? extends R>> onErrorHandler, Callable<? extends Publisher<? extends R>> onCompleteHandler) {
        this.source = source;
        this.onSuccessHandler = onSuccessHandler;
        this.onErrorHandler = onErrorHandler;
        this.onCompleteHandler = onCompleteHandler;
    }

    public Flowable<R> apply(Maybe<T> t) {
        return new MaybeFlatMapSignalFlowable<T, R>(t, this.onSuccessHandler, this.onErrorHandler, this.onCompleteHandler);
    }

    protected void subscribeActual(Subscriber<? super R> subscriber) {
        this.source.subscribe(new FlatMapSignalConsumer<T, R>(subscriber, this.onSuccessHandler, this.onErrorHandler, this.onCompleteHandler));
    }

    static final class FlatMapSignalConsumer<T, R>
    implements MaybeObserver<T>,
    Subscription {
        final SignalConsumer<R> consumer;
        final Function<? super T, ? extends Publisher<? extends R>> onSuccessHandler;
        final Function<? super Throwable, ? extends Publisher<? extends R>> onErrorHandler;
        final Callable<? extends Publisher<? extends R>> onCompleteHandler;
        Disposable upstream;

        FlatMapSignalConsumer(Subscriber<? super R> downstream, Function<? super T, ? extends Publisher<? extends R>> onSuccessHandler, Function<? super Throwable, ? extends Publisher<? extends R>> onErrorHandler, Callable<? extends Publisher<? extends R>> onCompleteHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onSuccessHandler = onSuccessHandler;
            this.onErrorHandler = onErrorHandler;
            this.onCompleteHandler = onCompleteHandler;
        }

        public void cancel() {
            this.upstream.dispose();
            SubscriptionHelper.cancel(this.consumer);
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.consumer, (AtomicLong)this.consumer.requested, (long)n);
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.upstream, (Disposable)d)) {
                this.upstream = d;
                this.consumer.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onSuccess(T t) {
            Publisher next;
            try {
                next = (Publisher)ObjectHelper.requireNonNull((Object)this.onSuccessHandler.apply(t), (String)"The onSuccessHandler returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onComplete() {
            Publisher next;
            try {
                next = (Publisher)ObjectHelper.requireNonNull(this.onCompleteHandler.call(), (String)"The onCompleteHandler returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            Publisher next;
            try {
                next = (Publisher)ObjectHelper.requireNonNull((Object)this.onErrorHandler.apply((Object)e), (String)"The onErrorHandler returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final Subscriber<? super R> downstream;
            final AtomicLong requested;

            SignalConsumer(Subscriber<? super R> downstream) {
                this.downstream = downstream;
                this.requested = new AtomicLong();
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.deferredSetOnce((AtomicReference)this, (AtomicLong)this.requested, (Subscription)s);
            }

            public void onNext(R t) {
                this.downstream.onNext(t);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

