/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableFilterAsync<T>
extends Observable<T>
implements ObservableTransformer<T, T> {
    final ObservableSource<T> source;
    final Function<? super T, ? extends ObservableSource<Boolean>> asyncPredicate;
    final int capacityHint;

    ObservableFilterAsync(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<Boolean>> asyncPredicate, int capacityHint) {
        this.source = source;
        this.asyncPredicate = asyncPredicate;
        this.capacityHint = capacityHint;
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new ObservableFilterAsync<T>(upstream, this.asyncPredicate, this.capacityHint);
    }

    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new FilterAsyncObserver<T>(observer, this.asyncPredicate, this.capacityHint));
    }

    static final class FilterAsyncObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -204261674817426393L;
        final Observer<? super T> downstream;
        final Function<? super T, ? extends ObservableSource<Boolean>> asyncPredicate;
        final SpscLinkedArrayQueue<T> queue;
        final AtomicThrowable errors;
        final AtomicReference<Disposable> innerDisposable;
        Disposable upstream;
        volatile boolean done;
        volatile boolean disposed;
        T current;
        volatile int state;
        static final int STATE_FRESH = 0;
        static final int STATE_RUNNING = 1;
        static final int STATE_TRUE = 2;
        static final int STATE_FALSE = 3;

        FilterAsyncObserver(Observer<? super T> downstream, Function<? super T, ? extends ObservableSource<Boolean>> asyncPredicate, int capacityHint) {
            this.downstream = downstream;
            this.asyncPredicate = asyncPredicate;
            this.queue = new SpscLinkedArrayQueue(capacityHint);
            this.errors = new AtomicThrowable();
            this.innerDisposable = new AtomicReference();
        }

        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            DisposableHelper.dispose(this.innerDisposable);
            this.drain();
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.upstream, (Disposable)d)) {
                this.upstream = d;
                this.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        public void onError(Throwable e) {
            DisposableHelper.dispose(this.innerDisposable);
            if (this.errors.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            while (true) {
                block8: {
                    int s;
                    block9: {
                        ObservableSource innerSource;
                        boolean empty;
                        Object item;
                        block10: {
                            block7: {
                                if (!this.disposed) break block7;
                                this.current = null;
                                this.queue.clear();
                                break block8;
                            }
                            if (this.errors.get() != null) {
                                Throwable ex = this.errors.terminate();
                                this.disposed = true;
                                this.downstream.onError(ex);
                                continue;
                            }
                            s = this.state;
                            if (s != 0) break block9;
                            boolean d = this.done;
                            item = this.queue.poll();
                            boolean bl = empty = item == null;
                            if (!d || !empty) break block10;
                            this.downstream.onComplete();
                            break block8;
                        }
                        if (empty) break block8;
                        this.current = item;
                        try {
                            innerSource = (ObservableSource)ObjectHelper.requireNonNull((Object)this.asyncPredicate.apply(item), (String)"The mapper returned a null ObservableSource");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.upstream.dispose();
                            this.errors.addThrowable(ex);
                            ex = this.errors.terminate();
                            this.disposed = true;
                            this.downstream.onError(ex);
                            continue;
                        }
                        this.state = 1;
                        innerSource.subscribe((Observer)new InnerObserver());
                        break block8;
                    }
                    if (s == 2) {
                        T mainItem = this.current;
                        this.current = null;
                        this.downstream.onNext(mainItem);
                        this.state = 0;
                        continue;
                    }
                    if (s == 3) {
                        this.current = null;
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void innerSuccess(boolean value) {
            this.state = value ? 2 : 3;
            DisposableHelper.replace(this.innerDisposable, null);
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.addThrowable(ex)) {
                this.state = 3;
                DisposableHelper.replace(this.innerDisposable, null);
                this.upstream.dispose();
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        void innerComplete() {
            this.state = 3;
            DisposableHelper.replace(this.innerDisposable, null);
            this.drain();
        }

        final class InnerObserver
        implements Observer<Boolean> {
            boolean once;

            InnerObserver() {
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(FilterAsyncObserver.this.innerDisposable, (Disposable)d);
            }

            public void onNext(Boolean t) {
                if (!this.once) {
                    this.once = true;
                    FilterAsyncObserver.this.innerDisposable.get().dispose();
                    FilterAsyncObserver.this.innerSuccess(t);
                }
            }

            public void onError(Throwable e) {
                if (!this.once) {
                    FilterAsyncObserver.this.innerError(e);
                } else {
                    RxJavaPlugins.onError((Throwable)e);
                }
            }

            public void onComplete() {
                if (!this.once) {
                    FilterAsyncObserver.this.innerComplete();
                }
            }
        }
    }
}

