/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.observers.DeferredScalarObserver;

final class ObservableIndexOf<T>
extends Observable<Long>
implements ObservableTransformer<T, Long> {
    final Observable<T> source;
    final Predicate<? super T> predicate;

    ObservableIndexOf(Observable<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    public ObservableSource<Long> apply(Observable<T> upstream) {
        return new ObservableIndexOf<T>(upstream, this.predicate);
    }

    protected void subscribeActual(Observer<? super Long> observer) {
        this.source.subscribe(new IndexOfObserver<T>(observer, this.predicate));
    }

    static final class IndexOfObserver<T>
    extends DeferredScalarObserver<T, Long> {
        private static final long serialVersionUID = 4809092721669178986L;
        final Predicate<? super T> predicate;
        long index;
        boolean found;

        IndexOfObserver(Observer<? super Long> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        public void onNext(T t) {
            try {
                long idx = this.index;
                if (this.predicate.test(t)) {
                    this.found = true;
                    this.upstream.dispose();
                    this.complete(idx);
                    return;
                }
                this.index = idx + 1L;
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.found = true;
                this.upstream.dispose();
                this.onError(ex);
                return;
            }
        }

        public void onComplete() {
            if (!this.found) {
                this.complete(-1L);
            }
        }
    }
}

