/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleConverter;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.atomic.AtomicReference;

final class SingleFlatMapSignalObservable<T, R>
extends Observable<R>
implements SingleConverter<T, Observable<R>> {
    final Single<T> source;
    final Function<? super T, ? extends ObservableSource<? extends R>> onSuccessHandler;
    final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler;

    SingleFlatMapSignalObservable(Single<T> source, Function<? super T, ? extends ObservableSource<? extends R>> onSuccessHandler, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler) {
        this.source = source;
        this.onSuccessHandler = onSuccessHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public Observable<R> apply(Single<T> t) {
        return new SingleFlatMapSignalObservable<T, R>(t, this.onSuccessHandler, this.onErrorHandler);
    }

    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlatMapSignalConsumer<T, R>(observer, this.onSuccessHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer<T, R>
    implements SingleObserver<T>,
    Disposable {
        final SignalConsumer<R> consumer;
        final Function<? super T, ? extends ObservableSource<? extends R>> onSuccessHandler;
        final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler;

        FlatMapSignalConsumer(Observer<? super R> downstream, Function<? super T, ? extends ObservableSource<? extends R>> onSuccessHandler, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onSuccessHandler = onSuccessHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void dispose() {
            DisposableHelper.dispose(this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onSuccess(T t) {
            ObservableSource next;
            try {
                next = (ObservableSource)ObjectHelper.requireNonNull((Object)this.onSuccessHandler.apply(t), (String)"The onSuccessHandler returned a null ObservableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            ObservableSource next;
            try {
                next = (ObservableSource)ObjectHelper.requireNonNull((Object)this.onErrorHandler.apply((Object)e), (String)"The onErrorHandler returned a null ObservableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Disposable>
        implements Observer<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final Observer<? super R> downstream;

            SignalConsumer(Observer<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onNext(R t) {
                this.downstream.onNext(t);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

