/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import hu.akarnokd.rxjava.interop.ObservableV1ToFlowableV2;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import rx.subjects.Subject;

final class SubjectV1ToProcessorV2<T>
extends FlowableProcessor<T> {
    final Subject<T, T> source;
    volatile boolean terminated;
    Throwable error;

    SubjectV1ToProcessorV2(Subject<T, T> source) {
        this.source = source;
    }

    public void onSubscribe(Subscription s) {
        if (this.terminated) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T t) {
        if (!this.terminated) {
            if (t == null) {
                this.onError(new NullPointerException());
            } else {
                this.source.onNext(t);
            }
        }
    }

    public void onError(Throwable e) {
        if (!this.terminated) {
            if (e == null) {
                e = new NullPointerException("Throwable was null");
            }
            this.error = e;
            this.terminated = true;
            this.source.onError(e);
        } else {
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public void onComplete() {
        if (!this.terminated) {
            this.terminated = true;
            this.source.onCompleted();
        }
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        ObservableV1ToFlowableV2.ObservableSubscriber<? super T> parent = new ObservableV1ToFlowableV2.ObservableSubscriber<T>(s);
        ObservableV1ToFlowableV2.ObservableSubscriberSubscription parentSubscription = new ObservableV1ToFlowableV2.ObservableSubscriberSubscription(parent);
        s.onSubscribe((Subscription)parentSubscription);
        this.source.unsafeSubscribe(parent);
    }

    public boolean hasSubscribers() {
        return this.source.hasObservers();
    }

    public boolean hasComplete() {
        return this.terminated && this.error == null;
    }

    public boolean hasThrowable() {
        return this.terminated && this.error != null;
    }

    public Throwable getThrowable() {
        return this.terminated ? this.error : null;
    }
}

