/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFBase;
import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFHeader;
import com.linuxense.javadbf.DBFUtils;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DBFReader
extends DBFBase {
    private DataInputStream dataInputStream;
    private DBFHeader header;
    private static final long MILLISECS_PER_DAY = 86400000L;
    private static final long MILLIS_SINCE_4713 = -210866803200000L;

    public DBFReader(InputStream in, Charset charset) throws DBFException {
        try {
            this.dataInputStream = new DataInputStream(in);
            this.header = new DBFHeader();
            this.header.read(this.dataInputStream, charset);
            this.setCharset(this.header.getUsedCharset());
            int t_dataStartIndex = this.header.headerLength - (32 + 32 * this.header.fieldArray.length) - 1;
            this.skip(t_dataStartIndex);
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage(), e);
        }
    }

    public DBFReader(InputStream in) throws DBFException {
        this(in, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.header.getYear()).append("/");
        sb.append(this.header.getMonth()).append("/");
        sb.append(this.header.getDay()).append("\n");
        sb.append("Total records: ").append(this.header.numberOfRecords).append("\n");
        sb.append("Header length: ").append(this.header.headerLength).append("\n");
        sb.append("Columns:\n");
        for (DBFField field : this.header.fieldArray) {
            sb.append(field.getName());
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getRecordCount() {
        return this.header.numberOfRecords;
    }

    public Date getLastModificationDate() {
        if (this.header != null) {
            return this.header.getLastModificationDate();
        }
        return null;
    }

    public DBFField getField(int index) throws DBFException {
        return this.header.fieldArray[index];
    }

    public int getFieldCount() throws DBFException {
        return this.header.fieldArray.length;
    }

    public Object[] nextRecord() throws DBFException {
        Object[] recordObjects = new Object[this.header.fieldArray.length];
        try {
            byte t_byte;
            boolean isDeleted = false;
            do {
                if (isDeleted) {
                    this.skip(this.header.recordLength - 1);
                }
                if ((t_byte = this.dataInputStream.readByte()) != 26) continue;
                return null;
            } while (isDeleted = t_byte == 42);
            block17: for (int i = 0; i < this.header.fieldArray.length; ++i) {
                switch (this.header.fieldArray[i].getType()) {
                    case CHARACTER: {
                        byte[] b_array = new byte[this.header.fieldArray[i].getFieldLength()];
                        this.dataInputStream.read(b_array);
                        recordObjects[i] = new String(b_array, this.getCharset());
                        continue block17;
                    }
                    case DATE: {
                        byte[] t_byte_year = new byte[4];
                        this.dataInputStream.read(t_byte_year);
                        byte[] t_byte_month = new byte[2];
                        this.dataInputStream.read(t_byte_month);
                        byte[] t_byte_day = new byte[2];
                        this.dataInputStream.read(t_byte_day);
                        try {
                            GregorianCalendar calendar = new GregorianCalendar(Integer.parseInt(new String(t_byte_year, StandardCharsets.US_ASCII)), Integer.parseInt(new String(t_byte_month, StandardCharsets.US_ASCII)) - 1, Integer.parseInt(new String(t_byte_day, StandardCharsets.US_ASCII)));
                            recordObjects[i] = calendar.getTime();
                        }
                        catch (NumberFormatException e) {
                            recordObjects[i] = null;
                        }
                        continue block17;
                    }
                    case FLOATING_POINT: 
                    case NUMERIC: {
                        try {
                            byte[] t_float = new byte[this.header.fieldArray[i].getFieldLength()];
                            this.dataInputStream.read(t_float);
                            t_float = DBFUtils.removeSpaces(t_float);
                            if (t_float.length > 0 && !DBFUtils.contains(t_float, (byte)63) && !DBFUtils.contains(t_float, (byte)42)) {
                                recordObjects[i] = new Double(new String(t_float, StandardCharsets.US_ASCII));
                                continue block17;
                            }
                            recordObjects[i] = null;
                            continue block17;
                        }
                        catch (NumberFormatException e) {
                            throw new DBFException("Failed to parse Float: " + e.getMessage(), e);
                        }
                    }
                    case LOGICAL: {
                        byte t_logical = this.dataInputStream.readByte();
                        recordObjects[i] = DBFUtils.toBoolean(t_logical);
                        continue block17;
                    }
                    case LONG: {
                        int data = DBFUtils.readLittleEndianInt(this.dataInputStream);
                        recordObjects[i] = data;
                        continue block17;
                    }
                    case CURRENCY: {
                        int c_data = DBFUtils.readLittleEndianInt(this.dataInputStream);
                        String s_data = String.format("%05d", c_data);
                        String x1 = s_data.substring(0, s_data.length() - 4);
                        String x2 = s_data.substring(s_data.length() - 4);
                        recordObjects[i] = new BigDecimal(x1 + "." + x2);
                        this.skip(this.header.fieldArray[i].getFieldLength() - 4);
                        continue block17;
                    }
                    case TIMESTAMP: {
                        byte[] t_byte_date = new byte[4];
                        this.dataInputStream.read(t_byte_date);
                        byte[] t_byte_date_reversed = new byte[]{t_byte_date[3], t_byte_date[2], t_byte_date[1], t_byte_date[0]};
                        int days = ByteBuffer.wrap(t_byte_date_reversed).getInt();
                        byte[] t_byte_time = new byte[4];
                        this.dataInputStream.read(t_byte_time);
                        byte[] t_byte_time_reversed = new byte[]{t_byte_time[3], t_byte_time[2], t_byte_time[1], t_byte_time[0]};
                        int time = ByteBuffer.wrap(t_byte_time_reversed).getInt();
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTimeInMillis((long)days * 86400000L + -210866803200000L + (long)time);
                        ((Calendar)calendar).add(14, -TimeZone.getDefault().getOffset(calendar.getTimeInMillis()));
                        if (days == 0 && time == 0) {
                            recordObjects[i] = null;
                            continue block17;
                        }
                        recordObjects[i] = calendar.getTime();
                        continue block17;
                    }
                    default: {
                        this.skip(this.header.fieldArray[i].getFieldLength());
                        recordObjects[i] = "null";
                    }
                }
            }
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage(), e);
        }
        return recordObjects;
    }

    private void skip(int n) throws IOException {
        int skipped;
        for (int i = skipped = (int)this.dataInputStream.skip(n); i < n; ++i) {
            this.dataInputStream.readByte();
        }
    }

    protected DBFHeader getHeader() {
        return this.header;
    }
}

