/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.thymeleaf.processor;

import com.github.dandelion.core.web.AssetRequestContext;
import com.github.dandelion.thymeleaf.dialect.AssetAttributeNames;
import com.github.dandelion.thymeleaf.processor.DandelionAttrProcessor;
import com.github.dandelion.thymeleaf.util.ArgumentsUtil;
import com.github.dandelion.thymeleaf.util.AttributesUtil;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.ProcessorResult;

public class AssetAttrProcessor
extends DandelionAttrProcessor {
    public AssetAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    public int getPrecedence() {
        return 3501;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName) {
        String strippedAttributeName = AttributesUtil.stripPrefix(attributeName, "ddl");
        AssetAttributeNames assetsAttributeName = (AssetAttributeNames)AttributesUtil.find(strippedAttributeName, AssetAttributeNames.values());
        HttpServletRequest request = ArgumentsUtil.getWebContext(arguments).getHttpServletRequest();
        AssetRequestContext context = AssetRequestContext.get((ServletRequest)request);
        switch (assetsAttributeName) {
            case JS_EXCLUDES: {
                context.excludeJs(element.getAttributeValue(attributeName));
                break;
            }
            case CSS_EXCLUDES: {
                context.excludeCss(element.getAttributeValue(attributeName));
            }
        }
        return ProcessorResult.ok();
    }
}

