/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.thymeleaf.processor;

import com.github.dandelion.core.web.AssetRequestContext;
import com.github.dandelion.thymeleaf.dialect.BundleAttributeNames;
import com.github.dandelion.thymeleaf.processor.DandelionAttrProcessor;
import com.github.dandelion.thymeleaf.util.ArgumentsUtil;
import com.github.dandelion.thymeleaf.util.AttributesUtil;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.ProcessorResult;

public class BundleAttrProcessor
extends DandelionAttrProcessor {
    public BundleAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    public int getPrecedence() {
        return 3500;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName) {
        String strippedAttributeName = AttributesUtil.stripPrefix(attributeName, "ddl");
        BundleAttributeNames assetsAttributeName = (BundleAttributeNames)AttributesUtil.find(strippedAttributeName, BundleAttributeNames.values());
        HttpServletRequest request = ArgumentsUtil.getWebContext(arguments).getHttpServletRequest();
        AssetRequestContext context = AssetRequestContext.get((ServletRequest)request);
        switch (assetsAttributeName) {
            case INCLUDES: {
                context.addBundles(element.getAttributeValue(attributeName));
                break;
            }
            case EXCLUDES: {
                context.excludeBundles(element.getAttributeValue(attributeName));
            }
        }
        return ProcessorResult.ok();
    }
}

