/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.measurements;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.HttpInfluxdbProtocol;
import metrics_influxdb.measurements.Measure;
import metrics_influxdb.measurements.QueueableSender;
import metrics_influxdb.misc.Miscellaneous;
import metrics_influxdb.serialization.line.Inliner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInlinerSender
extends QueueableSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpInlinerSender.class);
    private static int MAX_MEASURES_IN_SINGLE_POST = 5000;
    private final URL writeURL;
    private final Inliner inliner = new Inliner(TimeUnit.MILLISECONDS);
    private final long connectTimeout;
    private final long readTimeout;

    public HttpInlinerSender(HttpInfluxdbProtocol protocol) {
        super(MAX_MEASURES_IN_SINGLE_POST);
        URL toJoin;
        this.connectTimeout = protocol.connectTimeout;
        this.readTimeout = protocol.readTimeout;
        try {
            toJoin = protocol.secured ? new URL(protocol.scheme, protocol.host, protocol.port, "/write?precision=ms&db=" + Miscellaneous.urlEncode(protocol.database) + "&u=" + Miscellaneous.urlEncode(protocol.user) + "&p=" + Miscellaneous.urlEncode(protocol.password)) : new URL(protocol.scheme, protocol.host, protocol.port, "/write?precision=ms&db=" + Miscellaneous.urlEncode(protocol.database));
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            toJoin = null;
        }
        this.writeURL = toJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSend(Collection<Measure> measures) {
        if (measures.isEmpty()) {
            return true;
        }
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)this.writeURL.openConnection();
            con.setRequestMethod("POST");
            con.setConnectTimeout(Long.valueOf(TimeUnit.SECONDS.toMillis(this.connectTimeout)).intValue());
            con.setReadTimeout(Long.valueOf(TimeUnit.SECONDS.toMillis(this.readTimeout)).intValue());
            con.setDoOutput(true);
            OutputStream wr = con.getOutputStream();
            String measuresAsString = this.inliner.inline(measures);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Measures being sent:\n{}", (Object)measuresAsString);
            }
            wr.write(measuresAsString.getBytes(Miscellaneous.UTF8));
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            switch (responseCode) {
                case 204: {
                    LOGGER.debug("{} Measures sent to {}://{}:{}", new Object[]{measures.size(), this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort()});
                    break;
                }
                case 200: {
                    LOGGER.info("{} Measures sent to {}://{}:{} but not saved by infludb, reason:\n{}", new Object[]{measures.size(), this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort(), Miscellaneous.readFrom(con.getInputStream())});
                    break;
                }
                default: {
                    LOGGER.info("failed to send {} Measures to {}://{}:{}, HTTP CODE received: {}\n", new Object[]{measures.size(), this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort(), responseCode, Miscellaneous.readFrom(con.getInputStream())});
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.warn("couldn't sent metrics to {}://{}:{}, reason: {}", new Object[]{this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort(), e.getMessage(), e});
        }
        finally {
            if (con != null) {
                try {
                    con.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }
}

